/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.client.ICustomItemRendererProvider;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.mehvahdjukaar.moonlight.api.fluids.FoodProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.util.PotionNBTHelper;
import net.mehvahdjukaar.supplementaries.client.renderers.items.JarItemRenderer;
import net.mehvahdjukaar.supplementaries.common.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.AbstractMobContainerItem;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BucketHelper;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5328;
import org.jetbrains.annotations.Nullable;

public class JarItem
extends AbstractMobContainerItem
implements ICustomItemRendererProvider {
    public JarItem(class_2248 blockIn, class_1792.class_1793 properties) {
        super(blockIn, properties, 0.625f, 0.875f, true);
    }

    @Override
    public boolean canItemCatch(class_1297 e) {
        class_1309 le;
        class_1299 type = e.method_5864();
        if (CommonConfigs.Functional.JAR_AUTO_DETECT.get().booleanValue() && this.canFitEntity(e) && !(e instanceof class_1588)) {
            return true;
        }
        return type.method_20210(ModTags.JAR_CATCHABLE) || type.method_20210(ModTags.JAR_BABY_CATCHABLE) && e instanceof class_1309 && (le = (class_1309)e).method_6109() || this.isBoat(e) || BucketHelper.isModdedFish(e);
    }

    @Override
    public void playReleaseSound(class_1937 world, class_243 v) {
        world.method_43128(null, v.method_10216(), v.method_10214(), v.method_10215(), class_3417.field_15219, class_3419.field_15248, 1.0f, 0.05f);
    }

    @Override
    public void playCatchSound(class_1657 player) {
        player.method_37908().method_8396(null, player.method_24515(), class_3417.field_14883, class_3419.field_15248, 1.0f, 1.0f);
    }

    @Override
    public class_1799 saveEntityInItem(class_1297 entity, class_1799 currentStack, class_1799 bucket) {
        if (this.isBoat(entity)) {
            return new class_1799((class_1935)ModRegistry.JAR_BOAT.get());
        }
        return super.saveEntityInItem(entity, currentStack, bucket);
    }

    public boolean isBoat(class_1297 e) {
        return e instanceof class_1690;
    }

    @Override
    public class_1269 doInteract(class_1799 stack, class_1657 player, class_1297 entity, class_1268 hand) {
        if (!this.captureEnabled().booleanValue()) {
            return class_1269.field_5811;
        }
        return super.doInteract(stack, player, entity, hand);
    }

    private Boolean captureEnabled() {
        return CommonConfigs.Functional.JAR_CAPTURE.get();
    }

    @Override
    public boolean blocksPlacement() {
        return this.captureEnabled();
    }

    @Override
    public void addPlacementTooltip(List<class_2561> tooltip) {
        if (this.captureEnabled().booleanValue()) {
            super.addPlacementTooltip(tooltip);
        }
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        class_2487 compoundTag = stack.method_7941("BlockEntityTag");
        if (compoundTag == null) {
            if (!MiscUtils.showsHints((class_1922)worldIn, flagIn)) {
                return;
            }
            tooltip.add((class_2561)class_2561.method_43471((String)"message.supplementaries.jar").method_27692(class_124.field_1056).method_27692(class_124.field_1080));
        } else {
            class_2487 com;
            SoftFluidStack fluid;
            if (compoundTag.method_10573("LootTable", 8)) {
                tooltip.add((class_2561)class_2561.method_43470((String)"???????").method_27692(class_124.field_1080));
            }
            if (compoundTag.method_10545("FluidHolder") && !(fluid = SoftFluidStack.load((class_2487)(com = compoundTag.method_10562("FluidHolder")))).isEmpty()) {
                String bottle;
                class_2487 nbt = null;
                Object add = "";
                if (fluid.hasTag() && (nbt = fluid.getTag()).method_10545("Bottle") && !(bottle = nbt.method_10558("Bottle").toLowerCase(Locale.ROOT)).equals("regular")) {
                    add = "_" + bottle;
                }
                tooltip.add((class_2561)class_2561.method_43469((String)"message.supplementaries.fluid_tooltip", (Object[])new Object[]{class_2561.method_43471((String)(fluid.fluid().getTranslationKey() + (String)add)), fluid.getCount()}).method_27692(class_124.field_1080));
                if (nbt != null) {
                    PotionNBTHelper.addPotionTooltip((class_2487)nbt, tooltip, (float)1.0f);
                    return;
                }
            }
            if (compoundTag.method_10573("Items", 9)) {
                class_2371 nonnulllist = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
                class_1262.method_5429((class_2487)compoundTag, (class_2371)nonnulllist);
                int i = 0;
                int j = 0;
                for (class_1799 itemstack : nonnulllist) {
                    if (itemstack.method_7960()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    class_5250 iformattabletextcomponent = itemstack.method_7964().method_27661();
                    String s = iformattabletextcomponent.getString();
                    s = s.replace(" Bucket", "");
                    s = s.replace(" Bottle", "");
                    s = s.replace("Bucket of ", "");
                    class_5250 str = class_2561.method_43470((String)s);
                    str.method_27693(" x").method_27693(String.valueOf(itemstack.method_7947()));
                    tooltip.add((class_2561)str.method_27692(class_124.field_1080));
                }
                if (j - i > 0) {
                    tooltip.add((class_2561)class_2561.method_43469((String)"container.shulkerBox.more", (Object[])new Object[]{j - i}).method_27692(class_124.field_1056).method_27692(class_124.field_1080));
                }
            }
        }
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 entity) {
        class_2487 tag = stack.method_7941("BlockEntityTag");
        if (tag != null && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            JarBlockTile temp = new JarBlockTile(entity.method_23312(), ModRegistry.JAR.get().method_9564());
            temp.method_11014(tag);
            SoftFluidTank fh = temp.getSoftFluidTank();
            if (fh.containsFood() && fh.tryDrinkUpFluid(player, world)) {
                class_2487 newTag = new class_2487();
                temp.method_11007(newTag);
                stack.method_7959("BlockEntityTag", (class_2520)newTag);
                return stack;
            }
        }
        return stack;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
        if (this.method_7881(playerEntity.method_5998(hand)) != 0) {
            return class_5328.method_29282((class_1937)world, (class_1657)playerEntity, (class_1268)hand);
        }
        return super.method_7836(world, playerEntity, hand);
    }

    public int method_7881(class_1799 stack) {
        class_2487 tag;
        if (CommonConfigs.Functional.JAR_ITEM_DRINK.get().booleanValue() && (tag = stack.method_7941("BlockEntityTag")) != null) {
            JarBlockTile jarBlockTile = new JarBlockTile(class_2338.field_10980, ModRegistry.JAR.get().method_9564());
            jarBlockTile.method_11014(tag);
            SoftFluidTank fh = jarBlockTile.getSoftFluidTank();
            FoodProvider provider = fh.getFluid().getFoodProvider();
            class_1792 food = provider.getFood();
            return food.method_7881(food.method_7854()) / provider.getDivider();
        }
        return 0;
    }

    public class_1839 method_7853(class_1799 stack) {
        if (CommonConfigs.Functional.JAR_ITEM_DRINK.get().booleanValue()) {
            return class_1839.field_8946;
        }
        return class_1839.field_8952;
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1269 r;
        if (CompatHandler.QUARK && this == ModRegistry.JAR_ITEM.get() && (r = QuarkCompat.tryCaptureTater(this, context)).method_23665()) {
            return r;
        }
        return super.method_7884(context);
    }

    public Supplier<ItemStackRenderer> getRendererFactory() {
        return JarItemRenderer::new;
    }
}

