/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.flywheel;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.hardcoded.ModelPart;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.CannonBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CannonBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.minecraft.class_1058;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class CannonInstance
extends BlockEntityInstance<CannonBlockTile>
implements DynamicInstance {
    private final class_1058 texture = ModMaterials.CANNON_MATERIAL.method_24148();
    private final ModelData head;
    private final ModelData headOverlay;
    private final ModelData legs;
    private final ModelData base;
    private final class_4587 stack = new class_4587();

    public CannonInstance(MaterialManager materialManager, CannonBlockTile tile) {
        super(materialManager, (class_2586)tile);
        class_2338 p = this.getInstancePosition();
        this.stack.method_46416((float)p.method_10263(), (float)p.method_10264(), (float)p.method_10260());
        this.stack.method_22905(0.9995f, 0.9995f, 0.9995f);
        this.stack.method_22904(2.5E-4, 2.5E-4, 2.5E-4);
        this.stack.method_22904(0.5, 0.5, 0.5);
        this.legs = this.makeLegsInstance().setTransform(this.stack);
        this.base = this.makeBaseInstance().setTransform(this.stack);
        this.stack.method_22903();
        this.stack.method_46416(0.0f, -0.0625f, 0.0f);
        this.head = this.makeHeadInstance().setTransform(this.stack);
        this.headOverlay = this.makeHeadOverlayInstance().setTransform(this.stack);
        this.stack.method_22909();
    }

    public void beginFrame() {
        float partialTick = AnimationTickHolder.getPartialTicks();
        this.stack.method_22903();
        Quaternionf rotation = ((class_2350)((CannonBlockTile)this.blockEntity).method_11010().method_11654((class_2769)CannonBlock.field_10927)).method_10153().method_23224();
        this.stack.method_22907(rotation);
        this.base.setTransform(this.stack);
        float yawRad = ((CannonBlockTile)this.blockEntity).getYaw(partialTick) * ((float)Math.PI / 180);
        float pitchRad = ((CannonBlockTile)this.blockEntity).getPitch(partialTick) * ((float)Math.PI / 180);
        Vector3f forward = new Vector3f(0.0f, 0.0f, 1.0f);
        forward.rotateX((float)Math.PI - pitchRad);
        forward.rotateY((float)Math.PI - yawRad);
        forward.rotate((Quaternionfc)rotation.invert());
        yawRad = (float)class_3532.method_15349((double)forward.x, (double)forward.z);
        pitchRad = (float)class_3532.method_15349((double)(-forward.y), (double)class_3532.method_15355((float)(forward.x * forward.x + forward.z * forward.z)));
        this.stack.method_22907(class_7833.field_40716.rotation(yawRad));
        this.legs.setTransform(this.stack);
        this.stack.method_46416(0.0f, -0.0625f, 0.0f);
        this.stack.method_22907(class_7833.field_40714.rotation(pitchRad));
        float cooldownCounter = ((CannonBlockTile)this.blockEntity).getCooldownAnimation(partialTick);
        float fireCounter = ((CannonBlockTile)this.blockEntity).getFiringAnimation(partialTick);
        float squish = CannonBlockTileRenderer.triangle(1.0f - cooldownCounter, 0.01f, 0.15f) * 0.2f;
        float wobble = class_3532.method_15374((float)(fireCounter * 20.0f * (float)Math.PI)) * 0.005f;
        float scale = wobble + 1.0f + squish * 0.7f;
        this.stack.method_46416(0.0f, 0.0f, squish * 5.675f / 16.0f);
        this.stack.method_22905(scale, scale, 1.0f - squish);
        this.headOverlay.setTransform(this.stack);
        float overlayScale = 0.95f;
        this.stack.method_22905(overlayScale, overlayScale, overlayScale);
        this.head.setTransform(this.stack);
        this.stack.method_22909();
    }

    public void remove() {
        this.legs.delete();
        this.base.delete();
        this.head.delete();
        this.headOverlay.delete();
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.legs, this.base, this.head, this.headOverlay});
    }

    private ModelData makeLegsInstance() {
        return (ModelData)this.materialManager.defaultCutout().material(Materials.TRANSFORMED).model((Object)("legs_" + String.valueOf(((CannonBlockTile)this.blockEntity).method_11017())), this::makeLegs).createInstance();
    }

    private ModelData makeBaseInstance() {
        return (ModelData)this.materialManager.defaultCutout().material(Materials.TRANSFORMED).model((Object)("base_" + String.valueOf(((CannonBlockTile)this.blockEntity).method_11017())), this::makeBase).createInstance();
    }

    private ModelData makeHeadInstance() {
        return (ModelData)this.materialManager.defaultCutout().material(Materials.TRANSFORMED).model((Object)("head_" + String.valueOf(((CannonBlockTile)this.blockEntity).method_11017())), this::makeHead).createInstance();
    }

    private ModelData makeHeadOverlayInstance() {
        return (ModelData)this.materialManager.defaultCutout().material(Materials.TRANSFORMED).model((Object)("head_overlay_" + String.valueOf(((CannonBlockTile)this.blockEntity).method_11017())), this::makeHeadOverlay).createInstance();
    }

    private ModelPart makeLegs() {
        return ModelPart.builder((String)"legs", (int)64, (int)64).sprite(this.texture).cuboid().textureOffset(0, 0).start(6.0f, -4.0f, -3.0f).size(2.0f, 10.0f, 6.0f).endCuboid().cuboid().textureOffset(48, 0).start(-8.0f, -4.0f, -3.0f).size(2.0f, 10.0f, 6.0f).endCuboid().build();
    }

    private ModelPart makeBase() {
        return ModelPart.builder((String)"base", (int)64, (int)64).sprite(this.texture).cuboid().textureOffset(0, 0).start(-8.0f, 6.0f, -8.0f).size(16.0f, 2.0f, 16.0f).endCuboid().build();
    }

    private ModelPart makeHead() {
        return ModelPart.builder((String)"head", (int)64, (int)64).sprite(this.texture).cuboid().textureOffset(0, 18).start(-6.0f, -6.0f, -6.5f).size(12.0f, 12.0f, 13.0f).endCuboid().build();
    }

    private ModelPart makeHeadOverlay() {
        return ModelPart.builder((String)"head_overlay", (int)64, (int)64).sprite(this.texture).cuboid().textureOffset(0, 46).start(-6.0f, -6.0f, -6.5f).size(12.0f, 12.0f, 6.0f).endCuboid().build();
    }
}

