/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.backported_wolves.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.emilsg.backported_wolves.BackportedWolves;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;

public class BackportedWolvesConfig {
    public static final String FILE_VERSION = "1.1.0";
    private static final Logger LOGGER = BackportedWolves.LOGGER;
    private final Map<String, ConfigEntry<?>> configs;
    private final File configFile;
    private static BackportedWolvesConfig instance;
    private static final String fileName = "backported_wolves.properties";
    public static final String SPAWN_WEIGHT = "spawn_weight";

    public BackportedWolvesConfig(String configFilePath) {
        this.configFile = new File(configFilePath);
        this.configs = new HashMap();
        this.initializeConfigs();
        this.loadOrCreateConfig();
    }

    public static void init() {
        LOGGER.info("Initializing Backported-Wolves Config.");
    }

    public static BackportedWolvesConfig getInstance() {
        if (instance == null) {
            instance = new BackportedWolvesConfig(FabricLoader.getInstance().getConfigDir().resolve(fileName).toString());
        }
        return instance;
    }

    public void initializeConfigs() {
        this.configs.put(SPAWN_WEIGHT, new ConfigEntry<Integer>(8, "Spawn Weight of the Wolves"));
    }

    public boolean isConfigVersionCurrent() {
        if (this.getCurrentFileVersion() != null) {
            return this.getCurrentFileVersion().equals("# File Version: 1.1.0");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCurrentFileVersion() {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.configFile));){
            String line;
            do {
                if ((line = reader.readLine()) == null) return null;
            } while (!line.startsWith("# File Version:"));
            String string = line;
            return string;
        }
        catch (IOException e) {
            LOGGER.error("Error reading config file for version check.", (Throwable)e);
        }
        return null;
    }

    public String getFileVersionNumber(String versionLine) {
        return versionLine.replace("# File Version: ", "");
    }

    private void loadOrCreateConfig() {
        if (this.configFile.exists()) {
            this.loadConfig();
        } else {
            LOGGER.info("Backported-Wolves config file is missing, generating default one.");
            this.createDefaultConfig();
        }
    }

    private void loadConfig() {
        Properties props = new Properties();
        try (FileReader reader = new FileReader(this.configFile);){
            props.load(reader);
            for (Map.Entry<String, ConfigEntry<?>> entry : this.configs.entrySet()) {
                String key = entry.getKey();
                ConfigEntry<?> configEntry = entry.getValue();
                if (!props.containsKey(key)) continue;
                this.updateConfigEntry(key, configEntry, props.getProperty(key));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addMissingConfigsAndUpdateVersion() {
        this.loadConfig();
        StringBuilder newFileContent = new StringBuilder();
        boolean versionMismatch = true;
        boolean changesMade = false;
        try (FileReader reader = new FileReader(this.configFile);
             BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.startsWith("# File Version:")) {
                    if (line.equals("# File Version: 1.1.0")) {
                        versionMismatch = false;
                    } else {
                        line = "# File Version: 1.1.0";
                        changesMade = true;
                    }
                }
                newFileContent.append(line).append("\n");
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to read existing configuration for version check.", (Throwable)e);
        }
        for (Map.Entry<String, ConfigEntry<?>> entry : this.configs.entrySet()) {
            if (newFileContent.toString().contains(entry.getKey() + "=")) continue;
            ConfigEntry<?> configEntry = entry.getValue();
            String key = entry.getKey();
            String value = configEntry.getValue().toString();
            String comment = configEntry.getComment();
            if (comment != null && !comment.isEmpty()) {
                newFileContent.append("\n# ").append(comment).append(" Default value: ").append(value);
            }
            newFileContent.append("\n").append(key).append("=").append(value).append("\n");
            changesMade = true;
        }
        if (changesMade) {
            try (FileWriter writer = new FileWriter(this.configFile, false);){
                writer.write(newFileContent.toString());
                LOGGER.info("Configuration file updated with missing entries and/or version update.");
            }
            catch (IOException e) {
                LOGGER.error("Failed to update configuration file.", (Throwable)e);
            }
        } else {
            LOGGER.info("Configuration file up-to-date. No changes made.");
        }
    }

    private <T> void updateConfigEntry(String key, ConfigEntry<T> configEntry, String value) {
        Object convertedValue = this.convertStringToType(key, value, configEntry.getValue().getClass(), configEntry);
        configEntry.setValue(convertedValue);
    }

    private <T> Object convertStringToType(String key, String value, Class<?> type, ConfigEntry<T> configEntry) {
        try {
            if (Boolean.class.isAssignableFrom(type)) {
                return type.cast(Boolean.parseBoolean(value));
            }
            if (Integer.class.isAssignableFrom(type)) {
                return type.cast(Integer.parseInt(value));
            }
            if (Float.class.isAssignableFrom(type)) {
                return type.cast(Float.valueOf(Float.parseFloat(value)));
            }
            if (Double.class.isAssignableFrom(type)) {
                return type.cast(Double.parseDouble(value));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error converting config value for key '" + key + "' with value '" + value + "'. Please check your backported_wolves.properties file.");
            return configEntry.getDefaultValue();
        }
        throw new IllegalArgumentException("Unsupported type for configuration key '" + key + "': " + String.valueOf(type));
    }

    public void createDefaultConfig() {
        try (FileWriter writer = new FileWriter(this.configFile);){
            writer.write("# File Version: 1.1.0\n\n");
            for (Map.Entry<String, ConfigEntry<?>> entry : this.configs.entrySet()) {
                String key = entry.getKey();
                ConfigEntry<?> configEntry = entry.getValue();
                String value = configEntry.getValue().toString();
                String comment = configEntry.getComment();
                if (comment != null && !comment.isEmpty()) {
                    writer.write("# " + comment + " Default value: " + value + "\n");
                }
                writer.write(key + "=" + value + "\n\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private <T> void resetConfigEntryValue(ConfigEntry<T> configEntry) {
        configEntry.setValue(configEntry.getDefaultValue());
    }

    public void resetConfig() {
        for (Map.Entry<String, ConfigEntry<?>> entry : this.configs.entrySet()) {
            this.resetConfigEntryValue(entry.getValue());
        }
        this.createDefaultConfig();
        LOGGER.info("Configuration reset to default values.");
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.configs.get(key).getValue();
    }

    public int getInteger(String key) {
        return (Integer)this.configs.get(key).getValue();
    }

    public float getFloat(String key) {
        return ((Float)this.configs.get(key).getValue()).floatValue();
    }

    public double getDouble(String key) {
        return (Double)this.configs.get(key).getValue();
    }

    private static class ConfigEntry<T> {
        private T value;
        private final T defaultValue;
        private final String comment;

        public ConfigEntry(T defaultValue, String comment) {
            this.defaultValue = defaultValue;
            this.comment = comment;
            this.value = defaultValue;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public String getComment() {
            return this.comment;
        }
    }
}

