/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.backported_wolves.mixin;

import net.emilsg.backported_wolves.mixin.MobEntityMixin;
import net.emilsg.backported_wolves.tags.ModBiomeTags;
import net.emilsg.backported_wolves.variant.WolfEntityVariant;
import net.minecraft.class_1266;
import net.minecraft.class_1296;
import net.minecraft.class_1315;
import net.minecraft.class_1493;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1493.class})
public abstract class WolfEntityMixin
extends MobEntityMixin {
    @Unique
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(class_1493.class, (class_2941)class_2943.field_13327);

    @Inject(method={"initDataTracker"}, at={@At(value="HEAD")})
    public void initTracker(CallbackInfo ci) {
        class_1493 wolfEntity = (class_1493)this;
        wolfEntity.method_5841().method_12784(VARIANT, (Object)0);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="HEAD")})
    public void writeNBTData(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10569("Variant", this.getTypeVariant());
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="HEAD")})
    public void readNBTData(class_2487 nbt, CallbackInfo ci) {
        class_1493 wolfEntity = (class_1493)this;
        wolfEntity.method_5841().method_12778(VARIANT, (Object)nbt.method_10550("Variant"));
    }

    @Override
    protected void onInitialize(class_5425 world, class_1266 difficulty, class_3730 spawnReason, class_1315 entityData, class_2487 entityNbt, CallbackInfoReturnable<class_1315> cir) {
        class_1493 wolfEntity = (class_1493)this;
        class_6880 registryEntry = world.method_23753(wolfEntity.method_24515());
        WolfEntityVariant variant = WolfEntityVariant.byId(WolfEntityVariant.PALE_WOLF.getId());
        if (registryEntry.method_40220(ModBiomeTags.SPAWNS_WOODS_WOLF)) {
            variant = WolfEntityVariant.WOODS_WOLF;
        } else if (registryEntry.method_40220(ModBiomeTags.SPAWNS_ASHEN_WOLF)) {
            variant = WolfEntityVariant.ASHEN_WOLF;
        } else if (registryEntry.method_40220(ModBiomeTags.SPAWNS_BLACK_WOLF)) {
            variant = WolfEntityVariant.BLACK_WOLF;
        } else if (registryEntry.method_40220(ModBiomeTags.SPAWNS_CHESTNUT_WOLF)) {
            variant = WolfEntityVariant.CHESTNUT_WOLF;
        } else if (registryEntry.method_40220(ModBiomeTags.SPAWNS_RUSTY_WOLF)) {
            variant = WolfEntityVariant.RUSTY_WOLF;
        } else if (registryEntry.method_40220(ModBiomeTags.SPAWNS_SPOTTED_WOLF)) {
            variant = WolfEntityVariant.SPOTTED_WOLF;
        } else if (registryEntry.method_40220(ModBiomeTags.SPAWNS_STRIPED_WOLF)) {
            variant = WolfEntityVariant.STRIPED_WOLF;
        } else if (registryEntry.method_40220(ModBiomeTags.SPAWNS_SNOWY_WOLF)) {
            variant = WolfEntityVariant.SNOWY_WOLF;
        }
        this.setVariant(variant);
    }

    @Inject(method={"createChild(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/passive/PassiveEntity;)Lnet/minecraft/entity/passive/WolfEntity;"}, at={@At(value="RETURN")})
    private void onCreateChild(class_3218 serverWorld, class_1296 passiveEntity, CallbackInfoReturnable<class_1493> cir) {
        class_1493 child = (class_1493)cir.getReturnValue();
        class_1493 wolfEntity = (class_1493)this;
        class_2487 childNbt = new class_2487();
        child.method_5647(childNbt);
        class_2487 nbtParent = new class_2487();
        wolfEntity.method_5652(nbtParent);
        class_2487 nbtOtherParent = new class_2487();
        passiveEntity.method_5652(nbtOtherParent);
        int variant = wolfEntity.method_6051().method_43056() ? nbtParent.method_10550("Variant") : nbtOtherParent.method_10550("Variant");
        child.method_5841().method_12778(VARIANT, (Object)(variant & 0xFF));
        childNbt.method_10569("Variant", variant);
        child.method_5749(childNbt);
    }

    public WolfEntityVariant getVariant() {
        return WolfEntityVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public int getTypeVariant() {
        class_1493 wolfEntity = (class_1493)this;
        return (Integer)wolfEntity.method_5841().method_12789(VARIANT);
    }

    public void setVariant(WolfEntityVariant variant) {
        class_1493 wolfEntity = (class_1493)this;
        wolfEntity.method_5841().method_12778(VARIANT, (Object)(variant.getId() & 0xFF));
    }
}

