/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.cogwheels.materials;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_151;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class CogwheelMaterial
implements Predicate<class_1799> {
    public final class_2960 id;
    public static int MAX_STRESS = Integer.MAX_VALUE;
    public final Map<class_2960, class_2960> textures;
    public final boolean chunky;
    public class_2371<class_1856> items = class_2371.method_10211();
    public int stressLimit = MAX_STRESS;
    public int speedLimit = 256;

    public CogwheelMaterial(class_2960 id, Map<class_2960, class_2960> textures, boolean chunky) {
        this.id = id;
        this.textures = textures;
        this.chunky = chunky;
    }

    @Override
    public boolean test(class_1799 itemStack) {
        return this.items.stream().anyMatch(ingredient -> ingredient.method_8093(itemStack));
    }

    public void updateFromJson(JsonObject object) {
        try {
            JsonElement ingredients = object.get("items");
            if (ingredients != null && ingredients.isJsonArray()) {
                class_2371<class_1856> items = CogwheelMaterial.ingredientsFromJson(ingredients.getAsJsonArray());
                this.items.addAll(items);
            }
            CogwheelMaterial.parseJsonPrimitive(object, "stress_limit", JsonPrimitive::isNumber, primitive -> {
                this.speedLimit = primitive.getAsInt();
            });
            CogwheelMaterial.parseJsonPrimitive(object, "speed_limit", JsonPrimitive::isNumber, primitive -> {
                this.speedLimit = primitive.getAsInt();
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class_2960 locationFromString(String primitive) {
        try {
            return new class_2960(primitive);
        }
        catch (class_151 class_1512) {
            return new class_2960("extendedgears", "cogwheels/missing");
        }
    }

    private static class_2371<class_1856> ingredientsFromJson(JsonArray ingredientArray) {
        class_2371 ingredients = class_2371.method_10211();
        for (JsonElement je : ingredientArray) {
            ingredients.add((Object)class_1856.method_52177((JsonElement)je));
        }
        return ingredients;
    }

    public void toBuffer(class_2540 buffer) {
        buffer.method_10812(this.id);
        buffer.method_10804(this.items.size());
        for (class_1856 item : this.items) {
            item.method_8088(buffer);
        }
        buffer.writeInt(this.speedLimit);
        buffer.writeInt(this.stressLimit);
    }

    private static void parseJsonPrimitive(JsonObject object, String key, Predicate<JsonPrimitive> predicate, Consumer<JsonPrimitive> consumer) {
        JsonPrimitive primitive;
        JsonElement element = object.get(key);
        if (element != null && element.isJsonPrimitive() && predicate.test(primitive = element.getAsJsonPrimitive())) {
            consumer.accept(primitive);
        }
    }
}

