/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.ItemRandomizer;
import com.yungnickyoung.minecraft.yungsapi.json.ItemAdapter;
import java.io.IOException;
import java.util.Map;
import net.minecraft.class_1792;

public class ItemRandomizerAdapter
extends TypeAdapter<ItemRandomizer> {
    public ItemRandomizer read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        ItemRandomizer randomizer = new ItemRandomizer();
        reader.beginObject();
        while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "entries": {
                    class_1792 item;
                    reader.beginObject();
                    while (reader.hasNext()) {
                        item = ItemAdapter.resolveItem(reader.nextName());
                        double probability = reader.nextDouble();
                        randomizer.addItem(item, (float)probability);
                    }
                    reader.endObject();
                    break;
                }
                case "defaultItem": {
                    class_1792 item = ItemAdapter.resolveItem(reader.nextString());
                    randomizer.setDefaultItem(item);
                }
            }
        }
        reader.endObject();
        return randomizer;
    }

    public void write(JsonWriter writer, ItemRandomizer randomizer) throws IOException {
        if (randomizer == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        writer.name("entries").beginObject();
        for (Map.Entry<class_1792, Float> entry : randomizer.getEntriesAsMap().entrySet()) {
            writer.name(String.valueOf(entry.getKey())).value((Number)entry.getValue());
        }
        writer.endObject();
        String defaultItemString = String.valueOf(randomizer.getDefaultItem());
        writer.name("defaultItem").value(defaultItemString);
        writer.endObject();
    }
}

