/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.content.contraptions.behaviour.DoorMovingInteraction;
import com.simibubi.create.content.contraptions.behaviour.LeverMovingInteraction;
import com.simibubi.create.content.contraptions.behaviour.MovingInteractionBehaviour;
import com.simibubi.create.content.contraptions.behaviour.TrapdoorMovingInteraction;
import com.simibubi.create.foundation.utility.AttachedRegistry;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class AllInteractionBehaviours {
    private static final AttachedRegistry<class_2248, MovingInteractionBehaviour> BLOCK_BEHAVIOURS = new AttachedRegistry(class_7923.field_41175);
    private static final List<BehaviourProvider> GLOBAL_BEHAVIOURS = new ArrayList<BehaviourProvider>();

    public static void registerBehaviour(class_2960 block, MovingInteractionBehaviour provider) {
        BLOCK_BEHAVIOURS.register((class_2248)block, provider);
    }

    public static void registerBehaviour(class_2248 block, MovingInteractionBehaviour provider) {
        BLOCK_BEHAVIOURS.register(block, provider);
    }

    public static void registerBehaviourProvider(BehaviourProvider provider) {
        GLOBAL_BEHAVIOURS.add(provider);
    }

    @Nullable
    public static MovingInteractionBehaviour getBehaviour(class_2680 state) {
        MovingInteractionBehaviour behaviour = BLOCK_BEHAVIOURS.get(state.method_26204());
        if (behaviour != null) {
            return behaviour;
        }
        for (BehaviourProvider provider : GLOBAL_BEHAVIOURS) {
            behaviour = provider.getBehaviour(state);
            if (behaviour == null) continue;
            return behaviour;
        }
        return null;
    }

    public static <B extends class_2248> NonNullConsumer<? super B> interactionBehaviour(MovingInteractionBehaviour behaviour) {
        return b -> AllInteractionBehaviours.registerBehaviour(b, behaviour);
    }

    static void registerDefaults() {
        AllInteractionBehaviours.registerBehaviour(class_2246.field_10363, (MovingInteractionBehaviour)new LeverMovingInteraction());
        DoorMovingInteraction doorBehaviour = new DoorMovingInteraction();
        AllInteractionBehaviours.registerBehaviourProvider(state -> {
            if (state.method_26164(class_3481.field_15494)) {
                return doorBehaviour;
            }
            return null;
        });
        TrapdoorMovingInteraction trapdoorBehaviour = new TrapdoorMovingInteraction();
        AllInteractionBehaviours.registerBehaviourProvider(state -> {
            if (state.method_26164(class_3481.field_15491)) {
                return trapdoorBehaviour;
            }
            return null;
        });
    }

    public static interface BehaviourProvider {
        @Nullable
        public MovingInteractionBehaviour getBehaviour(class_2680 var1);
    }
}

