/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.simibubi.create.AllItems;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.schematics.client.SchematicHandler;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3492;
import net.minecraft.class_364;

public class SchematicEditScreen
extends AbstractSimiScreen {
    private final List<class_2561> rotationOptions = Lang.translatedOptions("schematic.rotation", "none", "cw90", "cw180", "cw270");
    private final List<class_2561> mirrorOptions = Lang.translatedOptions("schematic.mirror", "none", "leftRight", "frontBack");
    private final class_2561 rotationLabel = Lang.translateDirect("schematic.rotation", new Object[0]);
    private final class_2561 mirrorLabel = Lang.translateDirect("schematic.mirror", new Object[0]);
    private AllGuiTextures background = AllGuiTextures.SCHEMATIC;
    private class_342 xInput;
    private class_342 yInput;
    private class_342 zInput;
    private IconButton confirmButton;
    private ScrollInput rotationArea;
    private ScrollInput mirrorArea;
    private SchematicHandler handler = CreateClient.SCHEMATIC_HANDLER;

    @Override
    protected void method_25426() {
        this.setWindowSize(this.background.width, this.background.height);
        this.setWindowOffset(-6, 0);
        super.method_25426();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.xInput = new class_342(this.field_22793, x + 50, y + 26, 34, 10, Components.immutableEmpty());
        this.yInput = new class_342(this.field_22793, x + 90, y + 26, 34, 10, Components.immutableEmpty());
        this.zInput = new class_342(this.field_22793, x + 130, y + 26, 34, 10, Components.immutableEmpty());
        class_2338 anchor = this.handler.getTransformation().getAnchor();
        if (this.handler.isDeployed()) {
            this.xInput.method_1852("" + anchor.method_10263());
            this.yInput.method_1852("" + anchor.method_10264());
            this.zInput.method_1852("" + anchor.method_10260());
        } else {
            class_342[] alt = this.field_22787.field_1724.method_24515();
            this.xInput.method_1852("" + alt.method_10263());
            this.yInput.method_1852("" + alt.method_10264());
            this.zInput.method_1852("" + alt.method_10260());
        }
        for (class_342 widget : new class_342[]{this.xInput, this.yInput, this.zInput}) {
            widget.method_1880(6);
            widget.method_1858(false);
            widget.method_1868(0xFFFFFF);
            widget.method_25365(false);
            widget.method_25402(0.0, 0.0, 0);
            widget.method_1890(s -> {
                if (s.isEmpty() || s.equals("-")) {
                    return true;
                }
                try {
                    Integer.parseInt(s);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
        }
        class_3492 settings = this.handler.getTransformation().toSettings();
        Label labelR = new Label(x + 50, y + 48, Components.immutableEmpty()).withShadow();
        this.rotationArea = new SelectionScrollInput(x + 45, y + 43, 118, 18).forOptions(this.rotationOptions).titled(this.rotationLabel.method_27662()).setState(settings.method_15113().ordinal()).writingTo(labelR);
        Label labelM = new Label(x + 50, y + 70, Components.immutableEmpty()).withShadow();
        this.mirrorArea = new SelectionScrollInput(x + 45, y + 65, 118, 18).forOptions(this.mirrorOptions).titled(this.mirrorLabel.method_27662()).setState(settings.method_15114().ordinal()).writingTo(labelM);
        this.addRenderableWidgets((class_364[])new class_342[]{this.xInput, this.yInput, this.zInput});
        this.addRenderableWidgets(new AbstractSimiWidget[]{labelR, labelM, this.rotationArea, this.mirrorArea});
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.method_25419());
        this.method_37063(this.confirmButton);
    }

    @Override
    public boolean method_25404(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        String coords;
        if (SchematicEditScreen.method_25437((int)code) && (coords = this.field_22787.field_1774.method_1460()) != null && !coords.isEmpty()) {
            coords.replaceAll(" ", "");
            String[] split = coords.split(",");
            if (split.length == 3) {
                boolean valid = true;
                for (String s : split) {
                    try {
                        Integer.parseInt(s);
                    }
                    catch (NumberFormatException e) {
                        valid = false;
                    }
                }
                if (valid) {
                    this.xInput.method_1852(split[0]);
                    this.yInput.method_1852(split[1]);
                    this.zInput.method_1852(split[2]);
                    return true;
                }
            }
        }
        return super.method_25404(code, p_keyPressed_2_, p_keyPressed_3_);
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        String title = this.handler.getCurrentSchematicName();
        graphics.method_25300(this.field_22793, title, x + (this.background.width - 8) / 2, y + 3, 0xFFFFFF);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of(AllItems.SCHEMATIC.asStack()).at(x + this.background.width + 6, y + this.background.height - 40, -200.0f)).scale(3.0).render(graphics);
    }

    public void method_25432() {
        boolean validCoords = true;
        class_2338 newLocation = null;
        try {
            newLocation = new class_2338(Integer.parseInt(this.xInput.method_1882()), Integer.parseInt(this.yInput.method_1882()), Integer.parseInt(this.zInput.method_1882()));
        }
        catch (NumberFormatException e) {
            validCoords = false;
        }
        class_3492 settings = new class_3492();
        settings.method_15123(class_2470.values()[this.rotationArea.getState()]);
        settings.method_15125(class_2415.values()[this.mirrorArea.getState()]);
        if (validCoords && newLocation != null) {
            class_1799 item = this.handler.getActiveSchematicItem();
            if (item != null) {
                item.method_7969().method_10556("Deployed", true);
                item.method_7969().method_10566("Anchor", (class_2520)class_2512.method_10692((class_2338)newLocation));
            }
            this.handler.getTransformation().init(newLocation, settings, this.handler.getBounds());
            this.handler.markDirty();
            this.handler.deploy();
        }
    }
}

