/*
 * Decompiled with CFR 0.152.
 */
package com.nhoryzon.mc.farmersdelight.client.render.block;

import com.nhoryzon.mc.farmersdelight.block.signs.ICanvasSign;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2478;
import net.minecraft.class_2508;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4719;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5602;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_8242;
import net.minecraft.class_837;

@Environment(value=EnvType.CLIENT)
public class CanvasSignBlockEntityRenderer
extends class_837 {
    public static final class_4730 BLANK_CANVAS_SIGN_SPRITE = new class_4730(class_4722.field_21708, new class_2960("farmersdelight", "entity/signs/canvas"));
    public static final Map<class_1767, class_4730> DYED_CANVAS_SIGN_SPRITES = Arrays.stream(class_1767.values()).collect(Collectors.toMap(Function.identity(), CanvasSignBlockEntityRenderer::createSignSpriteIdentifier));
    public static final class_243 TEXT_OFFSET = new class_243(0.0, 0.3333333432674408, 0.046666666865348816);
    private static final int RENDER_DISTANCE = class_3532.method_34954((int)16);
    private final class_837.class_4702 signModel;
    private final class_327 textRenderer;

    public CanvasSignBlockEntityRenderer(class_5614.class_5615 context) {
        super(context);
        this.signModel = new class_837.class_4702(context.method_32140(class_5602.method_32078((class_4719)class_4719.field_21677)));
        this.textRenderer = context.method_32143();
    }

    public void method_23083(class_2625 signBlockEntity, float f, class_4587 matrixStack, class_4597 vertexConsumerProvider, int packedLight, int packedOverlay) {
        class_2680 blockState = signBlockEntity.method_11010();
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof class_2478) {
            class_2478 signBlock = (class_2478)class_22482;
            class_837.class_4702 model = this.signModel;
            model.field_21531.field_3665 = signBlock instanceof class_2508;
            class_1767 dye = null;
            if (signBlock instanceof ICanvasSign) {
                ICanvasSign canvasSign = (ICanvasSign)signBlock;
                dye = canvasSign.getBackgroundColor();
            }
            this.renderSignWithText(signBlockEntity, matrixStack, vertexConsumerProvider, packedLight, packedOverlay, blockState, signBlock, dye, model);
        }
    }

    protected void renderSignWithText(class_2625 signBlockEntity, class_4587 matrixStack, class_4597 vertexConsumerProvider, int packedLight, int packedOverlay, class_2680 blockState, class_2478 signBlock, class_1767 dye, class_837.class_4702 model) {
        matrixStack.method_22903();
        this.translateSign(matrixStack, -signBlock.method_49814(blockState), blockState);
        this.renderSign(matrixStack, vertexConsumerProvider, packedLight, packedOverlay, dye, model);
        this.renderSignText(signBlockEntity.method_11016(), signBlockEntity.method_49853(), matrixStack, vertexConsumerProvider, packedLight, signBlockEntity.method_45469(), signBlockEntity.method_45470(), true);
        this.renderSignText(signBlockEntity.method_11016(), signBlockEntity.method_49854(), matrixStack, vertexConsumerProvider, packedLight, signBlockEntity.method_45469(), signBlockEntity.method_45470(), false);
        matrixStack.method_22909();
    }

    protected void translateSign(class_4587 matrixStack, float angle, class_2680 blockState) {
        matrixStack.method_46416(0.5f, 0.75f * this.method_51272(), 0.5f);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(angle));
        if (!(blockState.method_26204() instanceof class_2508)) {
            matrixStack.method_22904(0.0, -0.3125, -0.4375);
        }
    }

    protected void renderSign(class_4587 matrixStack, class_4597 vertexConsumerProvider, int packedLight, int packedOverlay, class_1767 dye, class_837.class_4702 model) {
        matrixStack.method_22903();
        float rootScale = this.method_51272();
        matrixStack.method_22905(rootScale, -rootScale, -rootScale);
        class_4730 spriteIdentifier = CanvasSignBlockEntityRenderer.getCanvasSignSpriteTexture(dye);
        Objects.requireNonNull(this.signModel);
        class_4588 vertexConsumer = spriteIdentifier.method_24145(vertexConsumerProvider, arg_0 -> ((class_837.class_4702)model).method_23500(arg_0));
        this.signModel.field_27756.method_22698(matrixStack, vertexConsumer, packedLight, packedOverlay);
        matrixStack.method_22909();
    }

    protected void renderSignText(class_2338 pos, class_8242 text, class_4587 matrixStack, class_4597 vertexConsumerProvider, int packedLight, int textLineHeight, int maxTextWidth, boolean isFrontText) {
        int light;
        boolean hasOutline;
        int baseColor;
        int darkColor;
        matrixStack.method_22903();
        this.translateSignText(matrixStack, isFrontText, this.method_45790());
        class_5481[] orderedTexts = text.method_49868(class_310.method_1551().method_33883(), line -> {
            List list = this.textRenderer.method_1728((class_5348)line, maxTextWidth);
            return list.isEmpty() ? class_5481.field_26385 : (class_5481)list.get(0);
        });
        if (text.method_49856()) {
            darkColor = CanvasSignBlockEntityRenderer.getColor(text, true);
            baseColor = text.method_49872().method_16357();
            hasOutline = CanvasSignBlockEntityRenderer.shouldRenderOutline(pos, baseColor);
            light = 0xF000F0;
        } else {
            baseColor = darkColor = CanvasSignBlockEntityRenderer.getColor(text, false);
            hasOutline = false;
            light = packedLight;
        }
        int verticalOffset = 2 * textLineHeight + this.getCustomVerticalOffset();
        for (int p = 0; p < 4; ++p) {
            class_5481 orderedText = orderedTexts[p];
            float x = -this.textRenderer.method_30880(orderedText) / 2;
            float y = (float)p * (float)textLineHeight - (float)verticalOffset;
            if (hasOutline) {
                this.textRenderer.method_37296(orderedText, x, y, baseColor, darkColor, matrixStack.method_23760().method_23761(), vertexConsumerProvider, light);
                continue;
            }
            this.textRenderer.method_22942(orderedText, x, y, baseColor, false, matrixStack.method_23760().method_23761(), vertexConsumerProvider, class_327.class_6415.field_33993, 0, light);
        }
        matrixStack.method_22909();
    }

    private void translateSignText(class_4587 matrixStack, boolean isFrontText, class_243 pos) {
        if (!isFrontText) {
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        }
        float textScale = 0.015625f * this.method_51273();
        matrixStack.method_22904(pos.field_1352, pos.field_1351, pos.field_1350);
        matrixStack.method_22905(textScale, -textScale, textScale);
    }

    private static boolean shouldRenderOutline(class_2338 pos, int textColor) {
        if (textColor == class_1767.field_7963.method_16357()) {
            return true;
        }
        class_310 minecraftClient = class_310.method_1551();
        class_746 clientPlayerEntity = minecraftClient.field_1724;
        if (clientPlayerEntity != null && minecraftClient.field_1690.method_31044().method_31034() && clientPlayerEntity.method_31550()) {
            return true;
        }
        class_1297 entity = minecraftClient.method_1560();
        return entity != null && entity.method_5707(class_243.method_24953((class_2382)pos)) < (double)RENDER_DISTANCE;
    }

    private static int getColor(class_8242 signText, boolean isOutlineVisible) {
        int textColor = signText.method_49872().method_16357();
        if (textColor == class_1767.field_7963.method_16357() && signText.method_49856()) {
            return -988212;
        }
        double brightness = isOutlineVisible ? 0.4 : 0.6;
        int red = (int)((double)class_5253.class_5254.method_27765((int)textColor) * brightness);
        int green = (int)((double)class_5253.class_5254.method_27766((int)textColor) * brightness);
        int blue = (int)((double)class_5253.class_5254.method_27767((int)textColor) * brightness);
        return class_5253.class_5254.method_27764((int)0, (int)red, (int)green, (int)blue);
    }

    public class_243 method_45790() {
        return TEXT_OFFSET;
    }

    public int getCustomVerticalOffset() {
        return -1;
    }

    public static class_4730 getCanvasSignSpriteTexture(class_1767 dyeColor) {
        return dyeColor != null ? DYED_CANVAS_SIGN_SPRITES.get(dyeColor) : BLANK_CANVAS_SIGN_SPRITE;
    }

    public static class_4730 createSignSpriteIdentifier(class_1767 dyeColor) {
        return new class_4730(class_4722.field_21708, new class_2960("farmersdelight", "entity/signs/canvas_" + dyeColor.method_7792()));
    }
}

