/*
 * Decompiled with CFR 0.152.
 */
package com.nhoryzon.mc.farmersdelight.entity.block;

import com.nhoryzon.mc.farmersdelight.FarmersDelightMod;
import com.nhoryzon.mc.farmersdelight.advancement.CuttingBoardTrigger;
import com.nhoryzon.mc.farmersdelight.block.CuttingBoardBlock;
import com.nhoryzon.mc.farmersdelight.entity.block.SyncedBlockEntity;
import com.nhoryzon.mc.farmersdelight.entity.block.inventory.ItemStackInventory;
import com.nhoryzon.mc.farmersdelight.entity.block.inventory.RecipeWrapper;
import com.nhoryzon.mc.farmersdelight.mixin.accessors.RecipeManagerAccessorMixin;
import com.nhoryzon.mc.farmersdelight.recipe.CuttingBoardRecipe;
import com.nhoryzon.mc.farmersdelight.registry.AdvancementsRegistry;
import com.nhoryzon.mc.farmersdelight.registry.BlockEntityTypesRegistry;
import com.nhoryzon.mc.farmersdelight.registry.RecipeTypesRegistry;
import com.nhoryzon.mc.farmersdelight.registry.SoundsRegistry;
import com.nhoryzon.mc.farmersdelight.registry.TagsRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1820;
import net.minecraft.class_1860;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class CuttingBoardBlockEntity
extends SyncedBlockEntity
implements ItemStackInventory {
    public static final String TAG_KEY_IS_ITEM_CARVED = "IsItemCarved";
    private boolean isItemCarvingBoard = false;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private class_2960 lastRecipeID;

    public CuttingBoardBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(BlockEntityTypesRegistry.CUTTING_BOARD.get(), blockPos, blockState);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public int method_5444() {
        return 1;
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.isItemCarvingBoard = tag.method_10577(TAG_KEY_IS_ITEM_CARVED);
        this.readInventoryNbt(tag);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.writeInventoryNbt(tag);
        tag.method_10556(TAG_KEY_IS_ITEM_CARVED, this.isItemCarvingBoard);
    }

    @Override
    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public class_2487 method_16887() {
        class_2487 nbt = new class_2487();
        this.method_11007(nbt);
        return nbt;
    }

    public boolean processItemUsingTool(class_1799 tool, class_1657 player) {
        if (this.field_11863 == null) {
            return false;
        }
        Optional<CuttingBoardRecipe> matchingRecipe = this.getMatchingRecipe(new RecipeWrapper(this), tool, player);
        matchingRecipe.ifPresent(recipe -> {
            List<class_1799> results = recipe.getRolledResults(this.field_11863.method_8409(), class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)tool));
            for (class_1799 result : results) {
                class_2350 direction = ((class_2350)this.method_11010().method_11654((class_2769)CuttingBoardBlock.FACING)).method_10160();
                class_1542 entity = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5 + (double)direction.method_10148() * 0.2, (double)this.field_11867.method_10264() + 0.2, (double)this.field_11867.method_10260() + 0.5 + (double)direction.method_10165() * 0.2, result.method_7972());
                entity.method_18800((double)((float)direction.method_10148() * 0.2f), 0.0, (double)((float)direction.method_10165() * 0.2f));
                this.field_11863.method_8649((class_1297)entity);
            }
            if (player != null) {
                tool.method_7956(1, (class_1309)player, user -> user.method_20236(class_1268.field_5808));
            } else if (tool.method_7970(1, this.field_11863.method_8409(), null)) {
                tool.method_7939(0);
            }
            this.playProcessingSound(recipe.getSoundEvent(), tool.method_7909(), this.getStoredItem().method_7909());
            this.removeItem();
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                ((CuttingBoardTrigger)AdvancementsRegistry.CUTTING_BOARD.get()).trigger(serverPlayer);
            }
        });
        return matchingRecipe.isPresent();
    }

    private Optional<CuttingBoardRecipe> getMatchingRecipe(RecipeWrapper recipeWrapper, class_1799 toolStack, @Nullable class_1657 player) {
        class_1860 recipe;
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = (class_1860)((RecipeManagerAccessorMixin)this.field_11863.method_8433()).getAllForType(RecipeTypesRegistry.CUTTING_RECIPE_SERIALIZER.type()).get(this.lastRecipeID)) instanceof CuttingBoardRecipe && recipe.method_8115((class_1263)recipeWrapper, this.field_11863) && ((CuttingBoardRecipe)recipe).getTool().method_8093(toolStack)) {
            return Optional.of((CuttingBoardRecipe)recipe);
        }
        List recipeList = this.field_11863.method_8433().method_17877(RecipeTypesRegistry.CUTTING_RECIPE_SERIALIZER.type(), (class_1263)recipeWrapper, this.field_11863);
        if (recipeList.isEmpty()) {
            if (player != null) {
                player.method_7353((class_2561)FarmersDelightMod.i18n("block.cutting_board.invalid_item", new Object[0]), true);
            }
            return Optional.empty();
        }
        Optional<CuttingBoardRecipe> recipe2 = recipeList.stream().filter(cuttingRecipe -> cuttingRecipe.getTool().method_8093(toolStack)).findFirst();
        if (recipe2.isEmpty()) {
            if (player != null) {
                player.method_7353((class_2561)FarmersDelightMod.i18n("block.cutting_board.invalid_tool", new Object[0]), true);
            }
            return Optional.empty();
        }
        this.lastRecipeID = recipe2.get().method_8114();
        return recipe2;
    }

    public void playProcessingSound(String soundEventID, class_1792 tool, class_1792 boardItem) {
        class_3414 sound = (class_3414)class_7923.field_41172.method_10223(new class_2960(soundEventID));
        if (sound != null) {
            this.playSound(sound, 1.0f, 1.0f);
        } else if (tool instanceof class_1820) {
            this.playSound(class_3417.field_14975, 1.0f, 1.0f);
        } else if (tool.method_7854().method_31573(TagsRegistry.KNIVES)) {
            this.playSound(SoundsRegistry.BLOCK_CUTTING_BOARD_KNIFE.get(), 0.8f, 1.0f);
        } else if (boardItem instanceof class_1747) {
            class_1747 boardBlockItem = (class_1747)boardItem;
            class_2248 block = boardBlockItem.method_7711();
            class_2498 soundType = block.method_9564().method_26231();
            this.playSound(soundType.method_10595(), 1.0f, 0.8f);
        } else {
            this.playSound(class_3417.field_15215, 1.0f, 0.8f);
        }
    }

    public void playSound(class_3414 sound, float volume, float pitch) {
        Objects.requireNonNull(this.field_11863).method_43128(null, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.5f), (double)((float)this.field_11867.method_10260() + 0.5f), sound, class_3419.field_15245, volume, pitch);
    }

    public boolean carveToolOnBoard(class_1799 tool) {
        if (this.addItem(tool)) {
            this.isItemCarvingBoard = true;
            return true;
        }
        return false;
    }

    public boolean getIsItemCarvingBoard() {
        return this.isItemCarvingBoard;
    }

    @Override
    public boolean method_5442() {
        return this.method_5438(0).method_7960();
    }

    public class_1799 getStoredItem() {
        return this.method_5438(0);
    }

    public boolean addItem(class_1799 itemStack) {
        if (this.method_5442() && !itemStack.method_7960()) {
            this.method_5447(0, itemStack.method_7971(1));
            this.isItemCarvingBoard = false;
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public class_1799 removeItem() {
        if (!this.method_5442()) {
            this.isItemCarvingBoard = false;
            class_1799 item = this.getStoredItem().method_7971(1);
            this.inventoryChanged();
            return item;
        }
        return class_1799.field_8037;
    }

    @Override
    public void onContentsChanged(int slot) {
        this.inventoryChanged();
    }

    @Override
    public int getMaxCountForSlot(int slot) {
        return 1;
    }
}

