/*
 * Decompiled with CFR 0.152.
 */
package com.nhoryzon.mc.farmersdelight.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.nhoryzon.mc.farmersdelight.recipe.CuttingBoardRecipe;
import com.nhoryzon.mc.farmersdelight.recipe.ingredient.ChanceResult;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class CuttingBoardRecipeSerializer
implements class_1865<CuttingBoardRecipe> {
    private static class_2371<class_1856> readIngredients(JsonArray ingredientArray) {
        class_2371 ingredientList = class_2371.method_10211();
        for (JsonElement ingredientJson : ingredientArray) {
            class_1856 ingredient = class_1856.method_52177((JsonElement)ingredientJson);
            if (ingredient.method_8103()) continue;
            ingredientList.add((Object)ingredient);
        }
        return ingredientList;
    }

    private static class_2371<ChanceResult> readResultList(JsonArray resultArray) {
        class_2371 resultList = class_2371.method_10211();
        for (JsonElement resultJson : resultArray) {
            resultList.add((Object)ChanceResult.deserialize(resultJson));
        }
        return resultList;
    }

    public CuttingBoardRecipe read(class_2960 id, JsonObject json) {
        String groupIn = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
        class_2371<class_1856> inputItemsIn = CuttingBoardRecipeSerializer.readIngredients(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
        JsonObject toolObject = class_3518.method_15296((JsonObject)json, (String)"tool");
        class_1856 tool = class_1856.method_52177((JsonElement)toolObject);
        if (inputItemsIn.isEmpty()) {
            throw new JsonParseException("No ingredients for cooking recipe");
        }
        if (tool.method_8103()) {
            throw new JsonParseException("No tool for cutting recipe");
        }
        if (inputItemsIn.size() > 1) {
            throw new JsonParseException("Too many ingredients for cooking recipe! Please define only one ingredient");
        }
        class_2371<ChanceResult> resultList = CuttingBoardRecipeSerializer.readResultList(class_3518.method_15261((JsonObject)json, (String)"result"));
        if (resultList.size() > 4) {
            throw new JsonParseException("Too many results for cutting recipe! The maximum quantity of unique results is 4");
        }
        String soundId = class_3518.method_15253((JsonObject)json, (String)"sound", (String)"");
        return new CuttingBoardRecipe(id, groupIn, (class_1856)inputItemsIn.get(0), tool, resultList, soundId);
    }

    public CuttingBoardRecipe read(class_2960 id, class_2540 buf) {
        String groupIn = buf.method_10800(Short.MAX_VALUE);
        class_1856 input = class_1856.method_8086((class_2540)buf);
        class_1856 tool = class_1856.method_8086((class_2540)buf);
        int resultSize = buf.method_10816();
        class_2371 resultList = class_2371.method_10213((int)resultSize, (Object)ChanceResult.EMPTY);
        resultList.replaceAll(ignored -> ChanceResult.read(buf));
        String soundEvent = buf.method_19772();
        return new CuttingBoardRecipe(id, groupIn, input, tool, (class_2371<ChanceResult>)resultList, soundEvent);
    }

    public void write(class_2540 buf, CuttingBoardRecipe recipe) {
        buf.method_10814(recipe.method_8112());
        ((class_1856)recipe.method_8117().get(0)).method_8088(buf);
        recipe.getTool().method_8088(buf);
        buf.method_10804(recipe.getRollableResults().size());
        for (ChanceResult result : recipe.getRollableResults()) {
            result.write(buf);
        }
        buf.method_10814(recipe.getSoundEvent());
    }
}

