/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.color;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.model.color.ColorProvider;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.BlendedColorProvider;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.biome.BiomeColorSource;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_322;
import net.minecraft.class_3610;

public class DefaultColorProviders {
    public static ColorProvider<class_2680> adapt(class_322 provider) {
        return new VanillaAdapter(provider);
    }

    public static ColorProvider<class_3610> adapt(FluidRenderHandler handler) {
        return new FabricFluidAdapter(handler);
    }

    private static class VanillaAdapter
    implements ColorProvider<class_2680> {
        private final class_322 provider;

        private VanillaAdapter(class_322 provider) {
            this.provider = provider;
        }

        @Override
        public void getColors(WorldSlice view, class_2338 pos, class_2680 state, ModelQuadView quad, int[] output) {
            Arrays.fill(output, ColorARGB.toABGR(this.provider.getColor(state, (class_1920)view, pos, quad.getColorIndex())));
        }
    }

    private static class FabricFluidAdapter
    implements ColorProvider<class_3610> {
        private final FluidRenderHandler handler;

        public FabricFluidAdapter(FluidRenderHandler handler) {
            this.handler = handler;
        }

        @Override
        public void getColors(WorldSlice view, class_2338 pos, class_3610 state, ModelQuadView quad, int[] output) {
            Arrays.fill(output, this.handler.getFluidColor((class_1920)view, pos, state));
        }
    }

    public static class WaterColorProvider<T>
    extends BlendedColorProvider<T> {
        public static final ColorProvider<class_2680> BLOCKS = new WaterColorProvider<class_2680>();
        public static final ColorProvider<class_3610> FLUIDS = new WaterColorProvider<class_3610>();

        private WaterColorProvider() {
        }

        @Override
        protected int getColor(WorldSlice world, int x, int y, int z) {
            return world.getColor(BiomeColorSource.WATER, x, y, z);
        }
    }

    public static class FoliageColorProvider<T>
    extends BlendedColorProvider<T> {
        public static final ColorProvider<class_2680> BLOCKS = new FoliageColorProvider<class_2680>();

        private FoliageColorProvider() {
        }

        @Override
        protected int getColor(WorldSlice world, int x, int y, int z) {
            return world.getColor(BiomeColorSource.FOLIAGE, x, y, z);
        }
    }

    public static class GrassColorProvider<T>
    extends BlendedColorProvider<T> {
        public static final ColorProvider<class_2680> BLOCKS = new GrassColorProvider<class_2680>();

        private GrassColorProvider() {
        }

        @Override
        protected int getColor(WorldSlice world, int x, int y, int z) {
            return world.getColor(BiomeColorSource.GRASS, x, y, z);
        }
    }
}

