/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ColorVertex;
import net.minecraft.class_2806;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_332;
import net.minecraft.class_3928;
import net.minecraft.class_3953;
import net.minecraft.class_4588;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_3928.class})
public class LevelLoadingScreenMixin {
    @Mutable
    @Shadow
    @Final
    private static Object2IntMap<class_2806> field_17407;
    @Unique
    private static Reference2IntOpenHashMap<class_2806> STATUS_TO_COLOR_FAST;
    @Unique
    private static final int NULL_STATUS_COLOR;
    @Unique
    private static final int DEFAULT_STATUS_COLOR;

    @Overwrite
    public static void method_17538(class_332 drawContext, class_3953 tracker, int mapX, int mapY, int mapScale, int mapPadding) {
        if (STATUS_TO_COLOR_FAST == null) {
            STATUS_TO_COLOR_FAST = new Reference2IntOpenHashMap(field_17407.size());
            STATUS_TO_COLOR_FAST.put(null, NULL_STATUS_COLOR);
            field_17407.object2IntEntrySet().forEach(entry -> STATUS_TO_COLOR_FAST.put((Object)((class_2806)entry.getKey()), ColorARGB.toABGR(entry.getIntValue(), 255)));
        }
        RenderSystem.setShader(class_757::method_34540);
        Matrix4f matrix = drawContext.method_51448().method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        VertexBufferWriter writer = VertexBufferWriter.of((class_4588)bufferBuilder);
        int centerSize = tracker.method_17677();
        int size = tracker.method_17678();
        int tileSize = mapScale + mapPadding;
        if (mapPadding != 0) {
            int mapRenderCenterSize = centerSize * tileSize - mapPadding;
            int radius = mapRenderCenterSize / 2 + 1;
            LevelLoadingScreenMixin.addRect(writer, matrix, mapX - radius, mapY - radius, mapX - radius + 1, mapY + radius, DEFAULT_STATUS_COLOR);
            LevelLoadingScreenMixin.addRect(writer, matrix, mapX + radius - 1, mapY - radius, mapX + radius, mapY + radius, DEFAULT_STATUS_COLOR);
            LevelLoadingScreenMixin.addRect(writer, matrix, mapX - radius, mapY - radius, mapX + radius, mapY - radius + 1, DEFAULT_STATUS_COLOR);
            LevelLoadingScreenMixin.addRect(writer, matrix, mapX - radius, mapY + radius - 1, mapX + radius, mapY + radius, DEFAULT_STATUS_COLOR);
        }
        int mapRenderSize = size * tileSize - mapPadding;
        int mapStartX = mapX - mapRenderSize / 2;
        int mapStartY = mapY - mapRenderSize / 2;
        class_2806 prevStatus = null;
        int prevColor = NULL_STATUS_COLOR;
        for (int x = 0; x < size; ++x) {
            int tileX = mapStartX + x * tileSize;
            for (int z = 0; z < size; ++z) {
                int color;
                int tileY = mapStartY + z * tileSize;
                class_2806 status = tracker.method_17676(x, z);
                if (prevStatus == status) {
                    color = prevColor;
                } else {
                    color = STATUS_TO_COLOR_FAST.getInt((Object)status);
                    prevStatus = status;
                    prevColor = color;
                }
                LevelLoadingScreenMixin.addRect(writer, matrix, tileX, tileY, tileX + mapScale, tileY + mapScale, color);
            }
        }
        tessellator.method_1350();
        RenderSystem.disableBlend();
    }

    @Unique
    private static void addRect(VertexBufferWriter writer, Matrix4f matrix, int x1, int y1, int x2, int y2, int color) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(64);
            ColorVertex.put(ptr, matrix, x1, y2, 0.0f, color);
            ColorVertex.put(ptr += 16L, matrix, x2, y2, 0.0f, color);
            ColorVertex.put(ptr += 16L, matrix, x2, y1, 0.0f, color);
            ColorVertex.put(ptr += 16L, matrix, x1, y1, 0.0f, color);
            ptr += 16L;
            writer.push(stack, buffer, 4, ColorVertex.FORMAT);
        }
    }

    static {
        NULL_STATUS_COLOR = ColorABGR.pack(0, 0, 0, 255);
        DEFAULT_STATUS_COLOR = ColorARGB.pack(0, 17, 255, 255);
    }
}

