/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.core.recipe.ShapedRecipeTemplate;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2450;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7710;
import net.minecraft.class_7923;

public class ShapelessRecipeTemplate
implements IRecipeTemplate<class_2450.class_2451> {
    private final List<Object> conditions = new ArrayList<Object>();
    public final class_1792 result;
    public final int count;
    public final String group;
    public final List<class_1856> ingredients;
    public final class_7710 category;

    ShapelessRecipeTemplate(ShapedRecipeTemplate shaped) {
        this.result = shaped.result;
        this.count = shaped.count;
        this.group = shaped.group;
        this.ingredients = shaped.keys.values().stream().toList();
        this.category = shaped.category;
    }

    public ShapelessRecipeTemplate(JsonObject json) {
        JsonObject result = json.getAsJsonObject("result");
        class_2960 item = new class_2960(result.get("item").getAsString());
        int count = 1;
        JsonElement c = result.get("count");
        if (c != null) {
            count = c.getAsInt();
        }
        this.result = (class_1792)class_7923.field_41178.method_10223(item);
        this.count = count;
        this.category = (class_7710)class_7710.field_40252.method_47920(class_3518.method_15253((JsonObject)json, (String)"category", null), (Enum)class_7710.field_40251);
        JsonElement g = json.get("group");
        this.group = g == null ? "" : g.getAsString();
        ArrayList<class_1856> ingredientsList = new ArrayList<class_1856>();
        JsonArray ingredients = json.getAsJsonArray("ingredients");
        ingredients.forEach(p -> ingredientsList.add(class_1856.method_52177((JsonElement)p)));
        this.ingredients = ingredientsList;
    }

    @Override
    public <T extends BlockType> class_2450.class_2451 createSimilar(T originalMat, T destinationMat, class_1792 unlockItem, String id) {
        class_1792 newRes = BlockType.changeItemType(this.result, originalMat, destinationMat);
        if (newRes == null) {
            throw new UnsupportedOperationException(String.format("Could not convert output item %s from type %s to %s", this.result, originalMat, destinationMat));
        }
        class_2450 builder = new class_2450(this.determineBookCategory(this.category), (class_1935)newRes, this.count);
        boolean atLeastOneChanged = false;
        for (class_1856 originalIng : this.ingredients) {
            class_1856 newIng = IRecipeTemplate.convertIngredients(originalMat, destinationMat, originalIng);
            if (newIng != null) {
                atLeastOneChanged = true;
            } else {
                newIng = originalIng;
            }
            builder.method_10451(newIng);
        }
        if (!atLeastOneChanged) {
            return null;
        }
        builder.method_10452(this.group);
        builder.method_10442("has_item", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{unlockItem}));
        AtomicReference newRecipe = new AtomicReference();
        if (id == null) {
            builder.method_10431(r -> newRecipe.set((class_2450.class_2451)r));
        } else {
            builder.method_36443(r -> newRecipe.set((class_2450.class_2451)r), id);
        }
        return (class_2450.class_2451)newRecipe.get();
    }

    @Override
    public void addCondition(Object condition) {
        this.conditions.add(condition);
    }

    @Override
    public List<Object> getConditions() {
        return this.conditions;
    }
}

