/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.gammautils;

import io.github.sjouwer.gammautils.GammaUtils;
import io.github.sjouwer.gammautils.config.ModConfig;
import io.github.sjouwer.gammautils.statuseffect.StatusEffectManager;
import io.github.sjouwer.gammautils.util.InfoProvider;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.class_310;
import net.minecraft.class_7172;

public class GammaOptions {
    private static final class_7172<Double> gamma = class_310.method_1551().field_1690.method_42473();
    private static final ModConfig config = GammaUtils.getConfig();
    private static Timer transitionTimer = null;

    private GammaOptions() {
    }

    public static double getGamma() {
        return (Double)gamma.method_41753();
    }

    public static int getGammaPercentage() {
        return (int)Math.round((Double)gamma.method_41753() * 100.0);
    }

    public static void toggleGamma() {
        double newValue = ((Double)gamma.method_41753()).doubleValue() == config.getDefaultGamma() ? config.getToggledGamma() : config.getDefaultGamma();
        GammaOptions.setGamma(newValue, true);
    }

    public static void increaseGamma(double value) {
        double newValue = (Double)gamma.method_41753();
        GammaOptions.setGamma(newValue += value == 0.0 ? config.getGammaStep() : value, false);
    }

    public static void decreaseGamma(double value) {
        double newValue = (Double)gamma.method_41753();
        GammaOptions.setGamma(newValue -= value == 0.0 ? config.getGammaStep() : value, false);
    }

    public static void minGamma() {
        GammaOptions.setGamma(config.getMinGamma(), true);
    }

    public static void maxGamma() {
        GammaOptions.setGamma(config.getMaxGamma(), true);
    }

    public static void setGamma(double newValue, boolean smoothTransition) {
        if (transitionTimer != null) {
            transitionTimer.cancel();
        }
        if (config.getMaxGamma() > config.getMinGamma() && config.isLimitCheckEnabled()) {
            newValue = Math.max(config.getMinGamma(), Math.min(newValue, config.getMaxGamma()));
        }
        if (smoothTransition && config.isSmoothTransitionEnabled()) {
            double valueChangePerTick = config.getTransitionSpeed() / 100.0;
            if (newValue < (Double)gamma.method_41753()) {
                valueChangePerTick *= -1.0;
            }
            GammaOptions.startTransitionTimer(newValue, valueChangePerTick);
        } else {
            gamma.method_41748((Object)newValue);
            StatusEffectManager.updateGammaStatusEffect();
            InfoProvider.showGammaHudMessage();
        }
        if (config.isUpdateToggleEnabled() && newValue != config.getDefaultGamma() && newValue != config.getToggledGamma()) {
            config.setToggledGamma(newValue);
        }
    }

    private static void startTransitionTimer(final double newValue, final double valueChangePerTick) {
        transitionTimer = new Timer();
        transitionTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                double nextValue = (Double)gamma.method_41753() + valueChangePerTick;
                if (valueChangePerTick > 0.0 && nextValue >= newValue || valueChangePerTick < 0.0 && nextValue <= newValue) {
                    transitionTimer.cancel();
                    gamma.method_41748((Object)newValue);
                    StatusEffectManager.updateGammaStatusEffect();
                } else {
                    gamma.method_41748((Object)nextValue);
                }
                InfoProvider.showGammaHudMessage();
            }
        }, 0L, 10L);
    }
}

