/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks;

import com.beansgalaxy.backpacks.config.ClientConfig;
import com.beansgalaxy.backpacks.data.Traits;
import com.beansgalaxy.backpacks.entity.Kind;
import com.beansgalaxy.backpacks.platform.Services;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constants {
    public static final String MOD_ID = "beansbackpacks";
    public static final String MOD_NAME = "Beans' Backpacks";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Beans' Backpacks");
    public static final ClientConfig CLIENT_CONFIG = new ClientConfig();
    public static final HashMap<String, Traits> TRAITS_MAP = new HashMap();
    public static final boolean SLOTS_MOD_ACTIVE = Services.COMPAT.anyModsLoaded("curios", "trinkets");
    public static final HashSet<class_1792> CHESTPLATE_DISABLED = new HashSet();
    public static final HashSet<class_1792> DISABLES_BACK_SLOT = new HashSet();
    public static final HashSet<class_1792> BLACKLIST_ITEMS = new HashSet();
    public static final HashSet<class_1792> ELYTRA_ITEMS = new HashSet();
    public static final class_1761.class_7914 CREATIVE_TAB_GENERATOR = (params, output) -> {
        for (Kind value : Kind.values()) {
            if (!Kind.is(value, Kind.BIG_BUNDLE)) {
                output.method_45421((class_1935)value.getItem());
            }
            if (!Kind.METAL.is(value)) continue;
            TRAITS_MAP.keySet().forEach(key -> {
                if (!key.equals("null") && Constants.isLowercase(key)) {
                    output.method_45420(Traits.toStack(key));
                }
            });
        }
        output.method_45421((class_1935)Services.REGISTRY.getLock());
    };

    public static class_5250 getName(class_1799 stack) {
        class_5250 msg = class_2561.method_43473().method_10852(stack.method_7964()).method_27692(stack.method_7932().field_8908);
        if (stack.method_7938()) {
            msg.method_27692(class_124.field_1056);
        }
        return msg;
    }

    public static String itemShortString(class_1792 item) {
        class_2960 key = class_7923.field_41178.method_10221((Object)item);
        if (key.method_12836().equals("minecraft")) {
            return key.method_12832();
        }
        return key.method_12836() + ":" + key.method_12832();
    }

    public static class_1799 createLabeledBackpack(String backpack_id) {
        class_1799 backpackStack = Services.REGISTRY.getMetal().method_7854();
        backpackStack.method_7948().method_10582("backpack_id", backpack_id);
        return backpackStack;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty() || string.isBlank();
    }

    public static boolean isEmpty(class_2561 component) {
        return component == null || component.method_10851().toString().equals("empty");
    }

    public static boolean isLowercase(String string) {
        for (char c : string.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    protected static void register() {
        LOG.info("Initializing Beans' Backpacks Constants");
    }

    public static class_1792 itemFromString(String string) {
        if (string == null) {
            return class_1802.field_8162;
        }
        String[] location = string.split(":");
        class_2960 resourceLocation = new class_2960(location[0], location[1]);
        return (class_1792)class_7923.field_41178.method_10223(resourceLocation);
    }

    @Deprecated(since="0.27-v2")
    public static void addToList(HashSet<class_1792> list, Collection<class_1792> items) {
        list.addAll(items);
        list.removeIf(item -> item.equals(class_1802.field_8162));
    }

    @Deprecated(since="0.27-v2")
    public static class_2371<class_1792> readItemList(class_3300 resourceManager, String location) {
        Map locations = resourceManager.method_14488("modify", in -> in.method_12832().endsWith(location));
        class_2371 items = class_2371.method_10211();
        class_2371 removedItems = class_2371.method_10211();
        locations.forEach((resourceLocation, resource) -> {
            try {
                String line;
                InputStream open = resource.method_14482();
                BufferedReader reader = new BufferedReader(new InputStreamReader(open));
                while ((line = reader.readLine()) != null) {
                    String[] split;
                    for (String id : split = line.replaceAll(" ", "").split(",")) {
                        if (id.startsWith("!")) {
                            removedItems.add((Object)Constants.itemFromString(id.replace("!", "")));
                            continue;
                        }
                        items.add((Object)Constants.itemFromString(id));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        removedItems.add((Object)class_1802.field_8162.method_8389());
        items.removeAll((Collection)removedItems);
        return items;
    }
}

