/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.client.renderer;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.access.Tint;
import com.beansgalaxy.backpacks.client.renderer.RenderHelper;
import com.beansgalaxy.backpacks.client.renderer.TrimHelper;
import com.beansgalaxy.backpacks.client.renderer.features.ElytraFeature;
import com.beansgalaxy.backpacks.client.renderer.models.BackpackModel;
import com.beansgalaxy.backpacks.client.renderer.models.BackpackWingsModel;
import com.beansgalaxy.backpacks.data.Traits;
import com.beansgalaxy.backpacks.data.Viewable;
import com.beansgalaxy.backpacks.entity.Backpack;
import com.beansgalaxy.backpacks.entity.EntityAbstract;
import com.beansgalaxy.backpacks.entity.Kind;
import com.beansgalaxy.backpacks.items.DyableBackpack;
import com.beansgalaxy.backpacks.screen.BackpackScreen;
import java.awt.Color;
import net.minecraft.class_1059;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_4895;
import net.minecraft.class_5348;
import net.minecraft.class_5455;
import net.minecraft.class_5617;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class BackpackRenderer<T extends class_1297>
extends class_897<T> {
    class_2960 TEXTURE = new class_2960("beansbackpacks", "textures/entity/backpack/null.png");
    private final BackpackModel<T> model;
    private final BackpackWingsModel<T> wings;
    private final class_1059 trimAtlas;

    public BackpackRenderer(class_5617.class_5618 ctx) {
        super(ctx);
        this.model = new BackpackModel(ctx.method_32167(RenderHelper.BACKPACK_MODEL));
        this.trimAtlas = ctx.method_48481().method_24153(class_4722.field_42071);
        this.wings = new BackpackWingsModel(ctx.method_32167(RenderHelper.PACK_WINGS_MODEL));
    }

    public void method_3936(@NotNull T entity, float yaw, float tick, @NotNull class_4587 pose, @NotNull class_4597 source, int light) {
        int breakAmount;
        Backpack backpack = (Backpack)((Object)entity);
        if (backpack.method_31481()) {
            return;
        }
        Traits.LocalData traits = backpack.getTraits();
        if (traits.isEmpty() || traits.kind == null) {
            return;
        }
        Viewable viewable = backpack.getViewable();
        EntityAbstract abstractBackpack = null;
        if (backpack instanceof EntityAbstract) {
            EntityAbstract entityAbstract;
            abstractBackpack = entityAbstract = (EntityAbstract)backpack;
            double breakTime = entityAbstract.wobble;
            this.renderNameAndHitbox(pose, source, entity, yaw += (float)(breakTime * (double)0.8f * Math.sin(breakTime / Math.PI * 3.0)), light);
            if (viewable.lastDelta > tick) {
                viewable.updateOpen();
            }
            float headPitch = class_3532.method_16439((float)tick, (float)viewable.lastPitch, (float)viewable.headPitch) * 0.37f;
            this.model.setupPlaced(headPitch);
            viewable.lastDelta = tick;
        } else {
            float headPitch = class_3532.method_16439((float)viewable.lastDelta, (float)viewable.lastPitch, (float)viewable.headPitch) * 0.25f;
            this.model.setupPlaced(headPitch);
        }
        pose.method_22903();
        pose.method_22907(class_7833.field_40715.rotationDegrees(yaw));
        Kind kind = traits.kind;
        Color tint = kind.getShiftedColor(traits.color);
        if (Kind.WINGED.is(kind) && backpack.method_5735().method_10166().method_10179()) {
            pose.method_22903();
            pose.method_22905(1.09f, 1.09f, 1.09f);
            this.wings.method_2828(pose, source.getBuffer(this.model.method_23500(ElytraFeature.WINGED_LOCATION)), light, class_4608.field_21444, (float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f, 1.0f);
            pose.method_22909();
        }
        pose.method_22903();
        float[] colors = new float[]{(float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f};
        class_2960 texture = kind.getAppendedResource(traits.backpack_id, "");
        class_4588 outer = source.getBuffer(class_1921.method_23576((class_2960)texture));
        this.model.method_2828(pose, outer, light, class_4608.field_21444, colors[0], colors[1], colors[2], 1.0f);
        pose.method_22909();
        class_5455 registryAccess = backpack.method_5770().method_30349();
        double distance = this.field_4676.method_23168(entity);
        class_437 currentScreen = class_310.method_1551().field_1755;
        boolean inBackpackScreen = currentScreen instanceof BackpackScreen || currentScreen instanceof class_4895;
        float inflate = inBackpackScreen ? 0.005f : (float)Math.cbrt(distance + 3.0) * 0.003f;
        float deflate = distance < 100.0 || inBackpackScreen ? 0.0f : ((float)Math.sqrt(distance) - 10.0f) * -0.03f;
        BackpackRenderer.renderOverlays(pose, light, source, colors, registryAccess, traits, this.model, this.trimAtlas, inflate, deflate, false);
        if (abstractBackpack != null && (breakAmount = abstractBackpack.breakAmount) > 0) {
            pose.method_22903();
            int breakStage = Math.min(class_3532.method_15386((float)((float)breakAmount / 3.0f)), 7);
            class_2960 location = new class_2960("beansbackpacks", "textures/entity/destroy_stage/" + breakStage + ".png");
            class_4588 crumble = source.getBuffer(class_1921.method_23570((class_2960)location));
            this.model.method_2828(pose, crumble, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            pose.method_22909();
        }
        pose.method_22909();
    }

    private static float[] inflate(float scale, boolean reverseY) {
        return new float[]{(scale + 8.0f) / 8.0f, (scale + 9.0f) / 9.0f, (scale + 4.0f) / 4.0f, (float)(reverseY ? 1 : -1) * scale / 32.0f, (float)(reverseY ? -5 : -1) * scale / 32.0f};
    }

    public static void renderOverlays(class_4587 pose, int light, class_4597 source, float[] colors, class_5455 registryAccess, Traits.LocalData traits, BackpackModel model, class_1059 atlas, float inflateScale, float deflateScale, boolean reverseY) {
        float[] inflate = BackpackRenderer.inflate(inflateScale, reverseY);
        float[] deflate = BackpackRenderer.inflate(deflateScale, reverseY);
        pose.method_22903();
        pose.method_22905(deflate[1], inflate[1], deflate[2] / 2.0f + 0.5f);
        pose.method_46416(0.0f, inflate[3] * 2.0f, -deflate[3] / 3.0f);
        Kind kind = traits.kind;
        class_2960 texture = kind.getAppendedResource(traits.backpack_id, "");
        class_4588 inner = source.getBuffer(class_1921.method_23584((class_2960)texture));
        model.renderMask(pose, inner, light, class_4608.field_21444, colors[0], colors[1], colors[2], 1.0f);
        pose.method_22909();
        class_2487 trim = traits.getTrim();
        String button = traits.button();
        int color = traits.color;
        if (!(button.equals("none") || trim.method_10545("material") && trim.method_10545("pattern"))) {
            if (Tint.isYellow(color)) {
                button = "amethyst";
            } else if (Kind.BIG_BUNDLE.is(kind) && Tint.isGreen(color)) {
                button = "copper";
            }
            if (!Constants.isEmpty(button)) {
                class_2487 tag = new class_2487();
                tag.method_10582("pattern", "beansbackpacks:trim_button_default");
                tag.method_10582("material", button);
                trim = tag;
            }
        }
        boolean noClipTrims = false;
        switch (kind) {
            case WINGED: {
                BackpackRenderer.renderInteriorMask(pose, light, source, model, inflate, deflate, kind);
                break;
            }
            case LEATHER: {
                BackpackRenderer.renderInteriorMask(pose, light, source, model, inflate, deflate, kind);
                Color weighted = DyableBackpack.weightedShift(new Color(16766911), new Color(color), 2.5f, 2.5f, 2.5f, 0);
                float[] floats = new float[]{(float)weighted.getRed() / 255.0f, (float)weighted.getGreen() / 255.0f, (float)weighted.getBlue() / 255.0f};
                BackpackRenderer.renderDyableColorOverlay(pose, light, source, model, inflate, floats, "leather/leather");
                pose.method_22903();
                float[] pouchScale = BackpackRenderer.inflate(0.5f, reverseY);
                pose.method_22905(pouchScale[0], pouchScale[1], pouchScale[2]);
                pose.method_46416(0.0f, pouchScale[3] / 2.0f, 0.0f);
                class_2960 pouch = new class_2960("beansbackpacks", "textures/entity/leather/pouch.png");
                class_4588 pouchTexture = source.getBuffer(class_1921.method_23578((class_2960)pouch));
                model.method_2828(pose, pouchTexture, light, class_4608.field_21444, colors[0], colors[1], colors[2], 1.0f);
                pose.method_22905(inflate[0], inflate[1], inflate[2]);
                pose.method_46416(0.0f, inflate[3], 0.0f);
                class_2960 pouchOverlay = new class_2960("beansbackpacks", "textures/entity/leather/pouch_overlay.png");
                class_4588 pouchOverlayTexture = source.getBuffer(class_1921.method_23689((class_2960)pouchOverlay));
                model.method_2828(pose, pouchOverlayTexture, light, class_4608.field_21444, (float)weighted.getRed() / 255.0f, (float)weighted.getGreen() / 255.0f, (float)weighted.getBlue() / 255.0f, 0.8f);
                pose.method_22909();
                break;
            }
            case BIG_BUNDLE: {
                int rgb = DyableBackpack.shiftBundleColor(color).getRGB();
                Tint tint = new Tint(rgb);
                Tint.HSL hsv = tint.HSL().rotate(230.0);
                double brightness = tint.brightness();
                double sat = hsv.getSat();
                double lum1 = hsv.getLum();
                hsv.setLum(Math.sqrt(brightness * (-lum1 * 0.8 + 1.0))).scaleSat(Math.sqrt(sat) * 0.8);
                hsv.push();
                BackpackRenderer.renderDyableColorOverlay(pose, light, source, model, inflate, tint.getFloats(), "back_bundle/bundle");
                BackpackRenderer.renderInteriorMask(pose, light, source, model, inflate, deflate, kind);
                noClipTrims = true;
                pose.method_22903();
                pose.method_22905(inflate[0], inflate[1], inflate[2] * 2.0f - 1.0f);
                pose.method_46416(0.0f, inflate[3], inflate[4]);
                class_2960 overlay = new class_2960("beansbackpacks", "textures/entity/back_bundle/bundle_highlight.png");
                class_4588 overlayTexture = source.getBuffer(class_1921.method_23689((class_2960)overlay));
                Tint highlight = new Tint(color);
                Tint.HSL hsl = highlight.HSL();
                double lum = hsl.getLum();
                hsl.setLum((Math.cbrt(lum + 0.2) + lum) / 2.0).rotate(5.0).setSat(Math.sqrt((hsl.getSat() + brightness) / 2.0));
                hsl.push();
                float[] f = highlight.getFloats();
                model.method_2828(pose, overlayTexture, light, class_4608.field_21444, f[0], f[1], f[2], 0.6f);
            }
        }
        TrimHelper.getBackpackTrim(registryAccess, trim).ifPresent(trim1 -> {
            pose.method_22903();
            pose.method_22905(inflate[0], inflate[1], inflate[2] * 2.0f - 1.0f);
            pose.method_22903();
            class_4588 vc = atlas.method_4608(trim1.backpackTexture(traits.material())).method_24108(source.getBuffer(class_1921.method_23576((class_2960)class_4722.field_42071)));
            pose.method_46416(0.0f, -inflate[3], inflate[4]);
            model.method_2828(pose, vc, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            pose.method_22909();
            pose.method_46416(0.0f, inflate[3] * 3.0f, 0.0f);
            pose.method_22905(1.0f, 1.0f, 1.0f);
            model.method_2828(pose, vc, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            pose.method_22909();
        });
        if (noClipTrims) {
            pose.method_22909();
        }
    }

    private static void renderDyableColorOverlay(class_4587 pose, int light, class_4597 source, BackpackModel<?> model, float[] inflate, float[] color, String path) {
        pose.method_22903();
        pose.method_22905(inflate[0], inflate[1], inflate[2] * 2.0f - 1.0f);
        pose.method_46416(0.0f, inflate[3], inflate[4]);
        class_2960 overlay = new class_2960("beansbackpacks", "textures/entity/" + path + "_overlay.png");
        class_4588 overlayTexture = source.getBuffer(class_1921.method_23689((class_2960)overlay));
        model.method_2828(pose, overlayTexture, light, class_4608.field_21444, color[0], color[1], color[2], 1.0f);
        pose.method_22909();
    }

    private static void renderInteriorMask(class_4587 pose, int light, class_4597 source, BackpackModel<?> model, float[] inflate, float[] deflate, Kind kind) {
        pose.method_22903();
        pose.method_22905(deflate[1], inflate[1], deflate[2] / 2.0f + 0.5f);
        pose.method_46416(0.0f, inflate[3], -deflate[3] / 3.0f);
        class_2960 pouchTexture = kind.getAppendedResource("", "_interior");
        class_4588 pouch = source.getBuffer(class_1921.method_23578((class_2960)pouchTexture));
        model.renderMask(pose, pouch, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        pose.method_22909();
    }

    private void renderNameAndHitbox(class_4587 pose, class_4597 mbs, T entity, float yaw, int light) {
        class_3966 hitResult;
        class_310 minecraft = class_310.method_1551();
        class_239 class_2392 = minecraft.field_1765;
        if (class_2392 instanceof class_3966 && (hitResult = (class_3966)class_2392).method_17782() == entity && !minecraft.field_1690.field_1842) {
            class_238 box;
            class_2561 displayName;
            if (this.method_3921((class_1297)entity) && !Constants.isEmpty(displayName = entity.method_5476())) {
                pose.method_22903();
                double $$5 = this.field_4676.method_23168(entity);
                if (!($$5 > 4096.0)) {
                    class_2350 direction = entity.method_5735();
                    float y = entity.method_51152();
                    double yOff = entity.method_23320() - this.field_4676.field_4686.method_19326().field_1351;
                    pose.method_46416((float)(direction.method_10148() * 5) / 16.0f, y -= (float)(yOff / 16.0), (float)(direction.method_10165() * 5) / 16.0f);
                    pose.method_22907(this.field_4676.method_24197());
                    pose.method_22905(-0.02f, -0.02f, 1.0f);
                    Matrix4f $$9 = pose.method_23760().method_23761();
                    float $$10 = class_310.method_1551().field_1690.method_19343(0.25f);
                    int $$11 = (int)($$10 * 255.0f) << 24;
                    class_327 $$12 = this.method_3932();
                    float $$13 = -$$12.method_27525((class_5348)displayName) / 2;
                    $$12.method_30882(displayName, $$13, 0.0f, 0x20FFFFFF, false, $$9, mbs, class_327.class_6415.field_33994, $$11, light);
                    $$12.method_30882(displayName, $$13, 0.0f, -1, false, $$9, mbs, class_327.class_6415.field_33993, 0, light);
                }
                pose.method_22909();
            }
            pose.method_22903();
            class_4588 vertices = mbs.getBuffer(class_1921.method_23594());
            float brightness = (float)Math.min(light, 300) / 300.0f / 2.0f;
            float value = 0.3f * brightness;
            float alpha = 1.0f;
            if (!entity.method_5735().method_10166().method_10179()) {
                double h = 0.5625;
                double w = 0.25;
                double d = 0.125;
                box = new class_238(w, 0.0, d, -w, h, -d);
                box.method_989(-entity.method_23317(), -entity.method_23318(), -entity.method_23321());
            } else {
                box = entity.method_5829().method_989(-entity.method_23317(), -entity.method_23318(), -entity.method_23321());
                float yRot = entity.method_5735().method_10144();
                yaw += yRot;
            }
            pose.method_22907(class_7833.field_40715.rotationDegrees(yaw));
            class_761.method_22982((class_4587)pose, (class_4588)vertices, (class_238)box, (float)value, (float)value, (float)value, (float)alpha);
            pose.method_22909();
        }
    }

    public class_2960 method_3931(T entity) {
        return this.TEXTURE;
    }
}

