/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.client.renderer;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.access.PosAccessor;
import com.beansgalaxy.backpacks.data.BackData;
import com.beansgalaxy.backpacks.data.config.TooltipType;
import com.beansgalaxy.backpacks.inventory.BackpackTooltip;
import com.beansgalaxy.backpacks.items.Tooltip;
import java.util.Iterator;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1309;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_485;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_5684;
import net.minecraft.class_746;
import net.minecraft.class_811;
import org.joml.Matrix4f;

public class ClientBackpackTooltip
implements class_5684 {
    private static final int MAX_DISPLAY = 60;
    private static final int SPACING = 18;
    private final class_2371<class_1799> itemStacks;
    private final class_310 minecraft;
    private final int size;
    private final boolean isCuriosMenu;
    private final TooltipType tooltipType;

    public ClientBackpackTooltip(BackpackTooltip tooltip) {
        this.itemStacks = tooltip.itemStacks;
        this.minecraft = class_310.method_1551();
        this.size = Math.min(this.itemStacks.size(), 60);
        this.tooltipType = (TooltipType)((Object)Constants.CLIENT_CONFIG.tooltip_style.get());
        this.isCuriosMenu = Tooltip.isCuriosMenu();
    }

    public int method_32661() {
        return this.isCuriosMenu && TooltipType.INTEGRATED != this.tooltipType ? -17 : -2;
    }

    public int method_32664(class_327 font) {
        return 0;
    }

    public void method_32666(class_327 font, int cursorX, int cursorY, class_332 gui) {
        if (!this.isCuriosMenu) {
            cursorX += 10000;
        }
        switch (this.tooltipType) {
            case VANILLA: {
                this.renderVanilla(font, gui, cursorX, cursorY);
                break;
            }
            case INTEGRATED: {
                this.renderLarge(font, gui, cursorX + 2, cursorY - 6);
                break;
            }
            default: {
                this.renderCompact(font, gui, cursorX, cursorY);
            }
        }
    }

    private void renderVanilla(class_327 font, class_332 gui, int mouseX, int mouseY) {
        int y;
        Iterator stacks = this.itemStacks.iterator();
        class_2960 bundleTexture = new class_2960("textures/gui/container/bundle.png");
        class_746 player = this.minecraft.field_1724;
        BackData backData = BackData.get((class_1657)player);
        boolean hasSpace = backData.getBackpackInventory().spaceLeft() > 0;
        int limitC = 5;
        double sudoSize = (double)this.size + (hasSpace ? 1.0 : 0.0);
        double sqrt = Math.sqrt(sudoSize);
        int columns = class_3532.method_15384((double)(sqrt > (double)limitC ? sqrt - (sqrt - (double)limitC) / 3.0 : sqrt));
        int rows = class_3532.method_15384((double)sqrt);
        int leftPos = mouseX + 10;
        int offset = this.isCuriosMenu ? 5 : class_3532.method_15384((double)(sudoSize / (double)columns)) * 4;
        int topPos = mouseY - offset;
        int spacing = 18;
        int w = columns * spacing;
        if (player.field_7498.method_34255().method_7960()) {
            class_1799 item = (class_1799)this.itemStacks.get(0);
            class_5250 name = Constants.getName(item);
            int textWidth = font.method_30880(name.method_30937());
            int textOffset = (hasSpace ? -9 : 5) + (columns > 4 ? 0 : 7);
            int textLengthOverflow = this.isCuriosMenu ? 0 : textWidth - w + 12;
            int tooLong = Math.max(textOffset, textLengthOverflow);
            ClientBackpackTooltip.drawTooltipBox(gui, leftPos - tooLong, topPos - 28, textWidth + 5, 12, 0);
            gui.method_27535(font, (class_2561)name, leftPos + 3 - tooLong, topPos - 26, -1);
        }
        int firstX = leftPos - 9;
        int firstY = topPos - 9;
        gui.method_25291(bundleTexture, firstX, firstY, 200, 0.0f, 0.0f, spacing, spacing, 128, 128);
        int x = hasSpace ? 1 : 0;
        int itemsLeft = this.itemStacks.size();
        for (y = 0; stacks.hasNext() && y < rows; ++y) {
            while (x < columns) {
                int x1 = x * spacing + leftPos;
                int y1 = y * spacing + topPos;
                if (rows - 1 == y && x == columns - 1 && itemsLeft > 1) {
                    String text = "&" + itemsLeft;
                    int textW = font.method_1727(text);
                    int center = x1 - textW / 2 + 1;
                    gui.method_25303(font, text, center, y1 - 3, -1);
                } else if (stacks.hasNext()) {
                    gui.method_25291(bundleTexture, x1 - 9, y1 - 9, 200, 0.0f, 0.0f, spacing, spacing, 128, 128);
                    class_1799 stack = (class_1799)stacks.next();
                    this.renderItem(this.minecraft, gui, stack, x1, y1, 300, false);
                    this.renderItemDecorations(gui, font, stack, x1, y1, 300);
                    --itemsLeft;
                } else {
                    gui.method_25291(bundleTexture, x1 - 9, y1 - 9, 200, 0.0f, hasSpace ? 0.0f : 40.0f, spacing, spacing, 128, 128);
                }
                ++x;
            }
            x = 0;
        }
        boolean empty = player.field_7498.method_34255().method_7960();
        boolean isQuickMove = backData.menusKeyDown || class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)340) || class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)344);
        int fillX = firstX + ((empty || isQuickMove) && hasSpace ? spacing : 0);
        gui.method_51737(fillX + 1, firstY + 1, fillX + 17, firstY + 17, 500, 0x78FFFFFF);
        ClientBackpackTooltip.drawTooltipBox(gui, leftPos - 12, topPos - 11, w + 5, y * spacing + 4, 0);
    }

    private void renderCompact(class_327 font, class_332 gui, int mouseX, int mouseY) {
        int rows;
        double sqrt = Math.sqrt(this.size);
        int c = Math.min(class_3532.method_15384((double)(sqrt + 6.0)) / 2, class_3532.method_15384((double)sqrt));
        int columns = c > 5 ? c : (this.size < 5 ? this.size : (c + 5) / 2);
        int r = class_3532.method_15386((float)((float)this.size / (float)columns));
        if (r > 2) {
            rows = (r + 2) / 2;
            columns += (r - rows) / 2;
        } else {
            rows = r;
        }
        int offsetY = this.isCuriosMenu ? 15 : rows * 7;
        int maxRows = 5;
        int maxColumns = 7;
        int itemsWidth = Math.min(maxColumns, columns) * 18 + 3;
        if (this.minecraft.field_1724.field_7498.method_34255().method_7960()) {
            class_1799 item = (class_1799)this.itemStacks.get(0);
            class_5250 name = Constants.getName(item);
            int textWidth = font.method_30880(name.method_30937());
            int textLengthOverflow = this.isCuriosMenu ? 0 : textWidth - itemsWidth + 7;
            int tooltipOffset = Math.max(0, textLengthOverflow);
            ClientBackpackTooltip.drawTooltipBox(gui, mouseX - tooltipOffset, mouseY - 18 - offsetY, textWidth + 5, 12, 0);
            gui.method_27535(font, (class_2561)name, mouseX + 3 - tooltipOffset, mouseY - offsetY - 16, -1);
        }
        ClientBackpackTooltip.drawTooltipBox(gui, mouseX - 2, mouseY - 1 - offsetY, itemsWidth, Math.min(maxRows, rows) * 18 + 2, 0);
        this.drawItems(font, gui, mouseX - 1, mouseY - offsetY, rows, columns, 5, 7);
    }

    private void renderLarge(class_327 font, class_332 gui, int mouseX, int mouseY) {
        int x;
        int rows;
        int columns;
        class_437 screen = this.minecraft.field_1755;
        if (!(screen instanceof class_485)) {
            return;
        }
        double size = this.size;
        int maxColumns = 9;
        int maxRows = 3;
        if (this.size < 4) {
            columns = class_3532.method_15384((double)Math.sqrt(this.size));
            rows = class_3532.method_15384((double)(size / (double)columns));
        } else if (this.size < 9) {
            rows = class_3532.method_15357((double)Math.sqrt(this.size));
            columns = class_3532.method_15384((double)(size / (double)rows));
        } else {
            double pow = Math.log(size / 2.0) + 1.0;
            rows = pow > (double)maxRows ? maxRows : class_3532.method_15357((double)pow);
            int floor = class_3532.method_15357((double)((size / (double)rows + 6.0) / 2.0));
            columns = floor > maxColumns ? floor - (floor - maxColumns) / 3 : floor - (floor + 1) % 2;
        }
        PosAccessor invScreen = (PosAccessor)screen;
        int[] pos = invScreen.getPos();
        int y = pos[1];
        int h = 18 * rows;
        int w = Math.min(columns, maxColumns) * 18;
        if (columns > 4) {
            x = pos[0] - class_3532.method_15357((double)((double)w / 2.0)) - 1;
        } else {
            double offset = size > 4.0 ? 2.5 : 1.5;
            x = class_3532.method_15384((double)((double)pos[0] - 18.0 * offset)) - 1;
        }
        if (this.minecraft.field_1724.field_7498.method_34255().method_7960()) {
            if (!(screen instanceof class_490)) {
                mouseX = x + 10;
                mouseY = pos[1] - 15;
            }
            class_1799 item = (class_1799)this.itemStacks.get(0);
            class_5250 name = Constants.getName(item);
            int width1 = font.method_30880(name.method_30937());
            ClientBackpackTooltip.drawTooltipBox(gui, mouseX - 3, mouseY - 2, width1 + 5, 12, 150);
            gui.method_51448().method_22903();
            gui.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            gui.method_27535(font, (class_2561)name, mouseX, mouseY, -1);
            gui.method_51448().method_22909();
        }
        ClientBackpackTooltip.drawTooltipBox(gui, x, y, w + 1, h, 0);
        this.drawItems(font, gui, x, y, rows, columns, 3, maxColumns);
    }

    private void drawItems(class_327 font, class_332 gui, int x, int y, int r, int c, int maxRows, int maxColumns) {
        Iterator stacks = this.itemStacks.iterator();
        int itemsLeft = this.size;
        int totalRows = Math.min(r, maxRows);
        int extraItems = this.size - r * c;
        int i = 0;
        while (itemsLeft > 0) {
            int count;
            if (i == 0) {
                count = c;
            } else if (totalRows == i + 1) {
                count = itemsLeft;
            } else {
                double progress = (double)i / ((double)totalRows - 1.0);
                double lerp = class_3532.method_16436((double)extraItems, (double)0.0, (double)(progress * 0.5));
                count = Math.max(c, c + class_3532.method_15357((double)lerp));
            }
            for (int j = 0; stacks.hasNext() && j < count; ++j) {
                int itemX;
                class_1799 stack = (class_1799)stacks.next();
                if (stack.method_7960()) continue;
                int column = j % count;
                int columns = Math.min(c, maxColumns);
                if (count > columns) {
                    double linear = (double)column / (double)(count - 1);
                    double lerp = class_3532.method_16436((double)(columns - 1), (double)0.0, (double)linear);
                    itemX = class_3532.method_15384((double)(lerp * 18.0));
                } else {
                    itemX = class_3532.method_15386((float)(column * 18));
                }
                int itemY = y + 18 * i + 9;
                int z = -j * 12 + 400;
                this.renderItem(this.minecraft, gui, stack, itemX += x + 10, itemY, z, true);
                this.renderItemDecorations(gui, font, stack, itemX, itemY, z);
            }
            itemsLeft -= count;
            ++i;
        }
        gui.method_51737(x + 2, y + 1, x + 18, y + 17, 500, 0x66FFFFFF);
    }

    private static void drawTooltipBox(class_332 gui, int x, int y, int w, int h, int z) {
        int bgColor = -267386864;
        gui.method_51737(x - 1, y - 1, x + w + 2, y + h + 1, z, bgColor);
        gui.method_51737(x, y - 1, x + w, y - 2, z, bgColor);
        gui.method_51737(x, y + h + 2, x + w, y + h + 1, z, bgColor);
        int topColor = 0x505000FF;
        int botColor = 1344798847;
        gui.method_51737(x, y, x + w, y - 1, z, topColor);
        gui.method_33284(x, y, x + 1, y + h, z, topColor, botColor);
        gui.method_33284(x + w, y, x + w + 1, y + h, z, topColor, botColor);
        gui.method_51737(x, y + h + 1, x + w, y + h, z, botColor);
    }

    public void renderItemDecorations(class_332 gui, class_327 $$0, class_1799 $$1, int x, int y, int z) {
        if (!$$1.method_7960()) {
            class_4587 pose = gui.method_51448();
            pose.method_22903();
            pose.method_46416(0.0f, 0.0f, (float)(z + 10));
            if ($$1.method_7947() != 1) {
                String $$5 = String.valueOf($$1.method_7947());
                gui.method_51433($$0, $$5, x + 9 - $$0.method_1727($$5), y + 1, -1, true);
            } else if ($$1.method_31578()) {
                int barColor = $$1.method_31580();
                int barX = x - 6;
                int barY = y + 5;
                gui.method_25294(barX, barY, barX + 13, barY + 2, -16777216);
                gui.method_25294(barX, barY, barX + $$1.method_31579(), barY + 1, barColor | 0xFF000000);
            }
            pose.method_22909();
        }
    }

    private void renderItem(class_310 minecraft, class_332 gui, class_1799 stack, int x, int y, int z, boolean drawShadows) {
        class_4587 pose = gui.method_51448();
        pose.method_22903();
        class_1087 model = minecraft.method_1480().method_4019(stack, (class_1937)minecraft.field_1687, (class_1309)minecraft.field_1724, 0);
        pose.method_46416((float)x, (float)y, (float)z);
        try {
            boolean $$8;
            pose.method_34425(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
            pose.method_22905(16.0f, 16.0f, 16.0f);
            boolean bl = $$8 = !model.method_24304();
            if ($$8) {
                class_308.method_24210();
            }
            minecraft.method_1480().method_23179(stack, class_811.field_4317, false, pose, (class_4597)gui.method_51450(), 0xF000F0, class_4608.field_21444, model);
            if (drawShadows && !model.method_4712()) {
                pose.method_46416(0.0625f, -0.0625f, -0.0625f);
                minecraft.method_1480().method_23179(stack, class_811.field_4317, false, pose, (class_4597)gui.method_51450(), 0, class_4608.field_21444, model);
            }
            gui.method_51452();
            if ($$8) {
                class_308.method_24211();
            }
        }
        catch (Throwable var12) {
            class_128 $$10 = class_128.method_560((Throwable)var12, (String)"Rendering item");
            class_129 $$11 = $$10.method_562("Item being rendered");
            $$11.method_577("Item Type", () -> String.valueOf(stack.method_7909()));
            $$11.method_577("Item Damage", () -> String.valueOf(stack.method_7919()));
            $$11.method_577("Item NBT", () -> String.valueOf(stack.method_7969()));
            $$11.method_577("Item Foil", () -> String.valueOf(stack.method_7958()));
            throw new class_148($$10);
        }
        pose.method_22909();
    }
}

