/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.client.renderer.features;

import com.beansgalaxy.backpacks.client.renderer.BackpackRenderer;
import com.beansgalaxy.backpacks.client.renderer.RenderHelper;
import com.beansgalaxy.backpacks.client.renderer.features.BackFeature;
import com.beansgalaxy.backpacks.client.renderer.models.BackpackCapeModel;
import com.beansgalaxy.backpacks.client.renderer.models.BackpackModel;
import com.beansgalaxy.backpacks.data.BackData;
import com.beansgalaxy.backpacks.data.Traits;
import com.beansgalaxy.backpacks.data.Viewable;
import com.beansgalaxy.backpacks.entity.Kind;
import java.awt.Color;
import net.minecraft.class_1059;
import net.minecraft.class_1092;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5455;
import net.minecraft.class_5599;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_742;
import org.joml.Quaternionf;

public class BackpackFeature<T extends class_1309, M extends class_583<T>> {
    private final BackpackModel<class_1657> backpackModel;
    private final BackpackCapeModel<class_1657> capeModel;
    private final class_1059 trimAtlas;
    private final BackFeature<T, M> backFeature;

    public BackpackFeature(class_5599 loader, class_1092 modelManager, BackFeature<T, M> backFeature) {
        this.backpackModel = new BackpackModel(loader.method_32072(RenderHelper.BACKPACK_MODEL));
        this.capeModel = new BackpackCapeModel(loader.method_32072(RenderHelper.PACK_CAPE_MODEL));
        this.trimAtlas = modelManager.method_24153(class_4722.field_42071);
        this.backFeature = backFeature;
    }

    public void render(class_4587 pose, class_4597 mbs, int light, class_742 player, class_630 torso, BackData backData, float delta) {
        Traits.LocalData traits = backData.getTraits();
        pose.method_22903();
        pose.method_22907(new Quaternionf().rotationXYZ(torso.field_3654, torso.field_3675, torso.field_3674));
        float scale = this.backFeature.sneakInter / 3.0f;
        BackFeature.weld(this.backpackModel.main, torso);
        class_1799 chestStack = player.method_6118(class_1304.field_6174);
        pose.method_46416(0.0f, 0.75f, 0.0f);
        Viewable viewable = backData.getBackpackInventory().getViewable();
        if (viewable.lastDelta > delta) {
            viewable.updateOpen();
        }
        float fallDistance = player.field_6017;
        float fallPitch = player.method_6128() ? 0.0f : (float)Math.log(fallDistance * 3.0f + 1.0f) * -0.05f;
        float headPitch = class_3532.method_16439((float)delta, (float)viewable.lastPitch, (float)viewable.headPitch) * 0.3f;
        this.backpackModel.setOpenAngle(headPitch + fallPitch);
        Kind kind = traits.kind;
        if (kind.is(Kind.WINGED) || Kind.isWings(chestStack)) {
            this.setUpWithWings(player, scale, pose);
        } else {
            boolean hasChestplate = !chestStack.method_7960();
            pose.method_22904(0.0, 0.24 * (double)scale + (hasChestplate ? 0.02 : 0.0), -(0.096 * (double)scale) + (hasChestplate ? 0.065 : 0.001));
            this.renderCapeAbove(pose, mbs, light, player, chestStack, headPitch, fallPitch);
        }
        Color tint = kind.getShiftedColor(traits.color);
        float[] colors = new float[]{(float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f};
        class_2960 texture = kind.getAppendedResource(traits.backpack_id, "");
        class_4588 vc = mbs.getBuffer(this.backpackModel.method_23500(texture));
        this.backpackModel.method_2828(pose, vc, light, class_4608.field_21444, colors[0], colors[1], colors[2], 1.0f);
        double distance = Math.sqrt(class_310.method_1551().method_1561().method_23168((class_1297)player));
        float inflate = ((float)distance + 1.0f) * 0.001f;
        float deflate = (float)distance * -0.01f;
        class_5455 registryAccess = player.method_5770().method_30349();
        BackpackRenderer.renderOverlays(pose, light, mbs, colors, registryAccess, traits, this.backpackModel, this.trimAtlas, inflate, deflate, true);
        pose.method_22909();
        viewable.lastDelta = delta;
    }

    private void renderCapeAbove(class_4587 pose, class_4597 mbs, int light, class_742 player, class_1799 chestStack, float headPitch, float fallPitch) {
        class_2960 cloakTexture = player.method_3119();
        if (cloakTexture != null) {
            if (chestStack.method_7960()) {
                pose.method_46416(0.0f, 0.0625f, 0.0f);
            }
            BackFeature.weld(this.capeModel.cape, this.backpackModel.main);
            this.capeModel.cape.field_3675 = (float)Math.PI * 2;
            this.capeModel.cape.field_3654 = -headPitch;
            this.capeModel.cape.field_3656 = fallPitch * 6.0f - 11.0f;
            this.capeModel.cape.field_3655 = 2.0f;
            class_1921 renderType = class_1921.method_23572((class_2960)cloakTexture);
            class_4588 vertexConsumer = mbs.getBuffer(renderType);
            this.capeModel.cape.method_22699(pose, vertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private void setUpWithWings(class_742 player, float scale, class_4587 poseStack) {
        float wingSpread;
        boolean fallFlying = player.method_6128();
        if (fallFlying) {
            class_243 deltaMovement = player.method_18798();
            class_243 norm = deltaMovement.method_1029();
            wingSpread = norm.field_1351 > 0.0 ? 0.0f : (float)Math.pow(-norm.field_1351, 1.5);
        } else {
            wingSpread = 1.0f;
        }
        float xRot = 0.3f * wingSpread;
        float z = class_3532.method_16439((float)scale, (float)(fallFlying ? xRot : 0.25f), (float)-0.09375f);
        float y = class_3532.method_16439((float)scale, (float)(fallFlying ? -0.0625f : 0.0f), (float)0.1875f);
        poseStack.method_46416(0.0f, y, z);
        poseStack.method_22907(new Quaternionf().rotationXYZ(class_3532.method_16439((float)scale, (float)xRot, (float)0.0f), 0.0f, 0.0f));
    }
}

