/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.client.renderer.features;

import com.beansgalaxy.backpacks.access.BucketItemAccess;
import com.beansgalaxy.backpacks.access.BucketsAccess;
import com.beansgalaxy.backpacks.client.renderer.RenderHelper;
import com.beansgalaxy.backpacks.client.renderer.features.BackFeature;
import com.beansgalaxy.backpacks.client.renderer.models.CauldronModel;
import com.beansgalaxy.backpacks.inventory.CauldronInventory;
import com.beansgalaxy.backpacks.platform.Services;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1092;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5599;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_7923;
import org.joml.Quaternionf;

public class CauldronFeature<T extends class_1309, M extends class_583<T>> {
    public static final class_2960 TEXTURE = new class_2960("beansbackpacks", "textures/entity/cauldron.png");
    private final CauldronModel<class_1657> cauldronModel;
    private final BackFeature<T, M> backFeature;
    private final class_1059 blocksAtlas;

    public CauldronFeature(class_5599 loader, class_1092 modelManager, BackFeature<T, M> backFeature) {
        this.cauldronModel = new CauldronModel(loader.method_32072(RenderHelper.CAULDRON_MODEL));
        this.blocksAtlas = modelManager.method_24153(class_1723.field_21668);
        this.backFeature = backFeature;
    }

    public void render(class_4587 pose, class_4597 mbs, class_742 player, int light, class_630 torso, class_1799 backStack) {
        int amount;
        class_2487 fluidTag;
        pose.method_22903();
        float scale = this.backFeature.sneakInter / 3.0f;
        boolean hasChestplate = !player.method_6118(class_1304.field_6174).method_7960();
        pose.method_22907(new Quaternionf().rotationXYZ(torso.field_3654, torso.field_3675, torso.field_3674));
        pose.method_22904(0.0, -1.0625 + 0.18 * (double)scale + (hasChestplate ? 0.02 : 0.0), 0.3125 - 0.096 * (double)scale + (hasChestplate ? 0.065 : 0.001));
        class_4588 cauldVC = mbs.getBuffer(this.cauldronModel.method_23500(TEXTURE));
        this.cauldronModel.method_2828(pose, cauldVC, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        if (backStack.method_7985() && backStack.method_7969().method_10545("back_slot") && (fluidTag = backStack.method_7941("back_slot")).method_10545("id") && fluidTag.method_10545("amount") && (amount = fluidTag.method_10550("amount")) > 0) {
            class_1792 bucket = (class_1792)class_7923.field_41178.method_10223(new class_2960(fluidTag.method_10558("id")));
            pose.method_22905(0.5f, 0.5f, 0.5f);
            int cappedAmount = (int)((float)amount / ((float)CauldronInventory.getMaxSize() / 6.0f));
            pose.method_22904(0.0, (double)(-((float)cappedAmount / 8.0f) + 1.5f) + (cappedAmount == 0 ? -0.01 : 0.0), 0.0);
            if (bucket instanceof BucketItemAccess) {
                BucketItemAccess access = (BucketItemAccess)bucket;
                class_3611 fluid = access.beans_Backpacks_2$getFluid();
                if (fluid == null) {
                    CauldronFeature.close(pose);
                    return;
                }
                CauldronInventory.FluidAttributes attributes = Services.COMPAT.getFluidTexture(fluid, this.blocksAtlas);
                class_1058 sprite = attributes.sprite();
                if (sprite == null) {
                    CauldronFeature.close(pose);
                    return;
                }
                class_4588 fluidVC = sprite.method_24108(mbs.getBuffer(class_1921.method_23583()));
                this.cauldronModel.fluid.method_22699(pose, fluidVC, light, class_4608.field_21444, (float)attributes.tint().getRed() / 255.0f, (float)attributes.tint().getGreen() / 255.0f, (float)attributes.tint().getBlue() / 255.0f, 1.0f);
            } else if (bucket instanceof BucketsAccess) {
                BucketsAccess access = (BucketsAccess)bucket;
                Optional<class_2680> optional = access.getBlockState();
                optional.ifPresent(blockState -> {
                    class_4588 blockVC = mbs.getBuffer(class_4696.method_23683((class_2680)blockState, (boolean)false));
                    class_310 instance = class_310.method_1551();
                    class_1058 particleIcon = instance.method_1541().method_3349(blockState).method_4711();
                    Color color = new Color(instance.method_1505().method_1697(blockState, null, null, 0));
                    this.cauldronModel.fluid.method_22699(pose, particleIcon.method_24108(blockVC), light, class_4608.field_21444, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
                });
            }
        }
        CauldronFeature.close(pose);
    }

    private static void close(class_4587 pose) {
        pose.method_22909();
    }
}

