/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.client.renderer.features;

import com.beansgalaxy.backpacks.client.renderer.features.BackFeature;
import com.beansgalaxy.backpacks.data.BackData;
import com.beansgalaxy.backpacks.data.Traits;
import com.beansgalaxy.backpacks.items.WingedBackpack;
import com.beansgalaxy.backpacks.platform.Services;
import java.awt.Color;
import net.minecraft.class_1309;
import net.minecraft.class_1664;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_563;
import net.minecraft.class_583;
import net.minecraft.class_742;
import net.minecraft.class_918;
import org.jetbrains.annotations.NotNull;

public class ElytraFeature<T extends class_1309, M extends class_583<T>> {
    private static final class_2960 ELYTRA_LOCATION = new class_2960("textures/entity/elytra.png");
    public static final class_2960 WINGED_LOCATION = new class_2960("beansbackpacks", "textures/entity/elytra/winged.png");
    private final class_563<T> elytraModel;
    private final BackFeature<T, M> backFeature;

    public ElytraFeature(class_5599 loader, BackFeature<T, M> backFeature) {
        this.elytraModel = new class_563(loader.method_32072(class_5602.field_27559));
        this.backFeature = backFeature;
    }

    public void render(class_4587 pose, class_4597 mbs, int light, T entity, float limbAngle, float limbDistance, float animationProgress, float yHeadRot, float headPitch, M parent, BackData backData) {
        class_1799 backStack = backData.getStack();
        class_2960 texture = this.getElytraResource(backStack, backData);
        Traits.LocalData traits = backData.getTraits();
        int colorInt = backStack.method_7909() instanceof WingedBackpack ? WingedBackpack.shiftColor(traits.color).getRGB() : 0xFFFFFF;
        Color tint = new Color(colorInt);
        pose.method_22903();
        pose.method_46416(0.0f, 0.0f, 0.125f);
        parent.method_17081(this.elytraModel);
        this.elytraModel.method_17079(entity, limbAngle, limbDistance, animationProgress, yHeadRot, headPitch);
        class_4588 vc1 = class_918.method_27952((class_4597)mbs, (class_1921)class_1921.method_25448((class_2960)texture), (boolean)false, (boolean)backStack.method_7958());
        this.elytraModel.method_2828(pose, vc1, light, class_4608.field_21444, (float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f, 1.0f);
        pose.method_22909();
    }

    private class_2960 getElytraResource(class_1799 backStack, BackData backData) {
        if (backStack.method_31574(Services.REGISTRY.getWinged())) {
            return WINGED_LOCATION;
        }
        if (backStack.method_31574(class_1802.field_8833)) {
            class_2960 texture = ELYTRA_LOCATION;
            class_742 player = (class_742)backData.owner;
            if (player.method_3126() && player.method_3122() != null) {
                texture = player.method_3122();
            } else if (player.method_3125() && player.method_3119() != null && player.method_7348(class_1664.field_7559)) {
                texture = player.method_3119();
            }
            return texture;
        }
        return new class_2960("beansbackpacks", "textures/entity/elytra/" + backStack.method_7909().toString().replace(":", "$") + ".png");
    }

    @NotNull
    public static class_2960 getWingedBackpackResource(String key) {
        return new class_2960("beansbackpacks", "textures/entity/elytra/winged.png");
    }
}

