/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.compat;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.config.IConfig;
import com.beansgalaxy.backpacks.data.BackData;
import com.beansgalaxy.backpacks.entity.Kind;
import com.beansgalaxy.backpacks.platform.Services;
import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public class TrinketsRegistry {
    public static void register() {
        Trinket trinket = new Trinket(){

            public TrinketEnums.DropRule getDropRule(class_1799 stack, SlotReference slot, class_1309 entity) {
                CommonClass.test();
                return TrinketEnums.DropRule.KEEP;
            }

            public boolean canEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
                class_1657 player;
                boolean defaults = super.canEquip(stack, slot, entity) && slot.index() == 0;
                boolean mayEquip = entity instanceof class_1657 && BackData.get(player = (class_1657)entity).mayEquip(stack, true, false);
                return defaults && mayEquip && stack.method_7947() <= 1;
            }

            public boolean canUnequip(class_1799 stack, SlotReference slot, class_1309 entity) {
                if (entity instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    return BackData.get((class_1657)player).backSlot.method_7674(player);
                }
                return super.canUnequip(stack, slot, entity);
            }

            public void onEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
                if (entity instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    if (slot.index() == 0) {
                        BackData.get(player).update(stack);
                    }
                }
                super.onEquip(stack, slot, entity);
            }

            public void onUnequip(class_1799 stack, SlotReference slot, class_1309 entity) {
                if (entity instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    if (slot.index() == 0) {
                        BackData.get(player).update(class_1799.field_8037);
                    }
                }
                super.onUnequip(stack, slot, entity);
            }
        };
        for (Kind kind : Kind.values()) {
            TrinketsApi.registerTrinket((class_1792)kind.getItem(), (Trinket)trinket);
        }
        if (!Services.COMPAT.isModLoaded("elytraslot")) {
            TrinketsApi.registerTrinket((class_1792)class_1802.field_8833.method_8389(), (Trinket)trinket);
        }
    }

    public static void setBackStack(class_1799 stack, BackData backData) {
        Optional trinketComponent = TrinketsApi.getTrinketComponent((class_1309)backData.owner);
        if (trinketComponent.isEmpty()) {
            return;
        }
        Map inventory = ((TrinketComponent)trinketComponent.get()).getInventory();
        Map back = (Map)inventory.get("chest");
        if (back == null) {
            return;
        }
        TrinketInventory slots = (TrinketInventory)back.get("back");
        if (slots == null) {
            return;
        }
        slots.method_5447(0, stack);
    }

    public static class_1799 getBackStack(BackData backData, class_1799 stack) {
        Optional trinketComponent = TrinketsApi.getTrinketComponent((class_1309)backData.owner);
        if (trinketComponent.isEmpty()) {
            return stack;
        }
        Map inventory = ((TrinketComponent)trinketComponent.get()).getInventory();
        Map back = (Map)inventory.get("chest");
        if (back == null || back.isEmpty()) {
            return stack;
        }
        TrinketInventory slots = (TrinketInventory)back.get("back");
        if (slots == null) {
            return stack;
        }
        return slots.method_5438(0);
    }

    public static List<class_1799> backSlotDisabled(class_1309 entity) {
        Optional trinketComponent = TrinketsApi.getTrinketComponent((class_1309)entity);
        return trinketComponent.map(component -> component.getAllEquipped().stream().map(ref -> {
            class_1799 item = (class_1799)ref.method_15441();
            if (IConfig.elytraOrDisables(item.method_7909())) {
                return item;
            }
            return class_1799.field_8037;
        }).toList()).orElse(List.of());
    }

    public static boolean isBackSlot(class_1735 slot) {
        if (slot instanceof TrinketSlot) {
            TrinketSlot trinket = (TrinketSlot)slot;
            SlotType slotType = trinket.getType();
            boolean isChest = slotType.getGroup().equals("chest");
            boolean isBack = slotType.getName().equals("back");
            return isBack && isChest;
        }
        return false;
    }
}

