/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.config;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.config.IConfig;
import com.beansgalaxy.backpacks.config.types.BoolConfigVariant;
import com.beansgalaxy.backpacks.config.types.ConfigComment;
import com.beansgalaxy.backpacks.config.types.ConfigLabel;
import com.beansgalaxy.backpacks.config.types.ConfigLine;
import com.beansgalaxy.backpacks.config.types.HSetConfigVariant;
import com.beansgalaxy.backpacks.config.types.IntConfigVariant;
import com.beansgalaxy.backpacks.config.types.ListConfigVariant;
import com.beansgalaxy.backpacks.config.types.MapConfigVariant;
import com.beansgalaxy.backpacks.config.types.UniqueConfigVariants;
import com.beansgalaxy.backpacks.data.config.Gamerules;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_7923;

public class CommonConfig
implements IConfig {
    public IntConfigVariant leather_max_stacks;
    public IntConfigVariant ender_max_stacks;
    public IntConfigVariant winged_max_stacks;
    public IntConfigVariant metal_max_stacks;
    public IntConfigVariant pot_max_stacks;
    public IntConfigVariant cauldron_max_buckets;
    public HSetConfigVariant<class_1792> blacklist_items;
    public HSetConfigVariant<class_1792> disable_chestplate;
    public HSetConfigVariant<class_1792> disables_back_slot;
    public HSetConfigVariant<class_1792> elytra_items;
    public MapConfigVariant<String, Integer> data_driven_overrides;
    public BoolConfigVariant always_disables_back_slot;
    public ListConfigVariant<Integer> back_slot_pos;
    public MapConfigVariant<class_1792, Integer> item_weight_override;
    public int override_all_item_weights = -1;
    public boolean usesOldDataPackConfig = false;
    private final ConfigLine[] LINES;
    private final ConfigLabel GAMERULE_LABEL;
    public final HashMap<Gamerules, BoolConfigVariant> gamerules;

    public CommonConfig() {
        ConfigLine[] configLineArray = new ConfigLine[21];
        configLineArray[0] = new ConfigLabel("Maximum Stacks");
        this.leather_max_stacks = new IntConfigVariant("leather_max_stacks", 4, 1, 64);
        configLineArray[1] = this.leather_max_stacks;
        this.ender_max_stacks = new IntConfigVariant("ender_max_stacks", 4, 1, 8);
        configLineArray[2] = this.ender_max_stacks;
        this.winged_max_stacks = new IntConfigVariant("winged_max_stacks", 4, 1, 64);
        configLineArray[3] = this.winged_max_stacks;
        this.metal_max_stacks = new IntConfigVariant("metal_max_stacks", 7, 1, 64);
        configLineArray[4] = this.metal_max_stacks;
        this.pot_max_stacks = new IntConfigVariant("pot_max_stacks", 128, 0, 128);
        configLineArray[5] = this.pot_max_stacks;
        this.cauldron_max_buckets = new IntConfigVariant("cauldron_max_buckets", 24, 0, 128);
        configLineArray[6] = this.cauldron_max_buckets;
        this.data_driven_overrides = MapConfigVariant.Builder.create(String::valueOf, Integer::valueOf).example(new String[]{"gold", "netherite"}, (Integer[])new Integer[]{7, 11}).clamp(e -> class_3532.method_15340((int)e, (int)1, (int)64)).comment("If a backpack is Data-Driven, find it's 'backpack_id' with F3 + H").build("data_driven_overrides");
        configLineArray[7] = this.data_driven_overrides;
        this.item_weight_override = MapConfigVariant.Builder.create(Constants::itemShortString, decodeKey -> {
            class_2960 location = new class_2960(decodeKey);
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(location);
            return item.equals(class_1802.field_8162) ? null : item;
        }, String::valueOf, Integer::valueOf).clamp(i -> class_3532.method_15340((int)i, (int)1, (int)64)).defau(new String[]{"enchanted_book", "bundle"}, (Integer[])new Integer[]{16, 4}).example(new String[]{"all"}, (Integer[])new Integer[]{64}).validate((k, e) -> {
            if (k.equals("all")) {
                this.override_all_item_weights = e;
                return true;
            }
            return class_7923.field_41178.method_10223(new class_2960(k)) != class_1802.field_8162;
        }).comment("Stored items will act like they stack to the declared whole number").build("item_weight_override");
        configLineArray[8] = this.item_weight_override;
        configLineArray[9] = new ConfigLabel("Item Whitelists");
        configLineArray[10] = new ConfigComment("\u250c\u25b6 items can be worn on the back & not as equipment. Item does not keep functioning or rendering on the back.");
        this.disable_chestplate = UniqueConfigVariants.itemList("disable_chestplate", "");
        configLineArray[11] = this.disable_chestplate;
        configLineArray[12] = new ConfigComment("\u250c\u25b6 if any items are in armor/trinkets/curios slots then back equipment is not rendered.");
        this.disables_back_slot = UniqueConfigVariants.itemList("disables_back_slot", "create:copper_backtank, create:netherite_backtank");
        configLineArray[13] = this.disables_back_slot;
        configLineArray[14] = new ConfigComment("\u250c\u25b6 cannot be worn with Winged Backpack & other backpacks will be positioned off the player's back");
        this.elytra_items = UniqueConfigVariants.itemList("elytra_items", "elytra");
        configLineArray[15] = this.elytra_items;
        configLineArray[16] = new ConfigComment("\u250c\u25b6 cannot be stored in any backpack's inventory");
        this.blacklist_items = UniqueConfigVariants.itemList("blacklist_items", "shulker_box", "white_shulker_box, orange_shulker_box, magenta_shulker_box, light_blue_shulker_box, yellow_shulker_box, lime_shulker_box", "pink_shulker_box, gray_shulker_box, light_gray_shulker_box, cyan_shulker_box, purple_shulker_box, blue_shulker_box", "brown_shulker_box, green_shulker_box, red_shulker_box, black_shulker_box");
        configLineArray[17] = this.blacklist_items;
        configLineArray[18] = new ConfigLabel("Miscellaneous");
        this.always_disables_back_slot = new BoolConfigVariant("always_disables_back_slot", false);
        configLineArray[19] = this.always_disables_back_slot;
        this.back_slot_pos = ListConfigVariant.Builder.create(String::valueOf, JsonElement::getAsInt).defau((Integer[])new Integer[]{59, 62}).valid(in -> in.size() == 2).build("back_slot_pos");
        configLineArray[20] = this.back_slot_pos;
        this.LINES = configLineArray;
        this.GAMERULE_LABEL = new ConfigLabel("Gamerules");
        this.gamerules = Gamerules.getBoolConfig();
    }

    @Override
    public String getPath() {
        return "-common";
    }

    @Override
    public Collection<ConfigLine> getLines() {
        ArrayList<ConfigLine> lines = new ArrayList<ConfigLine>(List.of(this.LINES));
        lines.add(this.GAMERULE_LABEL);
        lines.addAll(this.gamerules.values());
        return lines;
    }

    @Override
    @Deprecated(since="0.27-v2")
    public void read() {
        HashSet<class_1792> elytraItems;
        HashSet<class_1792> disablesBackSlot;
        HashSet<class_1792> chestplateDisabled;
        HashSet<class_1792> blacklistItems = Constants.BLACKLIST_ITEMS;
        if (!blacklistItems.isEmpty()) {
            this.blacklist_items.set(blacklistItems);
            this.usesOldDataPackConfig = true;
        }
        if (!(chestplateDisabled = Constants.CHESTPLATE_DISABLED).isEmpty()) {
            this.disable_chestplate.set(chestplateDisabled);
            this.usesOldDataPackConfig = true;
        }
        if (!(disablesBackSlot = Constants.DISABLES_BACK_SLOT).isEmpty()) {
            this.disables_back_slot.set(disablesBackSlot);
            this.usesOldDataPackConfig = true;
        }
        if (!(elytraItems = Constants.ELYTRA_ITEMS).isEmpty()) {
            this.elytra_items.set(elytraItems);
            this.usesOldDataPackConfig = true;
        }
        if (this.usesOldDataPackConfig) {
            Constants.LOG.warn("The \"modify\" folder your Data-Pack is outdated");
            Constants.LOG.warn("Use config/beansbackpacks-common.json5 to modify these lists");
            Constants.LOG.warn("The Data Pack's values will be used for now but will not work in later versions");
        }
        IConfig.super.read();
    }
}

