/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.config;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.config.types.ConfigLine;
import com.beansgalaxy.backpacks.data.ServerSave;
import com.beansgalaxy.backpacks.platform.Services;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.class_1792;
import net.minecraft.class_1802;

public interface IConfig {
    public String getPath();

    public Collection<ConfigLine> getLines();

    default public void parse(String encodedConfig) {
        JsonObject jsonObject = JsonParser.parseString((String)encodedConfig).getAsJsonObject();
        Collection<ConfigLine> lines = this.getLines();
        for (ConfigLine line : lines) {
            line.decode(jsonObject);
        }
    }

    default public void read() {
        this.read(true);
    }

    default public void read(boolean andWrite) {
        try {
            Path path = Services.CONFIG.getPath();
            Path resolve = path.resolve("beansbackpacks" + this.getPath() + ".json5");
            String json5Content = new String(Files.readAllBytes(resolve));
            String jsonContent = json5Content.replaceAll("/\\*.*?\\*/", "").replaceAll("//.*", "");
            this.parse(jsonContent);
        }
        catch (IOException e) {
            Constants.LOG.warn("No Config for beansbackpacks : Created new config");
        }
        if (andWrite) {
            this.write();
        }
    }

    default public void write() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        Iterator<ConfigLine> iterator = this.getLines().iterator();
        while (iterator.hasNext()) {
            ConfigLine line = iterator.next();
            String encode = line.encode();
            if (line.punctuate()) {
                sb.append("  ");
            }
            sb.append(encode);
            int length = encode.length();
            if (line.punctuate() && iterator.hasNext()) {
                sb.append(',');
                ++length;
            }
            sb.append(line.comment(Math.max(0, 34 - length)));
            sb.append('\n');
        }
        sb.append('}');
        try {
            Path path = Services.CONFIG.getPath();
            Path resolve = path.resolve("beansbackpacks" + this.getPath() + ".json5");
            String string = sb.toString();
            Files.writeString(resolve, (CharSequence)string, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean chestplateDisabled(class_1792 item) {
        return ((HashSet)ServerSave.CONFIG.disable_chestplate.get()).contains(item);
    }

    public static boolean disablesBackSlot(class_1792 item) {
        return ((HashSet)ServerSave.CONFIG.disables_back_slot.get()).contains(item);
    }

    public static boolean blacklistedItem(class_1792 item) {
        return ((HashSet)ServerSave.CONFIG.blacklist_items.get()).contains(item);
    }

    public static boolean elytraItem(class_1792 item) {
        return ((HashSet)ServerSave.CONFIG.elytra_items.get()).contains(item);
    }

    public static boolean elytraOrDisables(class_1792 item) {
        return !item.equals(class_1802.field_8162) && (IConfig.disablesBackSlot(item) || IConfig.elytraItem(item));
    }

    public static boolean cantEquipWithBackpack(class_1792 item) {
        return !item.equals(class_1802.field_8162) && (IConfig.disablesBackSlot(item) || IConfig.chestplateDisabled(item));
    }
}

