/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.config.types;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.config.types.ConfigLine;

public abstract class ConfigVariant<T>
implements ConfigLine {
    protected final String name;
    protected final String comment;
    protected final boolean hasComment;
    private final T defau;
    protected T value;

    protected ConfigVariant(String name, T defau, String comment) {
        this.name = name;
        this.defau = defau;
        this.value = defau;
        this.comment = comment;
        this.hasComment = !Constants.isEmpty(comment);
    }

    @Override
    public String comment(int whiteSpace) {
        String autoComment = this.autoComment();
        boolean noComment = Constants.isEmpty(this.comment);
        boolean noAuto = Constants.isEmpty(autoComment);
        StringBuilder sb = new StringBuilder();
        if (!noComment || !noAuto) {
            sb.append(" ".repeat(whiteSpace));
            sb.append(" // ").append(this.comment);
            if (!noComment && !noAuto) {
                sb.append(" : ");
            }
            sb.append(autoComment);
        }
        return sb.toString();
    }

    public String autoComment() {
        return "";
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return "\"" + this.name() + "\": ";
    }

    public void set(T value) {
        this.value = value;
    }

    public T get() {
        return this.value;
    }

    public T getDefau() {
        return this.defau;
    }
}

