/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.config.types;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.config.types.ConfigVariant;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_3518;

public class HSetConfigVariant<ENTRY>
extends ConfigVariant<HashSet<ENTRY>> {
    private final Function<ENTRY, String> encode;
    private final Function<String, ENTRY> decode;
    private final Predicate<String> isValid;
    private final HashSet<String> rejects;

    private HSetConfigVariant(String name, HashSet<ENTRY> defau, HashSet<String> rejects, Predicate<String> isValid, Function<ENTRY, String> encode, Function<String, ENTRY> decode, String comment) {
        super(name, defau, comment);
        this.value = new HashSet<ENTRY>(defau);
        this.encode = encode;
        this.decode = decode;
        this.isValid = isValid;
        this.rejects = rejects;
    }

    @Override
    public String encode() {
        String entry;
        StringBuilder sb = new StringBuilder().append(this);
        sb.append('\"');
        Iterator iterator = ((HashSet)this.value).iterator();
        Iterator<String> rejected = this.rejects.iterator();
        while (rejected.hasNext()) {
            entry = rejected.next();
            sb.append(entry);
            if (!iterator.hasNext() && !rejected.hasNext()) continue;
            sb.append(", ");
        }
        while (iterator.hasNext()) {
            entry = this.encode.apply(iterator.next());
            sb.append(entry);
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('\"');
        return sb.toString();
    }

    @Override
    public void decode(JsonObject jsonObject) {
        if (!jsonObject.has(this.name)) {
            return;
        }
        ((HashSet)this.value).clear();
        this.rejects.clear();
        String string = class_3518.method_15265((JsonObject)jsonObject, (String)this.name);
        HSetConfigVariant.decode(string, this.isValid, this.decode, (HashSet)this.value, this.rejects);
    }

    private static <E> void decode(String encoded, Predicate<String> isValid, Function<String, E> decode, HashSet<E> value, HashSet<String> rejects) {
        String[] split;
        for (String entry : split = encoded.replace(" ", "").split(",")) {
            if (Constants.isEmpty(entry)) continue;
            if (isValid.test(entry)) {
                E apply = decode.apply(entry);
                value.add(apply);
                continue;
            }
            rejects.add(entry);
        }
    }

    public static class Builder<E> {
        private final Function<E, String> encode;
        private final Function<String, E> decode;
        private HashSet<E> defau = new HashSet();
        private String defauString = "";
        private Predicate<String> isValid = in -> true;
        private String comment = "";

        private Builder(Function<E, String> encode, Function<String, E> decode) {
            this.encode = encode;
            this.decode = decode;
        }

        public static <E> Builder<E> create(Function<E, String> encode, Function<String, E> decode) {
            return new Builder<E>(encode, decode);
        }

        public Builder<E> comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder<E> defau(E ... defau) {
            this.defau.addAll(Arrays.asList(defau));
            return this;
        }

        public Builder<E> defauString(String defau) {
            this.defauString = defau;
            return this;
        }

        public Builder<E> isValid(Predicate<String> validate) {
            this.isValid = validate;
            return this;
        }

        public HSetConfigVariant<E> build(String name) {
            HashSet<String> rejects = new HashSet<String>();
            HSetConfigVariant.decode(this.defauString, this.isValid, this.decode, this.defau, rejects);
            return new HSetConfigVariant<E>(name, this.defau, rejects, this.isValid, this.encode, this.decode, this.comment);
        }
    }
}

