/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.config.types;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.config.types.ConfigVariant;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_3518;

public class ListConfigVariant<ENTRY>
extends ConfigVariant<ArrayList<ENTRY>> {
    private final Function<ENTRY, String> encode;
    private final Function<JsonElement, ENTRY> decode;
    private final Predicate<ArrayList<ENTRY>> validate;

    private ListConfigVariant(String name, ArrayList<ENTRY> defau, Predicate<ArrayList<ENTRY>> validate, Function<ENTRY, String> encode, Function<JsonElement, ENTRY> decode, String comment) {
        super(name, defau, comment);
        this.value = new ArrayList<ENTRY>(defau);
        this.validate = validate;
        this.encode = encode;
        this.decode = decode;
    }

    public ENTRY get(int i) {
        return (ENTRY)((ArrayList)this.value).get(i);
    }

    @Override
    public String encode() {
        if (!this.validate.test((ArrayList)this.value)) {
            this.value = this.getDefau();
        }
        StringBuilder sb = new StringBuilder().append(this);
        sb.append('[');
        Iterator iterator = ((ArrayList)this.value).iterator();
        while (iterator.hasNext()) {
            String entry = this.encode.apply(iterator.next());
            sb.append(entry);
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void decode(JsonObject jsonObject) {
        if (!jsonObject.has(this.name)) {
            return;
        }
        ((ArrayList)this.value).clear();
        JsonArray jsonArray = class_3518.method_15261((JsonObject)jsonObject, (String)this.name);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonElement jsonElement = jsonArray.get(i);
            ((ArrayList)this.value).add(i, this.decode.apply(jsonElement));
        }
    }

    private static <E> void decode(String encoded, Predicate<String> isValid, Function<String, E> decode, HashSet<E> value, HashSet<String> rejects) {
        String[] split;
        for (String entry : split = encoded.replace(" ", "").split(",")) {
            if (Constants.isEmpty(entry)) continue;
            if (isValid.test(entry)) {
                E apply = decode.apply(entry);
                value.add(apply);
                continue;
            }
            rejects.add(entry);
        }
    }

    public static class Builder<E> {
        private final Function<E, String> encode;
        private final Function<JsonElement, E> decode;
        private ArrayList<E> defau = new ArrayList();
        private Predicate<ArrayList<E>> valid = in -> true;
        private String comment = "";

        private Builder(Function<E, String> encode, Function<JsonElement, E> decode) {
            this.encode = encode;
            this.decode = decode;
        }

        public static <E> Builder<E> create(Function<E, String> encode, Function<JsonElement, E> decode) {
            return new Builder<E>(encode, decode);
        }

        public Builder<E> comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder<E> defau(E ... defau) {
            this.defau.addAll(Arrays.asList(defau));
            return this;
        }

        public Builder<E> valid(Predicate<ArrayList<E>> valid) {
            this.valid = valid;
            return this;
        }

        public ListConfigVariant<E> build(String name) {
            return new ListConfigVariant<E>(name, this.defau, this.valid, this.encode, this.decode, this.comment);
        }
    }
}

