/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.data;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.access.BackAccessor;
import com.beansgalaxy.backpacks.config.IConfig;
import com.beansgalaxy.backpacks.data.EnderStorage;
import com.beansgalaxy.backpacks.data.ServerSave;
import com.beansgalaxy.backpacks.data.Traits;
import com.beansgalaxy.backpacks.data.config.Gamerules;
import com.beansgalaxy.backpacks.entity.EntityAbstract;
import com.beansgalaxy.backpacks.entity.Kind;
import com.beansgalaxy.backpacks.events.PlaySound;
import com.beansgalaxy.backpacks.inventory.BackpackInventory;
import com.beansgalaxy.backpacks.inventory.EnderInventory;
import com.beansgalaxy.backpacks.items.EnderBackpack;
import com.beansgalaxy.backpacks.items.Tooltip;
import com.beansgalaxy.backpacks.network.clientbound.SendBackSlot;
import com.beansgalaxy.backpacks.platform.Services;
import com.beansgalaxy.backpacks.screen.BackSlot;
import com.beansgalaxy.backpacks.screen.InSlot;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3222;
import net.minecraft.class_5151;
import net.minecraft.class_5250;

public class BackData {
    public final class_1657 owner;
    private final BackpackInventory backpackInventory = new BackpackInventory(){

        public class_1297 getOwner() {
            return BackData.this.owner;
        }

        @Override
        public class_1937 level() {
            return BackData.this.owner.method_37908();
        }

        @Override
        public Traits.LocalData getTraits() {
            return BackData.this.traits;
        }

        @Override
        public UUID getPlacedBy() {
            return BackData.this.owner.method_5667();
        }
    };
    public static final int[] UV_CREATIVE;
    public final BackSlot backSlot = new BackSlot(this);
    public final InSlot inSlot = new InSlot(this);
    private final HashSet<EnderStorage.PackagedLocation> enderLocations = new HashSet();
    private Traits.LocalData traits = Traits.LocalData.EMPTY;
    private class_1799 backStack = class_1799.field_8037;
    public boolean actionKeyDown = false;
    public boolean menusKeyDown = false;

    public void setEnderLocations(HashSet<EnderStorage.PackagedLocation> newLocations) {
        this.enderLocations.clear();
        this.enderLocations.addAll(newLocations);
    }

    public EnderStorage getEnderStorage() {
        return EnderStorage.get(this.owner.method_37908());
    }

    public HashSet<EnderStorage.PackagedLocation> getEnderLocations() {
        return new HashSet<EnderStorage.PackagedLocation>(this.enderLocations);
    }

    public BackData(class_1657 owner) {
        this.owner = owner;
    }

    public static BackData get(class_1657 player) {
        return ((BackAccessor)player.method_31548()).getBackData();
    }

    public class_1799 getStack() {
        class_1799 backSlotItem = Services.COMPAT.getBackSlotItem(this, this.backStack);
        return backSlotItem.method_7960() ? class_1799.field_8037 : backSlotItem;
    }

    public Traits.LocalData getTraits() {
        if (this.isEmpty()) {
            this.traits = Traits.LocalData.EMPTY;
        }
        return this.traits;
    }

    public boolean isEmpty() {
        return this.backStack.method_7960();
    }

    public void set(class_1799 stack) {
        if (stack == null) {
            return;
        }
        Services.COMPAT.setBackSlotItem(this, stack);
        this.backSlot.method_7673(stack);
    }

    public void update(class_1799 stack) {
        if (stack == null) {
            return;
        }
        if (stack.method_7960()) {
            this.getBackpackInventory().clearViewers();
        } else {
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof EnderBackpack) {
                EnderBackpack enderBackpack = (EnderBackpack)class_17922;
                UUID uuid = enderBackpack.getOrCreateUUID(this.owner, stack);
                this.getEnderStorage().addViewer(uuid, (class_1297)this.owner);
            }
        }
        this.backStack = stack;
        this.traits = Traits.LocalData.fromStack(stack, this.owner);
    }

    public void setChanged() {
        class_1657 class_16572 = this.owner;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            SendBackSlot.send(serverPlayer);
        }
    }

    public void playEquipSound(class_1799 stack) {
        class_1792 class_17922;
        Traits traits = Kind.getTraits(stack);
        if (this.owner.method_37908().method_8608() && !traits.isEmpty()) {
            Tooltip.playSound(traits.sound, PlaySound.EQUIP);
        }
        if ((class_17922 = stack.method_7909()) instanceof class_5151) {
            class_5151 equipable = (class_5151)class_17922;
            this.owner.method_37908().method_43128(null, this.owner.method_23317(), this.owner.method_23318(), this.owner.method_23321(), equipable.method_31570(), this.owner.method_5634(), 1.0f, 1.0f);
        }
    }

    public boolean mayEquip(class_1799 toEquip) {
        return this.mayEquip(toEquip, true, true);
    }

    public boolean mayEquip(class_1799 toEquip, boolean inMenu, boolean showMessage) {
        List<class_1799> disabling;
        Iterator iterator;
        EnderBackpack ender;
        UUID uuid;
        EnderInventory enderData;
        if (toEquip.method_7960()) {
            return true;
        }
        if (!Kind.isWearable(toEquip)) {
            return false;
        }
        class_1799 wornStack = this.getStack();
        class_5250 msg = null;
        class_1792 class_17922 = toEquip.method_7909();
        if (class_17922 instanceof EnderBackpack && (enderData = EnderStorage.getEnderData(uuid = (ender = (EnderBackpack)class_17922).getOrCreateUUID(this.owner, toEquip), this.owner.method_37908())).isLocked() && uuid != this.owner.method_5667()) {
            msg = class_2561.method_43471((String)"entity.beansbackpacks.locked.is_locked");
        }
        if (msg == null && !wornStack.method_7960() && wornStack != toEquip) {
            msg = class_2561.method_43469((String)"entity.beansbackpacks.blocked.already_equipped", (Object[])new Object[]{Constants.getName(wornStack)});
        }
        if (msg == null && Kind.isWings(toEquip) && (iterator = (disabling = this.getDisabling()).stream().filter(in -> !in.method_7960() && Kind.isWings(in)).iterator()).hasNext()) {
            class_5250 items = Constants.getName((class_1799)iterator.next());
            while (iterator.hasNext() && showMessage) {
                class_1799 equipped = (class_1799)iterator.next();
                items.method_10852((class_2561)(iterator.hasNext() ? class_2561.method_43470((String)", ") : class_2561.method_43471((String)"entity.beansbackpacks.blocked.and")));
                items.method_10852((class_2561)Constants.getName(equipped));
            }
            msg = class_2561.method_43469((String)"entity.beansbackpacks.blocked.already_equipped", (Object[])new Object[]{items}).method_27692(class_124.field_1068);
        }
        if (msg != null) {
            if (showMessage) {
                this.owner.method_7353(msg, true);
                if (this.owner.method_37908().field_9236) {
                    Tooltip.pushInventoryMessage((class_2561)msg);
                }
            }
            return false;
        }
        return true;
    }

    public boolean backSlotDisabled() {
        return (Boolean)ServerSave.CONFIG.always_disables_back_slot.get() != false || this.getDisabling().stream().anyMatch(in -> !in.method_7960() && !Kind.isWings(in));
    }

    public List<class_1799> getDisabling() {
        List<class_1799> items = Services.COMPAT.backSlotDisabled(this.owner);
        class_2371 disabling = class_2371.method_10211();
        for (class_1799 stack : this.owner.method_31548().field_7548) {
            if (stack.method_7960() || !IConfig.elytraOrDisables(stack.method_7909())) continue;
            disabling.add((Object)stack);
        }
        items.forEach(in -> {
            if (!in.method_7960()) {
                disabling.add(in);
            }
        });
        return disabling;
    }

    public void drop() {
        class_1799 backStack;
        class_1937 level = this.owner.method_37908();
        boolean isCanceled = Services.COMPAT.invokeListenersOnDeath(this);
        if (isCanceled || ServerSave.GAMERULES.get((Object)Gamerules.KEEP_BACK_SLOT).booleanValue()) {
            return;
        }
        class_2338 blockPos = this.owner.method_23312();
        float yaw = this.owner.field_6283 + 180.0f;
        int x = blockPos.method_10263();
        double y = (double)blockPos.method_10264() + 1.5;
        int z = blockPos.method_10260();
        class_2350 direction = class_2350.field_11036;
        if (Services.COMPAT.graveModLoaded()) {
            class_2350 step = class_2350.method_10150((double)yaw);
            class_2338 relative = blockPos.method_10093(step);
            y = this.owner.method_23318();
            if (BackData.canPlaceBackpackSafely(this.owner, relative)) {
                x = relative.method_10263();
                z = relative.method_10260();
                direction = step;
            } else {
                direction = class_2350.method_10150((double)(yaw + 90.0f));
            }
        }
        if (!Kind.isBackpack(backStack = this.getStack())) {
            this.owner.method_5775(backStack.method_7972());
            this.set(class_1799.field_8037);
            return;
        }
        if (!level.method_8608()) {
            class_2371 itemStacks = class_2371.method_10211();
            itemStacks.addAll(this.getBackpackInventory().getItemStacks());
            EntityAbstract.create(backStack, x, y, z, yaw, true, direction, this.owner, (class_2371<class_1799>)itemStacks);
        }
        this.set(class_1799.field_8037);
    }

    private static boolean canPlaceBackpackSafely(class_1657 player, class_2338 blockPos) {
        class_2791 chunkForCollisions;
        class_1937 level = player.method_37908();
        class_2680 blockState = level.method_8320(blockPos.method_10084());
        if (blockState.method_26234((class_1922)(chunkForCollisions = level.method_22350(blockPos)), blockPos.method_10084())) {
            return false;
        }
        class_2680 blockStateBelow = level.method_8320(blockPos);
        return blockStateBelow.method_26168((class_1922)chunkForCollisions, blockPos, (class_1297)player);
    }

    public void copyTo(BackData newBackData) {
        newBackData.set(this.backStack);
        if (this.getStack().method_7909() instanceof EnderBackpack) {
            return;
        }
        class_2371<class_1799> stacks = this.getBackpackInventory().getItemStacks();
        newBackData.getBackpackInventory().getItemStacks().addAll(stacks);
    }

    public BackpackInventory getBackpackInventory() {
        class_1792 class_17922;
        if (this.backStack != null && (class_17922 = this.backStack.method_7909()) instanceof EnderBackpack) {
            EnderBackpack enderBackpack = (EnderBackpack)class_17922;
            UUID uuid = enderBackpack.getOrCreateUUID(this.owner, this.backStack);
            return EnderStorage.getEnderData(uuid, this.owner.method_37908());
        }
        return this.backpackInventory;
    }

    static {
        int[] nArray;
        if (Constants.SLOTS_MOD_ACTIVE) {
            int[] nArray2 = new int[2];
            nArray2[0] = -2000;
            nArray = nArray2;
            nArray2[1] = -2000;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 89;
            nArray = nArray3;
            nArray3[1] = 33;
        }
        UV_CREATIVE = nArray;
    }
}

