/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.data;

import com.beansgalaxy.backpacks.client.network.CommonAtClient;
import com.beansgalaxy.backpacks.data.BackData;
import com.beansgalaxy.backpacks.data.ServerSave;
import com.beansgalaxy.backpacks.entity.EntityEnder;
import com.beansgalaxy.backpacks.inventory.BackpackInventory;
import com.beansgalaxy.backpacks.inventory.EnderInventory;
import com.beansgalaxy.backpacks.items.EnderBackpack;
import com.beansgalaxy.backpacks.network.clientbound.SendEnderPos;
import com.beansgalaxy.backpacks.network.clientbound.SendEnderStacks;
import com.beansgalaxy.backpacks.screen.BackpackMenu;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class EnderStorage {
    public final HashMap<UUID, EnderInventory> MAP = new HashMap();
    private final HashMap<UUID, HashSet<class_1297>> VIEWERS = new HashMap();

    public static EnderStorage get(class_1937 level) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            MinecraftServer server = serverLevel.method_8503();
            ServerSave save = ServerSave.getSave(server, false);
            return save.enderStorage;
        }
        return CommonAtClient.getEnderStorage();
    }

    public void addViewer(UUID owner, class_1297 viewer) {
        if (owner == null || viewer == null) {
            return;
        }
        if (viewer instanceof class_3222) {
            this.VIEWERS.computeIfAbsent(owner, uuid -> new HashSet()).add(viewer);
        } else if (viewer instanceof EntityEnder && !viewer.method_37908().method_8608()) {
            this.VIEWERS.computeIfAbsent(owner, uuid -> new HashSet()).add(viewer);
        }
    }

    public void forEachViewing(UUID owner, Consumer<class_3222> viewers) {
        this.forEachViewing(owner, viewers, backData -> viewers.accept((class_3222)backData.owner));
    }

    public void forEachViewing(UUID owner, Consumer<class_3222> viewers, Consumer<BackData> equipped) {
        if (owner == null) {
            return;
        }
        HashSet<class_1297> inventories = this.VIEWERS.get(owner);
        if (inventories == null) {
            return;
        }
        Iterator<class_1297> iterator = inventories.iterator();
        while (iterator.hasNext()) {
            EntityEnder ender;
            BackData backData;
            class_1297 viewer = iterator.next();
            if (viewer instanceof class_3222) {
                EnderBackpack item;
                UUID uuid;
                class_3222 player = (class_3222)viewer;
                backData = BackData.get((class_1657)player);
                class_1799 backStack = backData.getStack();
                class_1792 class_17922 = backStack.method_7909();
                if (!(class_17922 instanceof EnderBackpack) || !(uuid = (item = (EnderBackpack)class_17922).getOrCreateUUID(owner, viewer.method_37908(), backStack)).equals(owner)) continue;
                for (class_3222 subViewer : backData.getBackpackInventory().getPlayersViewing()) {
                    viewers.accept(subViewer);
                }
                equipped.accept(backData);
                continue;
            }
            if (viewer instanceof EntityEnder && (backData = (ender = (EntityEnder)viewer).method_37908()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)backData;
                if (!ender.method_31481()) {
                    UUID placedBy = ender.getPlacedBy();
                    if (!placedBy.equals(owner)) continue;
                    class_2371<class_3222> playersViewing = ender.getInventory().getPlayersViewing();
                    EnderStorage.getEnderData(owner, (class_1937)serverLevel).flagForUpdate((class_1937)serverLevel);
                    for (class_3222 player : playersViewing) {
                        viewers.accept(player);
                        class_1703 class_17032 = player.field_7512;
                        if (!(class_17032 instanceof BackpackMenu)) continue;
                        BackpackMenu menu = (BackpackMenu)class_17032;
                        menu.updateSlots();
                    }
                    continue;
                }
            }
            iterator.remove();
        }
        if (inventories.isEmpty()) {
            this.VIEWERS.remove(owner);
        }
    }

    public void forEachHolding(UUID owner, Consumer<class_3222> viewers, Consumer<BackData> equipped) {
        this.forEachHolding(owner, ctx -> {
            if (ctx.backData != null) {
                for (class_3222 subViewer : ctx.backData.getBackpackInventory().getPlayersViewing()) {
                    viewers.accept(subViewer);
                }
                equipped.accept(ctx.backData);
            } else if (ctx.ender != null && ctx.level != null) {
                class_2371<class_3222> playersViewing = ctx.ender.getInventory().getPlayersViewing();
                EnderStorage.getEnderData(owner, (class_1937)ctx.level).flagForUpdate((class_1937)ctx.level);
                for (class_3222 player : playersViewing) {
                    viewers.accept(player);
                    class_1703 patt5663$temp = player.field_7512;
                    if (!(patt5663$temp instanceof BackpackMenu)) continue;
                    BackpackMenu menu = (BackpackMenu)patt5663$temp;
                    menu.updateSlots();
                }
            }
        });
    }

    public void forEachHolding(UUID owner, Consumer<ViewerRecord> holders) {
        if (owner == null) {
            return;
        }
        HashSet<class_1297> inventories = this.VIEWERS.get(owner);
        if (inventories == null) {
            return;
        }
        Iterator<class_1297> iterator = inventories.iterator();
        while (iterator.hasNext()) {
            EntityEnder ender;
            BackData backData;
            class_1297 viewer = iterator.next();
            if (viewer instanceof class_3222) {
                EnderBackpack item;
                UUID uuid;
                class_3222 player = (class_3222)viewer;
                backData = BackData.get((class_1657)player);
                class_1799 backStack = backData.getStack();
                class_1792 class_17922 = backStack.method_7909();
                if (!(class_17922 instanceof EnderBackpack) || !(uuid = (item = (EnderBackpack)class_17922).getOrCreateUUID(owner, viewer.method_37908(), backStack)).equals(owner)) continue;
                holders.accept(new ViewerRecord(viewer, backData, null, null));
                continue;
            }
            if (viewer instanceof EntityEnder && (backData = (ender = (EntityEnder)viewer).method_37908()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)backData;
                if (!ender.method_31481()) {
                    UUID placedBy = ender.getPlacedBy();
                    if (!placedBy.equals(owner)) continue;
                    holders.accept(new ViewerRecord(viewer, null, ender, serverLevel));
                    continue;
                }
            }
            iterator.remove();
        }
        if (inventories.isEmpty()) {
            this.VIEWERS.remove(owner);
        }
    }

    public void syncViewers(UUID owner) {
        this.forEachViewing(owner, viewer -> SendEnderStacks.send(viewer, owner));
    }

    public void removeViewer(UUID owner, class_1297 viewer) {
        HashSet<class_1297> inventories = this.VIEWERS.get(owner);
        if (inventories == null) {
            return;
        }
        inventories.remove(viewer);
    }

    public static EnderInventory getEnderData(class_1657 player) {
        return EnderStorage.getEnderData(player.method_5667(), player.method_37908());
    }

    public static EnderInventory getEnderData(UUID uuid, class_1937 level) {
        EnderInventory enderData = EnderStorage.get((class_1937)level).MAP.computeIfAbsent(uuid, uuid1 -> new EnderInventory(uuid, level));
        class_1657 player = level.method_18470(uuid);
        if (player != null) {
            enderData.setPlayerName((class_2561)player.method_5477().method_27661());
        }
        return enderData;
    }

    public void toNBT(@NotNull class_2487 tag) {
        class_2487 enderTag = new class_2487();
        this.MAP.forEach((uuid, enderData) -> {
            if (uuid != null) {
                class_2487 data = new class_2487();
                BackpackInventory.writeNbt(data, enderData.getItemStacks());
                data.method_10566("Trim", (class_2520)enderData.getTrim());
                data.method_10582("player_name", class_2561.class_2562.method_10867((class_2561)enderData.getPlayerName()));
                class_2487 locations = new class_2487();
                for (UUID backpack : enderData.locations.keySet()) {
                    class_2487 location = new class_2487();
                    enderData.locations.get(backpack).toNBT(location);
                    locations.method_10566(backpack.toString(), (class_2520)location);
                }
                data.method_10566("locations", (class_2520)locations);
                enderTag.method_10566(uuid.toString(), (class_2520)data);
            }
        });
        tag.method_10566("EnderData", (class_2520)enderTag);
    }

    public void fromNbt(class_2487 tag, class_3218 level) {
        if (tag.method_10545("EnderData")) {
            class_2487 entries = tag.method_10562("EnderData");
            for (String key : entries.method_10541()) {
                class_2487 dataTags = entries.method_10562(key);
                class_2371 itemStacks = class_2371.method_10211();
                BackpackInventory.readStackNbt(dataTags, (class_2371<class_1799>)itemStacks);
                class_2487 trim = dataTags.method_10562("Trim");
                class_5250 playerName = class_2561.class_2562.method_10877((String)dataTags.method_10558("player_name"));
                UUID uuid = UUID.fromString(key);
                EnderInventory enderData = new EnderInventory(uuid, (class_1937)level);
                enderData.setItemStacks((class_2371<class_1799>)itemStacks).setTrim(trim).setPlayerName((class_2561)playerName);
                class_2487 locations = dataTags.method_10562("locations");
                for (String backpack : locations.method_10541()) {
                    Location location = new Location(locations.method_10562(backpack));
                    enderData.locations.put(UUID.fromString(backpack), location);
                }
                this.MAP.put(uuid, enderData);
            }
            this.MAP.remove(null);
        }
    }

    public record ViewerRecord(class_1297 entity, BackData backData, EntityEnder ender, class_3218 level) {
    }

    public static class Location {
        public final class_2338 location;
        private final class_5321<class_1937> dimension;

        public Location(class_2338 location, class_5321<class_1937> dimension) {
            this.location = location;
            this.dimension = dimension;
        }

        public static void update(UUID uuid, class_3218 serverLevel) {
            class_3222 owner = (class_3222)serverLevel.method_18470(uuid);
            if (owner == null) {
                return;
            }
            BackData backData = BackData.get((class_1657)owner);
            backData.setEnderLocations(Location.asPackaged(owner.method_5667(), serverLevel));
            SendEnderPos.send(owner, backData);
        }

        public static HashSet<PackagedLocation> asPackaged(UUID owner, class_3218 level) {
            EnderInventory enderData = EnderStorage.getEnderData(owner, (class_1937)level);
            HashSet<PackagedLocation> locations = new HashSet<PackagedLocation>();
            for (UUID backpack : enderData.locations.keySet()) {
                Location location = enderData.locations.get(backpack);
                class_5321<class_1937> dimension = location.dimension;
                class_2338 blockPos = location.location;
                if (level == null) {
                    locations.add(new PackagedLocation(false, blockPos, dimension));
                    continue;
                }
                class_1297 entity = level.method_14190(backpack);
                if (entity == null) {
                    locations.add(new PackagedLocation(false, blockPos, dimension));
                    continue;
                }
                if (entity.method_31481()) {
                    enderData.locations.remove(backpack);
                    continue;
                }
                class_2338 newBlockPos = entity.method_24515();
                enderData.locations.put(backpack, new Location(newBlockPos, dimension));
                locations.add(new PackagedLocation(true, newBlockPos, dimension));
            }
            return locations;
        }

        public void toNBT(class_2487 tag) {
            int[] pos = new int[]{this.location.method_10263(), this.location.method_10264(), this.location.method_10260()};
            tag.method_10539("BlockPos", pos);
            class_2960 dimension = this.dimension.method_29177();
            tag.method_10582("namespace", dimension.method_12836());
            tag.method_10582("path", dimension.method_12832());
        }

        public Location(class_2487 tag) {
            int[] pos = tag.method_10561("BlockPos");
            this.location = new class_2338(pos[0], pos[1], pos[2]);
            class_2960 r = new class_2960(tag.method_10558("namespace"), tag.method_10558("path"));
            this.dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)r);
        }
    }

    public static class PackagedLocation {
        private final boolean isAccurate;
        private final class_2338 location;
        private final class_2960 dimension;

        public PackagedLocation(boolean accurate, class_2338 location, class_5321<class_1937> dimension) {
            this.isAccurate = accurate;
            this.location = location;
            this.dimension = dimension.method_29177();
        }

        public class_5250 toComponent() {
            class_5250 literal = class_2561.method_43470((String)"");
            int x = this.location.method_10263();
            PackagedLocation.formatCord(x, literal);
            literal.method_27693(", ");
            int y = this.location.method_10264();
            PackagedLocation.formatCord(y, literal);
            literal.method_27693(", ");
            int z = this.location.method_10260();
            PackagedLocation.formatCord(z, literal);
            literal.method_27693(" " + this.dimension.method_43903());
            class_124 color = this.isAccurate ? class_124.field_1060 : class_124.field_1054;
            return literal.method_27692(color);
        }

        private static void formatCord(int cord, class_5250 literal) {
            String number = String.valueOf(cord);
            for (int length = number.length(); length < 3; ++length) {
                literal.method_27693(" ");
            }
            literal.method_27693(number);
        }

        public void writeBuf(class_2540 buf) {
            buf.writeBoolean(this.isAccurate);
            buf.method_10807(this.location);
            buf.method_10812(this.dimension);
        }

        public PackagedLocation(class_2540 buf) {
            this.isAccurate = buf.readBoolean();
            this.location = buf.method_10811();
            this.dimension = buf.method_10810();
        }
    }
}

