/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.data;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.config.CommonConfig;
import com.beansgalaxy.backpacks.data.EnderStorage;
import com.beansgalaxy.backpacks.data.config.Gamerules;
import com.beansgalaxy.backpacks.events.advancements.SpecialCriterion;
import com.beansgalaxy.backpacks.platform.Services;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Scanner;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class ServerSave
extends class_18 {
    public static final CommonConfig CONFIG = new CommonConfig();
    public static final HashMap<Gamerules, Boolean> GAMERULES = Gamerules.mapConfig(CONFIG);
    public final EnderStorage enderStorage = new EnderStorage();
    public final HashSet<UUID> heldLockedAdvancement = new HashSet();
    public final HashSet<GameProfile> superSpecialPlayers = new HashSet();

    @NotNull
    public class_2487 method_75(@NotNull class_2487 tag) {
        this.enderStorage.toNBT(tag);
        Gamerules.toNBT(tag, GAMERULES, CONFIG);
        tag.method_10582("LockedAdvancement", this.lockedAdvancementToString());
        return tag;
    }

    @NotNull
    private String lockedAdvancementToString() {
        StringBuilder sb = new StringBuilder();
        Iterator<UUID> iterator = this.heldLockedAdvancement.iterator();
        while (iterator.hasNext()) {
            UUID next = iterator.next();
            sb.append(next.toString());
            if (!iterator.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static ServerSave createFromNbt(class_2487 tag, class_3218 level) {
        ServerSave save = new ServerSave();
        CONFIG.read();
        save.enderStorage.fromNbt(tag, level);
        GAMERULES.clear();
        GAMERULES.putAll(Gamerules.fromNBT(tag, CONFIG));
        ServerSave.decodeLockedAdvancement(tag, save);
        save.loadSuperSpecialPlayers();
        return save;
    }

    private static void decodeLockedAdvancement(class_2487 tag, ServerSave save) {
        String[] split;
        String string = tag.method_10558("LockedAdvancement");
        for (String uuid : split = string.split(",")) {
            if (Constants.isEmpty(uuid)) continue;
            save.heldLockedAdvancement.add(UUID.fromString(uuid));
        }
    }

    public static ServerSave getSave(MinecraftServer server, boolean updateSave) {
        class_3218 level = server.method_3847(class_1937.field_25179);
        class_26 dataStorage = level.method_17983();
        ServerSave save = (ServerSave)dataStorage.method_17924(nbt -> ServerSave.createFromNbt(nbt, level), ServerSave::new, "beansbackpacks");
        if (updateSave) {
            save.method_80();
        }
        return save;
    }

    public void grantLockedAchievement(MinecraftServer server, UUID uuid) {
        class_3222 player = server.method_3760().method_14602(uuid);
        if (player == null) {
            this.heldLockedAdvancement.add(uuid);
            this.method_80();
        } else {
            Services.REGISTRY.triggerSpecial(player, SpecialCriterion.Special.LOCKED);
        }
    }

    public void loadSuperSpecialPlayers() {
        try {
            URL url = new URL("https://raw.githubusercontent.com/BeansGalaxy/Beans-Backpacks-2/common/super_special_players.txt");
            Scanner scanner = new Scanner(url.openStream());
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (Constants.isEmpty(line)) continue;
                String[] split = line.split(":");
                UUID uuid = UUID.fromString(split[1]);
                GameProfile e = new GameProfile(uuid, split[0]);
                this.superSpecialPlayers.add(e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isSuperSpecial(class_1657 player) {
        GameProfile gameProfile = player.method_7334();
        for (GameProfile specialPlayer : this.superSpecialPlayers) {
            if (!gameProfile.equals((Object)specialPlayer)) continue;
            return true;
        }
        return false;
    }
}

