/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.data;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.data.EnderStorage;
import com.beansgalaxy.backpacks.data.ServerSave;
import com.beansgalaxy.backpacks.entity.Kind;
import com.beansgalaxy.backpacks.items.DyableBackpack;
import java.awt.Color;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class Traits {
    public static final Traits EMPTY = new Traits("Err", true, "none", null, 0, "clay");
    public static final Traits LEATHER;
    public static final Traits METAL;
    public static final Traits ENDER;
    public static final Traits WINGED;
    public static final Traits POT;
    public static final Traits CAULDRON;
    public static final Traits BIG_BUNDLE;
    public static final Function<Integer, Color> IGNORE_COLOR;
    public final String name;
    private final Supplier<Integer> maxStacks;
    public final boolean fireResistant;
    public final String button;
    public final class_1741 material;
    public final Sound sound;

    public Traits(String name, boolean fireResistant, String button, String material, int maxStacks, String sound) {
        this(name, fireResistant, button, material, Traits.getOverrideableMaxStack(name, maxStacks), Sound.from(sound));
    }

    public Traits(String name, boolean fireResistant, String button, String material, Supplier<Integer> maxStacks, Sound sound) {
        this.name = name;
        this.maxStacks = maxStacks;
        this.fireResistant = fireResistant;
        this.button = button;
        this.material = Traits.getMaterial(material);
        this.sound = sound;
    }

    public Traits(String key, class_2487 tag) {
        this.name = tag.method_10558("name");
        this.sound = Sound.valueOf(tag.method_10558("sound"));
        this.maxStacks = Traits.getOverrideableMaxStack(key, tag.method_10550("max_stacks"));
        this.fireResistant = tag.method_10577("fire_resistant");
        this.button = tag.method_10558("button");
        this.material = Traits.getMaterial(tag.method_10558("material"));
    }

    public static Supplier<Integer> getOverrideableMaxStack(String backpack_id, int max_stacks) {
        return () -> {
            HashMap map = (HashMap)ServerSave.CONFIG.data_driven_overrides.get();
            return map.getOrDefault(backpack_id, max_stacks);
        };
    }

    public int getMaxStacks() {
        return this.maxStacks.get();
    }

    static class_1740 getMaterial(String key) {
        if (Constants.isEmpty(key)) {
            return class_1740.field_7897;
        }
        for (class_1740 armorMaterial : class_1740.values()) {
            String armor = armorMaterial.method_7694();
            if (!armor.equals(key)) continue;
            return armorMaterial;
        }
        return class_1740.field_7897;
    }

    public static void clear() {
        Constants.TRAITS_MAP.clear();
    }

    public class_2487 toTag() {
        class_2487 data = new class_2487();
        data.method_10582("name", this.name);
        data.method_10569("max_stacks", this.maxStacks.get().intValue());
        data.method_10556("fire_resistant", this.fireResistant);
        data.method_10582("button", this.button);
        data.method_10582("material", this.material.method_7694());
        data.method_10582("sound", this.sound.name());
        return data;
    }

    public static void register(String key, Traits traits) {
        if (Constants.isEmpty(key)) {
            return;
        }
        Constants.TRAITS_MAP.put(key, traits);
    }

    public static Traits get(String key) {
        Traits metal = METAL;
        if (Constants.isEmpty(key)) {
            return metal;
        }
        Traits traits = Constants.TRAITS_MAP.get(key);
        if (traits != null) {
            return traits;
        }
        return metal;
    }

    public static class_2561 getName(LocalData traits) {
        String key = traits.backpack_id;
        if (Constants.isEmpty(key)) {
            return class_2561.method_48321((String)"item.beansbackpacks.metal_backpack", (String)"Iron Backpack");
        }
        return class_2561.method_48321((String)("tooltip.beansbackpacks.name." + key), (String)traits.name());
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public static class_1799 toStack(String backpackID) {
        class_1799 stack = Kind.METAL.getItem().method_7854();
        stack.method_7948().method_10582("backpack_id", backpackID);
        return stack;
    }

    static {
        IGNORE_COLOR = i -> new Color(0xFFFFFF);
        LEATHER = new Traits("Backpack", false, "minecraft:gold", "leather", ServerSave.CONFIG.leather_max_stacks::get, Sound.SOFT);
        METAL = new Traits("Iron Backpack", false, "minecraft:diamond", "iron", ServerSave.CONFIG.metal_max_stacks::get, Sound.HARD);
        ENDER = new Traits("Ender Backpack", false, "none", "turtle", ServerSave.CONFIG.ender_max_stacks::get, Sound.VWOOMP);
        WINGED = new Traits("Winged Backpack", false, "minecraft:gold", "leather", ServerSave.CONFIG.winged_max_stacks::get, Sound.CRUNCH);
        POT = new Traits("Decorated Pot", false, "none", null, ServerSave.CONFIG.pot_max_stacks::get, Sound.CLAY);
        CAULDRON = new Traits("Cauldron", false, "none", null, ServerSave.CONFIG.cauldron_max_buckets::get, Sound.HARD);
        BIG_BUNDLE = new Traits("Big Bundle", false, "minecraft:emerald", "leather", () -> class_3532.method_15386((float)((float)((Integer)ServerSave.CONFIG.leather_max_stacks.get() + (Integer)ServerSave.CONFIG.metal_max_stacks.get()) / 2.0f)), Sound.SOFT);
    }

    public static enum Sound {
        SOFT,
        HARD,
        VWOOMP,
        CRUNCH,
        CLAY;


        public static Sound from(String sound) {
            try {
                return Sound.valueOf(sound.toUpperCase());
            }
            catch (IllegalArgumentException ignored) {
                return HARD;
            }
        }
    }

    public static class LocalData {
        public static final LocalData EMPTY = new LocalData();
        public static final LocalData POT = new LocalData(Kind.POT);
        public static final LocalData CAULDRON = new LocalData(Kind.CAULDRON);
        private boolean isEmpty;
        public final Kind kind;
        public final String backpack_id;
        public int color = 0xFFFFFF;
        private class_2487 trim = new class_2487();
        public class_2561 hoverName = class_2561.method_43473();

        public LocalData(String backpack_id, Kind kind, int color, class_2487 trim, class_2561 hoverName) {
            this.backpack_id = backpack_id == null ? "" : backpack_id;
            this.kind = kind;
            this.color = color;
            this.trim = trim == null ? new class_2487() : trim;
            this.hoverName = hoverName == null ? class_2561.method_43473() : hoverName;
        }

        private LocalData(Kind kind) {
            this.backpack_id = "";
            this.kind = kind;
        }

        public LocalData(class_2487 tag) {
            String kindString = tag.method_10558("kind");
            this.kind = Kind.fromName(kindString);
            this.backpack_id = tag.method_10558("backpack_id");
            if (tag.method_10545("empty") && tag.method_10577("empty")) {
                this.isEmpty = true;
            } else {
                this.color = tag.method_10550("color");
                this.trim = tag.method_10562("Trim");
                this.hoverName = class_2561.class_2562.method_10877((String)tag.method_10558("name"));
            }
        }

        public LocalData() {
            this.backpack_id = "";
            this.kind = Kind.METAL;
            this.isEmpty = true;
        }

        public class_2487 toNBT() {
            class_2487 data = new class_2487();
            data.method_10582("kind", this.kind.name());
            data.method_10582("backpack_id", this.backpack_id);
            if (this.isEmpty()) {
                data.method_10556("empty", true);
            } else {
                data.method_10569("color", this.color);
                data.method_10566("Trim", (class_2520)this.getTrim());
                data.method_10582("name", class_2561.class_2562.method_10867((class_2561)this.hoverName));
            }
            return data;
        }

        public class_2487 getTrim() {
            return this.trim;
        }

        public static LocalData fromStack(class_1799 stack, class_1657 player) {
            return LocalData.fromStack(stack, player.method_37908(), player.method_5667());
        }

        public static LocalData fromStack(class_1799 stack, final class_1937 level, UUID fallback) {
            Kind kind = Kind.fromStack(stack);
            if (kind == null) {
                return EMPTY;
            }
            class_5250 hoverName = stack.method_7938() ? stack.method_7964() : class_2561.method_43473();
            switch (kind) {
                case METAL: {
                    class_2487 tag = stack.method_7969();
                    class_2487 trim = stack.method_7941("Trim");
                    if (tag == null || !tag.method_10545("backpack_id")) {
                        return new LocalData("", Kind.METAL, 0xFFFFFF, trim, (class_2561)hoverName);
                    }
                    String key = tag.method_10558("backpack_id");
                    return new LocalData(key, Kind.METAL, 0xFFFFFF, trim, (class_2561)hoverName);
                }
                case LEATHER: {
                    int n;
                    class_1792 key = stack.method_7909();
                    if (key instanceof class_1768) {
                        class_1768 dyable = (class_1768)key;
                        n = dyable.method_7800(stack);
                    } else {
                        n = 0xFFFFFF;
                    }
                    int itemColor = n;
                    return new LocalData("", Kind.LEATHER, itemColor, null, (class_2561)hoverName);
                }
                case WINGED: {
                    int n;
                    class_1792 key = stack.method_7909();
                    if (key instanceof class_1768) {
                        class_1768 dyable = (class_1768)key;
                        n = dyable.method_7800(stack);
                    } else {
                        n = 0xFFFFFF;
                    }
                    int itemColor = n;
                    return new LocalData("", Kind.WINGED, itemColor, null, (class_2561)hoverName);
                }
                case ENDER: {
                    class_2487 tag = stack.method_7969();
                    final UUID uuid = tag != null && tag.method_10545("owner") ? tag.method_25926("owner") : fallback;
                    return new LocalData("", Kind.ENDER, 0xFFFFFF, null, (class_2561)hoverName){

                        @Override
                        public class_2487 getTrim() {
                            return EnderStorage.getEnderData(uuid, level).getTrim();
                        }
                    };
                }
                case CAULDRON: {
                    return CAULDRON;
                }
                case POT: {
                    return POT;
                }
                case BIG_BUNDLE: {
                    int n;
                    class_2487 trim = stack.method_7941("Trim");
                    class_1792 class_17922 = stack.method_7909();
                    if (class_17922 instanceof DyableBackpack) {
                        DyableBackpack dyable = (DyableBackpack)class_17922;
                        n = dyable.getBundleColor(stack);
                    } else {
                        n = 0xFFFFFF;
                    }
                    int itemColor = n;
                    return new LocalData("", Kind.BIG_BUNDLE, itemColor, trim, (class_2561)hoverName);
                }
            }
            return EMPTY;
        }

        public Traits traits() {
            return this.kind.traits(this.backpack_id);
        }

        public String name() {
            return this.traits().name;
        }

        public int maxStacks() {
            return this.traits().getMaxStacks();
        }

        public boolean fireResistant() {
            return this.traits().fireResistant;
        }

        public String button() {
            return this.traits().button;
        }

        public boolean isEmpty() {
            return this == EMPTY || this.isEmpty;
        }

        public boolean isStorage() {
            return !this.isEmpty && this.maxStacks() > 0;
        }

        public class_1741 material() {
            return this.traits().material;
        }

        public Sound sound() {
            return this.traits().sound;
        }
    }
}

