/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.entity;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.data.BackData;
import com.beansgalaxy.backpacks.data.EnderStorage;
import com.beansgalaxy.backpacks.data.ServerSave;
import com.beansgalaxy.backpacks.data.Traits;
import com.beansgalaxy.backpacks.data.Viewable;
import com.beansgalaxy.backpacks.data.config.Gamerules;
import com.beansgalaxy.backpacks.entity.Backpack;
import com.beansgalaxy.backpacks.entity.EntityEnder;
import com.beansgalaxy.backpacks.entity.EntityFlight;
import com.beansgalaxy.backpacks.entity.EntityGeneral;
import com.beansgalaxy.backpacks.entity.Kind;
import com.beansgalaxy.backpacks.events.PlaySound;
import com.beansgalaxy.backpacks.events.advancements.SpecialCriterion;
import com.beansgalaxy.backpacks.inventory.BackpackInventory;
import com.beansgalaxy.backpacks.items.BackpackItem;
import com.beansgalaxy.backpacks.items.DyableBackpack;
import com.beansgalaxy.backpacks.items.EnderBackpack;
import com.beansgalaxy.backpacks.items.WingedBackpack;
import com.beansgalaxy.backpacks.network.clientbound.SendBackInventory;
import com.beansgalaxy.backpacks.network.clientbound.SendEnderStacks;
import com.beansgalaxy.backpacks.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2359;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5712;
import net.minecraft.class_7923;
import net.minecraft.class_8111;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityAbstract
extends Backpack {
    public static final class_2940<Boolean> LOCKED = class_2945.method_12791(EntityAbstract.class, (class_2941)class_2943.field_13323);
    public static final class_2941<List<class_1799>> ITEM_STACK_LIST = new class_2941<List<class_1799>>(){

        public void write(class_2540 buf, List<class_1799> list) {
            int size = list.size();
            buf.writeInt(size);
            for (int i = 0; i < size; ++i) {
                class_1799 itemStack = list.get(i);
                if (itemStack.method_7960()) {
                    buf.writeBoolean(false);
                    continue;
                }
                buf.writeBoolean(true);
                class_1792 $$1 = itemStack.method_7909();
                buf.method_42065((class_2359)class_7923.field_41178, (Object)$$1);
                buf.writeInt(itemStack.method_7947());
                class_2487 $$2 = null;
                if ($$1.method_7846() || $$1.method_7887()) {
                    $$2 = itemStack.method_7969();
                }
                buf.method_10794($$2);
            }
        }

        public List<class_1799> read(class_2540 buf) {
            int size = buf.readInt();
            ArrayList<class_1799> list = new ArrayList<class_1799>();
            for (int i = 0; i < size; ++i) {
                class_1799 itemStack;
                if (!buf.readBoolean()) {
                    itemStack = class_1799.field_8037;
                } else {
                    class_1792 $$0 = (class_1792)buf.method_42064((class_2359)class_7923.field_41178);
                    int $$1 = buf.readInt();
                    class_1799 $$2 = new class_1799((class_1935)$$0, $$1);
                    $$2.method_7980(buf.method_10798());
                    itemStack = $$2;
                }
                list.add(itemStack);
            }
            return list;
        }

        public List<class_1799> copy(List<class_1799> $$0) {
            return $$0.stream().toList();
        }
    };
    public static final class_2940<List<class_1799>> STACKS = class_2945.method_12791(EntityAbstract.class, ITEM_STACK_LIST);
    public class_2350 direction;
    protected class_2338 pos;
    private double actualY;
    private static final int BREAK_TIMER = 25;
    public int wobble = 12;
    public int breakAmount = 0;
    private class_2487 itemTags;

    public EntityAbstract(class_1299<? extends class_1297> type, class_1937 level) {
        super(type, level);
        this.field_23807 = true;
    }

    public EntityAbstract(class_1299<? extends class_1297> type, class_1937 level, int x, double y, int z) {
        super(type, level);
        this.field_23807 = true;
        this.actualY = y;
        this.pos = class_2338.method_49637((double)x, (double)y, (double)z);
    }

    public boolean method_5640(double $$0) {
        double $$1 = this.method_5829().method_995();
        if (Double.isNaN($$1)) {
            $$1 = 1.0;
        }
        return $$0 < ($$1 *= 128.0 * EntityAbstract.method_5824()) * $$1;
    }

    @Nullable
    public static EntityAbstract create(class_1799 backpackStack, int x, double y, int z, float yaw, boolean onDeath, class_2350 direction, class_1657 player, class_2371<class_1799> stacks) {
        Traits.LocalData traits = Traits.LocalData.fromStack(backpackStack, player);
        EntityAbstract entityAbstract = EntityAbstract.create(backpackStack, x, y, z, yaw, onDeath, direction, player.method_37908(), player.method_5667(), stacks);
        if (entityAbstract != null && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            Services.REGISTRY.triggerPlace(serverPlayer, traits.backpack_id);
            player.method_37908().method_43275((class_1297)player, class_5712.field_28738, entityAbstract.method_19538());
        }
        return entityAbstract;
    }

    @Nullable
    public static EntityAbstract create(class_1799 backpackStack, int x, double y, int z, float yaw, boolean onDeath, class_2350 direction, class_1937 level, UUID uuid, class_2371<class_1799> stacks) {
        EntityAbstract backpack;
        Traits.LocalData traits = Traits.LocalData.fromStack(backpackStack, level, uuid);
        if (traits == null) {
            return null;
        }
        boolean empty = traits.isEmpty();
        if (empty) {
            return null;
        }
        Optional<UUID> placedBy = Optional.of(uuid);
        class_1792 class_17922 = backpackStack.method_7909();
        if (class_17922 instanceof EnderBackpack) {
            EnderBackpack ender = (EnderBackpack)class_17922;
            placedBy = onDeath && !ender.isPersistent(backpackStack) && ServerSave.GAMERULES.get((Object)Gamerules.UNBIND_ENDER_ON_DEATH) != false ? Optional.empty() : Optional.of(ender.getOrCreateUUID(uuid, level, backpackStack));
            backpack = new EntityEnder(level);
        } else if (backpackStack.method_7909() instanceof WingedBackpack) {
            int damage = backpackStack.method_7919();
            backpack = new EntityFlight(level, stacks, damage);
        } else {
            backpack = new EntityGeneral(level, stacks);
        }
        backpack.setPlacedBy(placedBy);
        backpack.actualY = y;
        backpack.pos = class_2338.method_49637((double)x, (double)y, (double)z);
        backpack.setDirection(direction);
        backpack.field_6011.method_12778(LOCAL_DATA, (Object)traits.toNBT());
        backpack.saveToItemTag(backpackStack.method_7969());
        if (!traits.kind.is(Kind.ENDER)) {
            backpack.field_6011.method_12778(STACKS, stacks);
        }
        class_2561 hoverName = backpackStack.method_7938() ? backpackStack.method_7964() : null;
        backpack.method_5665(hoverName);
        boolean isHorizontal = direction.method_10166().method_10179();
        if (!isHorizontal) {
            backpack.method_36456(yaw);
        }
        PlaySound.PLACE.at(backpack, traits.sound());
        if (!level.field_9236) {
            level.method_8649((class_1297)backpack);
        }
        if (isHorizontal) {
            level.method_8455(backpack.pos, class_2246.field_10124);
        }
        backpackStack.method_7934(1);
        return backpack;
    }

    public void setPlacedBy(Optional<UUID> placedBy) {
        placedBy.ifPresent(in -> this.field_6011.method_12778(OWNER, (Object)placedBy));
    }

    @Override
    public Viewable getViewable() {
        return this.getInventory().getViewable();
    }

    private void saveToItemTag(@Nullable class_2487 tag) {
        if (tag == null) {
            return;
        }
        class_2487 copy = tag.method_10553();
        if (copy.method_10545("Locked")) {
            this.field_6011.method_12778(LOCKED, (Object)copy.method_10577("Locked"));
            copy.method_10551("Locked");
        }
        copy.method_10551("backpack_id");
        copy.method_10551("Trim");
        if (copy.method_10545("display")) {
            class_2487 display = copy.method_10562("display");
            display.method_10551("color");
            if (display.method_33133()) {
                copy.method_10551("display");
            }
        }
        this.itemTags = copy;
    }

    @Override
    protected void method_5693() {
        this.field_6011.method_12784(LOCKED, (Object)false);
        this.field_6011.method_12784(STACKS, List.of());
        super.method_5693();
    }

    public List<class_1799> getEntityDataItemStacks() {
        return (List)this.field_6011.method_12789(STACKS);
    }

    /*
     * Unable to fully structure code
     */
    public class_1799 toStack() {
        traits = this.getTraits();
        kind = traits.kind;
        item = kind.getItem();
        stack = item.method_7854();
        itemTags = this.itemTags;
        if (itemTags != null) {
            stack.method_7980(itemTags);
        }
        if (locked = this.isLocked()) {
            stack.method_7948().method_10556("Locked", true);
        }
        placedBy = this.getPlacedBy();
        if (!(item instanceof EnderBackpack)) ** GOTO lbl-1000
        enderBackpack = (EnderBackpack)item;
        if (placedBy != null) {
            if (!this.isLocked()) {
                EnderStorage.getEnderData(placedBy, this.method_37908());
                enderBackpack.setUUID(placedBy, stack);
            }
        } else if (!(trim = traits.getTrim()).method_33133()) {
            stack.method_7959("Trim", (class_2520)trim);
        }
        color = traits.color;
        hasDefaultColor = false;
        switch (2.$SwitchMap$com$beansgalaxy$backpacks$entity$Kind[kind.ordinal()]) {
            case 1: {
                key = traits.backpack_id;
                if (Constants.isEmpty(key)) break;
                stack.method_7948().method_10582("backpack_id", key);
                break;
            }
            case 2: {
                hasDefaultColor = color == 9062433;
                break;
            }
            case 3: {
                hasDefaultColor = color == 8359839;
                break;
            }
            case 4: {
                v0 = hasDefaultColor = color == -4231620;
            }
        }
        if (!hasDefaultColor && stack.method_7909() instanceof DyableBackpack) {
            stack.method_7911("display").method_10569("color", color);
        }
        if ((customName = this.method_5797()) != null) {
            stack.method_7977(customName);
        } else {
            stack.method_7925();
        }
        return stack;
    }

    public abstract BackpackInventory getInventory();

    public class_2371<class_1799> getItemStacks() {
        return this.getInventory().getItemStacks();
    }

    public class_2561 method_5477() {
        Traits.LocalData traits = this.getTraits();
        return traits.kind.getName(traits);
    }

    public class_2561 method_5476() {
        class_2561 customName = this.method_5797() == null ? this.method_5477() : this.method_5797();
        return class_268.method_1142((class_270)this.method_5781(), (class_2561)customName).method_27694($$0 -> $$0.method_10949(this.method_5769()).method_10975(this.method_5845()));
    }

    public float method_51152() {
        return this.method_24828() || this.direction.method_10166().method_10178() ? 0.8125f : 0.1875f;
    }

    protected float method_18378(@NotNull class_4050 p_31784_, @NotNull class_4048 p_31785_) {
        return 0.375f;
    }

    @Override
    @NotNull
    public class_2350 method_5735() {
        return this.direction;
    }

    protected void setDirection(class_2350 direction) {
        if (direction != null) {
            this.direction = direction;
            if (direction.method_10166().method_10179()) {
                this.method_5875(true);
                this.method_36456((float)direction.method_10161() * 90.0f);
            }
            this.field_6004 = this.method_36455();
            this.field_5982 = this.method_36454();
            this.recalculateBoundingBox();
        }
    }

    public void method_5814(double x, double y, double z) {
        this.actualY = y;
        this.pos = class_2338.method_49637((double)x, (double)y, (double)z);
        this.recalculateBoundingBox();
        this.field_6007 = true;
    }

    public static class_238 newBox(class_2338 blockPos, double y, double height, class_2350 direction) {
        double x1 = (double)blockPos.method_10263() + 0.5;
        double z1 = (double)blockPos.method_10260() + 0.5;
        double Wx = 0.25;
        double Wz = 0.25;
        if (direction != null) {
            if (direction.method_10166().method_10179()) {
                double D = 0.125;
                double off = 0.375;
                int stepX = direction.method_10148();
                int stepZ = direction.method_10165();
                Wx -= D * (double)Math.abs(stepX);
                Wz -= D * (double)Math.abs(stepZ);
                x1 -= off * (double)stepX;
                z1 -= off * (double)stepZ;
            } else {
                Wx -= 0.0625;
                Wz -= 0.0625;
            }
        }
        return new class_238(x1 - Wx, y, z1 - Wz, x1 + Wx, y + height, z1 + Wz);
    }

    protected void recalculateBoundingBox() {
        class_238 box = EntityAbstract.newBox(this.pos, this.actualY, 0.5625, this.direction);
        this.method_23327((box.field_1323 + box.field_1320) / 2.0, box.field_1322, (box.field_1321 + box.field_1324) / 2.0);
        this.method_5857(box);
    }

    public void method_5773() {
        super.method_5773();
        this.updateGravity();
        this.wobble();
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.method_5670();
    }

    private void wobble() {
        if (this.wobble > 0) {
            --this.wobble;
        } else {
            this.breakAmount = 0;
        }
    }

    public void method_20803(int i) {
        int fireTicks = this.method_37908().field_9236 ? i : Math.min(i, 30);
        super.method_20803(fireTicks);
    }

    private void updateGravity() {
        this.method_5875(this.method_5740() && !this.method_37908().method_8587((class_1297)this, this.method_5829().method_1009(0.1, -0.1, 0.1)));
        boolean inLava = this.method_5771();
        if (!this.method_5740()) {
            if (this.method_5799()) {
                this.inWaterGravity();
            } else if (inLava) {
                if (this.getTraits().fireResistant() && this.method_5777(class_3486.field_15518) && this.method_18798().field_1351 < 0.1) {
                    this.method_18799(this.method_18798().method_1031(0.0, 0.02, 0.0));
                }
                this.method_18799(this.method_18798().method_1021(0.6));
            } else {
                this.method_18799(this.method_18798().method_1031(0.0, -0.03, 0.0));
                this.method_18799(this.method_18798().method_1021(0.98));
            }
        }
    }

    private void inWaterGravity() {
        class_238 thisBox = this.method_5829();
        class_238 box = new class_238(thisBox.field_1320, thisBox.field_1325 + 0.375, thisBox.field_1324, thisBox.field_1323, thisBox.field_1325, thisBox.field_1321);
        List entityList = this.method_5770().method_8335((class_1297)this, box);
        if (!entityList.isEmpty()) {
            class_1297 entity = (class_1297)entityList.get(0);
            double velocity = this.actualY - entity.method_23318();
            Object e = entityList.get(0);
            if (e instanceof class_1657) {
                class_1657 player = (class_1657)e;
                this.method_18800(0.0, velocity / 10.0, 0.0);
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    Services.REGISTRY.triggerSpecial(serverPlayer, SpecialCriterion.Special.HOP);
                }
            } else if (velocity < -0.6) {
                this.inWaterBob();
            } else {
                this.method_18800(0.0, velocity / 20.0, 0.0);
            }
        } else {
            this.inWaterBob();
        }
    }

    private void inWaterBob() {
        if (this.method_5869()) {
            this.method_18799(this.method_18798().method_1021(0.95));
            this.method_18799(this.method_18798().method_1031(0.0, 0.003, 0.0));
        } else if (this.method_5799() && this.method_18798().field_1351 < 0.01) {
            this.method_18799(this.method_18798().method_1021(0.9));
            this.method_18799(this.method_18798().method_1031(0.0, -0.01, 0.0));
        }
    }

    public boolean method_5862() {
        return false;
    }

    public boolean method_5753() {
        return this.getTraits().fireResistant();
    }

    @NotNull
    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this, this.direction.method_10146());
    }

    public void method_31471(@NotNull class_2604 packet) {
        super.method_31471(packet);
        this.setDirection(class_2350.method_10143((int)packet.method_11166()));
    }

    @Override
    protected void method_5749(class_2487 tag) {
        this.getInventory().readStackNbt(tag);
        this.fromNBT(tag);
    }

    protected void fromNBT(class_2487 tag) {
        this.setDirection(class_2350.method_10143((int)tag.method_10571("facing")));
        this.method_5875(tag.method_10577("hanging"));
        this.field_6011.method_12778(LOCKED, (Object)tag.method_10577("Locked"));
        class_2487 localData = tag.method_10562("local_data");
        this.field_6011.method_12778(OWNER, Optional.of(localData.method_25926("owner")));
        this.field_6011.method_12778(LOCAL_DATA, (Object)localData);
        this.itemTags = tag.method_10562("item_tags");
    }

    @Override
    protected void method_5652(class_2487 tag) {
        this.getInventory().writeNbt(tag);
        this.field_6011.method_12778(STACKS, this.getInventory().getItemStacks());
        this.toNBT(tag);
    }

    protected void toNBT(class_2487 tag) {
        tag.method_10556("Locked", ((Boolean)this.field_6011.method_12789(LOCKED)).booleanValue());
        tag.method_10567("facing", (byte)this.direction.method_10146());
        tag.method_10556("hanging", this.method_5740());
        class_2487 traits = this.getTraits().toNBT();
        UUID placedBy = this.getPlacedBy();
        if (placedBy != this.field_6021 && placedBy != null) {
            traits.method_25927("owner", placedBy);
        }
        tag.method_10566("local_data", (class_2520)traits);
        if (this.itemTags != null) {
            tag.method_10566("item_tags", (class_2520)this.itemTags);
        }
    }

    public boolean method_30949(@NotNull class_1297 that) {
        class_1309 livingEntity;
        if (that instanceof class_1309 && !(livingEntity = (class_1309)that).method_5805()) {
            return false;
        }
        if (this.method_5794(that)) {
            return false;
        }
        return that.method_30948() || that.method_5810();
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5698(class_1297 attacker) {
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            return this.method_5643(this.method_48923().method_48802(player), 0.0f);
        }
        return false;
    }

    public boolean method_5643(class_1282 damageSource, float amount) {
        class_1297 class_12972;
        double height = 0.1;
        if (damageSource.method_49708(class_8111.field_42335) || damageSource.method_49708(class_8111.field_42338)) {
            if (this.method_5753()) {
                return false;
            }
            this.damage(1, true);
            if ((this.breakAmount + 10) % 11 == 0) {
                this.method_5783(class_3417.field_14821, 0.8f, 1.0f);
            }
            return true;
        }
        if (damageSource.method_49708(class_8111.field_42337)) {
            return false;
        }
        if (damageSource.method_49708(class_8111.field_42344)) {
            this.breakAndDropContents();
            return true;
        }
        if (damageSource.method_49708(class_8111.field_42331) || damageSource.method_49708(class_8111.field_42332)) {
            return this.hop(height += Math.sqrt(amount) / 20.0);
        }
        if (damageSource.method_49708(class_8111.field_42321) || damageSource.method_49708(class_8111.field_42328) || damageSource.method_49708(class_8111.field_42322) || damageSource.method_49708(class_8111.field_42323)) {
            this.hop(height);
            return false;
        }
        if (damageSource.method_49708(class_8111.field_42320) && (class_12972 = damageSource.method_5526()) instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (player.method_7337()) {
                this.method_5768();
                this.method_5785();
            } else {
                float damage = !player.method_5667().equals(this.getPlacedBy()) && (this.isLocked() || Kind.BIG_BUNDLE.is(this.getTraits().kind)) ? 3.0f : 10.0f;
                return this.damage((int)damage, false);
            }
        }
        this.hop(height);
        return true;
    }

    private boolean damage(int damage, boolean silent) {
        int health = 24;
        this.wobble = Math.min(this.wobble + 10, health);
        this.breakAmount += damage;
        if (this.breakAmount >= health) {
            this.breakAndDropContents();
        } else if (!silent) {
            PlaySound.HIT.at(this, this.getTraits().sound());
            return this.hop(0.1);
        }
        return true;
    }

    protected void breakAndDropContents() {
        if (this.isLocked()) {
            this.method_43077(PlaySound.Events.UNLOCK.get());
        }
        this.setLocked(false);
        Traits.LocalData traits = this.getTraits();
        PlaySound.BREAK.at(this, traits.sound());
        boolean dropItems = this.method_37908().method_8450().method_8355(class_1928.field_19392);
        if (dropItems && !Kind.ENDER.is(traits.kind)) {
            class_2371<class_1799> stacks = this.getInventory().getItemStacks();
            while (!stacks.isEmpty()) {
                class_1799 stack = (class_1799)stacks.remove(0);
                this.method_5775(stack);
            }
        }
        class_1799 backpack = this.toStack();
        if (!this.method_31481() && !this.method_37908().method_8608()) {
            this.method_5768();
            this.method_5785();
            if (dropItems) {
                this.method_5775(backpack);
            }
        }
    }

    public boolean hop(double height) {
        if (this.method_5740()) {
            this.method_5875(false);
        } else {
            this.method_18799(this.method_18798().method_1031(0.0, height, 0.0));
        }
        if (this.method_37908().method_8608()) {
            this.getViewable().headPitch += 0.1f;
        }
        return true;
    }

    protected boolean isLocked() {
        return (Boolean)this.field_6011.method_12789(LOCKED);
    }

    protected void setLocked(boolean isLocked) {
        this.field_6011.method_12778(LOCKED, (Object)isLocked);
    }

    public boolean isLocked(BackData backData, class_3218 level, Traits.Sound sound) {
        class_1657 player = backData.owner;
        if (player.method_7337()) {
            return false;
        }
        for (LockedReason value : LockedReason.values()) {
            if (!value.apply(backData, level, this)) continue;
            player.method_7353((class_2561)class_2561.method_43471((String)("entity.beansbackpacks.locked." + value.toString().toLowerCase())), true);
            PlaySound.HIT.at(this, sound);
            this.hop(0.1);
            return true;
        }
        return false;
    }

    @NotNull
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 itemInHand;
        if (!this.isLocked() && (itemInHand = player.method_5998(hand)).method_31574(Services.REGISTRY.getLock()) && player.method_5667().equals(this.getPlacedBy())) {
            this.method_43077(PlaySound.Events.LOCK.get());
            this.setLocked(true);
            if (!player.method_7337()) {
                itemInHand.method_7934(1);
            }
            return class_1269.field_5812;
        }
        if (player.method_21751()) {
            if (this.isLocked() && player.method_5667().equals(this.getPlacedBy())) {
                this.method_43077(PlaySound.Events.UNLOCK.get());
                this.setLocked(false);
                if (!player.method_7337()) {
                    class_1661 inventory = player.method_31548();
                    itemInHand = player.method_5998(class_1268.field_5808);
                    int slot = itemInHand.method_7960() ? inventory.field_7545 : -1;
                    inventory.method_7367(slot, Services.REGISTRY.getLock().method_7854());
                }
            }
            return this.shiftClickOnBackpack(player, hand);
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_1269 interact = this.interact(serverPlayer);
            if (interact.method_23665()) {
                return interact;
            }
            if (this.getViewable().getViewers() < 1) {
                this.getInventory().playSound(PlaySound.OPEN);
            }
            if (Kind.ENDER.is(this.traits.kind)) {
                SendEnderStacks.send(serverPlayer, this.getPlacedBy());
            }
            Services.NETWORK.openBackpackMenu(player, this);
        }
        return class_1269.field_5812;
    }

    private class_1269 shiftClickOnBackpack(class_1657 player, class_1268 hand) {
        class_1799 backpackStack;
        BackData backData = BackData.get(player);
        class_1799 backStack = backData.getStack();
        class_1799 inHand = player.method_5998(hand);
        class_1799 class_17992 = backpackStack = backData.actionKeyDown && !backStack.method_7960() ? backStack : inHand;
        if (Kind.isBackpack(backpackStack)) {
            return BackpackItem.useOnBackpack(player, this, backpackStack, backData.actionKeyDown);
        }
        class_243 vec3 = player.method_33571();
        class_243 view = player.method_5828(1.0f).method_1021(10.0);
        class_238 aabb = new class_238(player.method_24515(), this.method_24515()).method_1014(1.0);
        Predicate<class_1297> entityPredicate = p_234237_ -> !p_234237_.method_7325() && p_234237_.method_5863();
        class_3966 hitResult = class_1675.method_18075((class_1297)player, (class_243)vec3, (class_243)vec3.method_1019(view), (class_238)aabb, entityPredicate, (double)10.0);
        if (hitResult == null) {
            return class_1269.field_5811;
        }
        class_243 hit = hitResult.method_17784();
        class_243 target = new class_243((double)this.method_31477() + 0.5, this.actualY, (double)this.method_31479() + 0.5);
        class_2350 entityDirection = this.method_5735();
        class_2350.class_2351 axis = entityDirection.method_10166();
        boolean isHorizontal = axis.method_10179();
        if (isHorizontal) {
            target = target.method_43206(entityDirection, -0.5);
        }
        double x = target.field_1352 - hit.field_1352;
        double y = hit.field_1351 - target.field_1351;
        double z = target.field_1350 - hit.field_1350;
        class_2350 direction = axis == class_2350.class_2351.field_11048 && x == 0.0 || axis == class_2350.class_2351.field_11051 && z == 0.0 ? entityDirection.method_10153() : (y == 0.5625 ? class_2350.field_11036 : (y == 0.0 ? class_2350.field_11033 : (Math.abs(x) > Math.abs(z) ? (x < 0.0 ? class_2350.field_11034 : class_2350.field_11039) : (z < 0.0 ? class_2350.field_11035 : class_2350.field_11043))));
        class_243 placeVec = this.method_19538().method_1031(0.0, y, 0.0).method_43206(direction, 1.0);
        class_2338 placePos = class_2338.method_49637((double)placeVec.field_1352, (double)placeVec.field_1351, (double)placeVec.field_1350);
        if (!player.method_37908().method_8320(placePos).method_45474()) {
            return class_1269.field_5811;
        }
        class_3965 blockHitResult = new class_3965(placeVec, direction, placePos, true);
        return inHand.method_7981(new class_1838(player, hand, blockHitResult));
    }

    public class_1269 interact(class_3222 player) {
        Traits.Sound sound = this.getTraits().sound();
        BackData backData = BackData.get((class_1657)player);
        boolean actionKeyPressed = backData.actionKeyDown;
        if (this.isLocked(backData, player.method_51469(), sound)) {
            return class_1269.field_5812;
        }
        if (actionKeyPressed) {
            if (Kind.BIG_BUNDLE.is(this.getTraits().kind) && !player.method_5667().equals(this.getPlacedBy())) {
                player.method_7353((class_2561)class_2561.method_43471((String)"entity.beansbackpacks.locked.back_bundle_equip"), true);
                PlaySound.HIT.at(this, sound);
                this.hop(0.1);
                return class_1269.field_5812;
            }
            class_1799 backpackStack = this.toStack();
            if (backData.mayEquip(backpackStack, false, true)) {
                EntityAbstract entityAbstract = this;
                if (entityAbstract instanceof EntityEnder) {
                    EntityEnder ender = (EntityEnder)entityAbstract;
                    if (ender.getPlacedBy() == null) {
                        ender.setPlacedBy(Optional.of(player.method_5667()));
                        EnderStorage.getEnderData((class_1657)player);
                    }
                } else {
                    BackpackInventory backpackInventory = BackData.get((class_1657)player).getBackpackInventory();
                    class_2371<class_1799> playerInventoryStacks = backpackInventory.getItemStacks();
                    class_2371<class_1799> backpackEntityStacks = this.getItemStacks();
                    backpackInventory.method_5448();
                    playerInventoryStacks.addAll(backpackEntityStacks);
                }
                backData.set(backpackStack);
                PlaySound.EQUIP.at((class_1297)player, sound);
                SendBackInventory.send(player);
                if (!this.method_31481()) {
                    this.method_5768();
                    this.method_5785();
                }
            } else {
                PlaySound.HIT.at(this, sound);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public class_1799 method_31480() {
        return this.toStack();
    }

    protected boolean method_5638() {
        return false;
    }

    public boolean method_5863() {
        return true;
    }

    @NotNull
    public class_243 method_19538() {
        return new class_243((double)this.pos.method_10263(), this.actualY, (double)this.pos.method_10260());
    }

    public int getAnalogOutput() {
        int max;
        if (this.getItemStacks().isEmpty()) {
            return 0;
        }
        int space = this.getInventory().spaceLeft();
        if (space == (max = this.getTraits().maxStacks() * 64)) {
            return 0;
        }
        float i = max - space;
        i /= (float)max;
        i *= 14.0f;
        return (int)(i += 1.0f);
    }

    public static enum LockedReason {
        IS_REMOVED((TriFunction<BackData, class_3218, EntityAbstract, Boolean>)((TriFunction)(backData, level, entityAbstract) -> entityAbstract.method_31481())),
        INVALID_DATA((TriFunction<BackData, class_3218, EntityAbstract, Boolean>)((TriFunction)(backData, level, entityAbstract) -> {
            if (entityAbstract.getPlacedBy() == null || entityAbstract.getInventory() == null) {
                UUID uuid = backData.owner.method_5667();
                entityAbstract.setPlacedBy(Optional.of(uuid));
            }
            return false;
        })),
        IS_LOCKED((TriFunction<BackData, class_3218, EntityAbstract, Boolean>)((TriFunction)(backData, serverLevel, entityAbstract) -> {
            UUID placedBy = entityAbstract.getPlacedBy();
            if (backData.owner.method_5667().equals(placedBy)) {
                return false;
            }
            boolean locked = entityAbstract.isLocked();
            if (locked) {
                MinecraftServer server = serverLevel.method_8503();
                ServerSave.getSave(server, false).grantLockedAchievement(server, placedBy);
            }
            return locked;
        })),
        NOT_OWNER((TriFunction<BackData, class_3218, EntityAbstract, Boolean>)((TriFunction)(backData, level, entityAbstract) -> {
            if (ServerSave.GAMERULES.get((Object)Gamerules.LOCK_BACKPACK_NOT_OWNER).booleanValue()) {
                UUID placedBy = entityAbstract.getPlacedBy();
                return backData.owner.method_5667() != placedBy || placedBy == ((EntityAbstract)entityAbstract).field_6021;
            }
            return false;
        })),
        OWNER_OFFLINE((TriFunction<BackData, class_3218, EntityAbstract, Boolean>)((TriFunction)(backData, level, entityAbstract) -> {
            if (ServerSave.GAMERULES.get((Object)Gamerules.LOCK_BACKPACK_OFFLINE).booleanValue()) {
                UUID placedBy = entityAbstract.getPlacedBy();
                return placedBy != null && placedBy != ((EntityAbstract)entityAbstract).field_6021 && level.method_18470(placedBy) == null;
            }
            return false;
        })),
        ENDER_OFFLINE((TriFunction<BackData, class_3218, EntityAbstract, Boolean>)((TriFunction)(backData, level, entityAbstract) -> {
            if (ServerSave.GAMERULES.get((Object)Gamerules.LOCK_ENDER_OFFLINE).booleanValue()) {
                return entityAbstract instanceof EntityEnder && OWNER_OFFLINE.apply((BackData)backData, (class_3218)level, (EntityAbstract)((Object)entityAbstract));
            }
            return false;
        }));

        final TriFunction<BackData, class_3218, EntityAbstract, Boolean> isLocked;

        private LockedReason(TriFunction<BackData, class_3218, EntityAbstract, Boolean> isLocked) {
            this.isLocked = isLocked;
        }

        public boolean apply(BackData backData, class_3218 player, EntityAbstract backpack) {
            return (Boolean)this.isLocked.apply((Object)backData, (Object)player, (Object)backpack);
        }
    }
}

