/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.entity;

import com.beansgalaxy.backpacks.data.EnderStorage;
import com.beansgalaxy.backpacks.data.Traits;
import com.beansgalaxy.backpacks.entity.EntityAbstract;
import com.beansgalaxy.backpacks.events.PlaySound;
import com.beansgalaxy.backpacks.inventory.BackpackInventory;
import com.beansgalaxy.backpacks.inventory.EnderInventory;
import com.beansgalaxy.backpacks.network.clientbound.SendEnderDisplay;
import com.beansgalaxy.backpacks.platform.Services;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;

public class EntityEnder
extends EntityAbstract {
    public EntityEnder(class_1299<? extends class_1297> type, class_1937 level) {
        super(type, level);
    }

    public EntityEnder(class_1937 level) {
        super(Services.REGISTRY.getEnderEntity(), level);
    }

    private EnderStorage getEnderStorage() {
        return EnderStorage.get(this.method_37908());
    }

    public Optional<EnderInventory> getEnderData() {
        return ((Optional)this.field_6011.method_12789(OWNER)).map(in -> EnderStorage.getEnderData(in, this.method_37908()));
    }

    @Override
    protected boolean isLocked() {
        return this.getEnderData().map(EnderInventory::isLocked).orElse(true);
    }

    @Override
    protected void setLocked(boolean isLocked) {
        this.getEnderData().ifPresent(enderData -> {
            boolean locked = !enderData.isLocked();
            enderData.setLocked(locked);
            this.getEnderStorage().forEachViewing(this.field_6021, SendEnderDisplay::send, equipped -> {
                if (equipped.owner.method_5667() != this.field_6021) {
                    equipped.drop();
                }
            });
            enderData.clearViewers();
        });
    }

    @Override
    public BackpackInventory getInventory() {
        return this.getEnderData().orElse(null);
    }

    @Override
    public Traits.LocalData getTraits() {
        if (this.traits.isEmpty()) {
            this.traits = new Traits.LocalData((class_2487)this.field_6011.method_12789(LOCAL_DATA)){

                @Override
                public class_2487 getTrim() {
                    return EntityEnder.this.getEnderData().map(EnderInventory::getTrim).orElse(new class_2487());
                }
            };
        }
        return this.traits;
    }

    @Override
    @NotNull
    public class_2561 method_5476() {
        return this.getEnderData().map(EnderInventory::getPlayerName).orElse((class_2561)class_2561.method_43473());
    }

    @Override
    public UUID getPlacedBy() {
        Optional uuid = (Optional)this.field_6011.method_12789(OWNER);
        return uuid.orElse(null);
    }

    public void method_5768() {
        this.getEnderData().ifPresent(in -> in.locations.remove(this.method_5667()));
        super.method_5768();
        this.method_37908().method_8455(this.pos, class_2246.field_10124);
    }

    public void method_5650(class_1297.class_5529 $$0) {
        UUID placedBy = this.getPlacedBy();
        if (placedBy != null) {
            this.getEnderStorage().removeViewer(placedBy, this);
        }
        super.method_5650($$0);
    }

    public boolean method_5733() {
        return true;
    }

    public boolean method_16914() {
        return this.getPlacedBy() != null;
    }

    @Override
    public void setPlacedBy(Optional<UUID> placedBy) {
        placedBy.ifPresent(in -> {
            this.field_6011.method_12778(OWNER, (Object)placedBy);
            if (!this.method_37908().field_9236) {
                EnderStorage.getEnderData((UUID)in, (class_1937)this.method_37908()).locations.put((UUID)in, new EnderStorage.Location(this.method_24515(), (class_5321<class_1937>)this.method_37908().method_27983()));
                this.getEnderStorage().addViewer((UUID)in, this);
            }
        });
    }

    protected void method_23311() {
        super.method_23311();
        this.method_37908().method_8455(this.pos, class_2246.field_10124);
        this.getEnderStorage().addViewer(this.getPlacedBy(), this);
    }

    @Override
    protected void method_5749(class_2487 tag) {
        this.fromNBT(tag);
        this.getEnderStorage().addViewer(this.getPlacedBy(), this);
    }

    @Override
    protected void method_5652(class_2487 tag) {
        this.toNBT(tag);
    }

    @Override
    public int getAnalogOutput() {
        if (this.method_31481() || this.getPlacedBy() == null) {
            return 0;
        }
        return super.getAnalogOutput();
    }

    @Override
    protected void breakAndDropContents() {
        Traits.LocalData traits = this.getTraits();
        PlaySound.BREAK.at(this, traits.sound());
        boolean dropItems = this.method_37908().method_8450().method_8355(class_1928.field_19392);
        if (!this.method_31481() && !this.method_37908().method_8608()) {
            this.method_5768();
            this.method_5785();
            if (dropItems) {
                this.method_5775(this.toStack());
            }
        }
    }
}

