/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.entity;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.config.IConfig;
import com.beansgalaxy.backpacks.data.Traits;
import com.beansgalaxy.backpacks.inventory.CauldronInventory;
import com.beansgalaxy.backpacks.inventory.PotInventory;
import com.beansgalaxy.backpacks.items.BackpackItem;
import com.beansgalaxy.backpacks.items.DyableBackpack;
import com.beansgalaxy.backpacks.items.WingedBackpack;
import com.beansgalaxy.backpacks.platform.Services;
import java.awt.Color;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public enum Kind {
    LEATHER(Services.REGISTRY.getLeather(), Traits.LEATHER, DyableBackpack::shiftColor, data -> Kind.getAppendedName("", "Backpack")),
    METAL(Services.REGISTRY.getMetal(), Traits.METAL, Traits.IGNORE_COLOR, Traits::getName),
    WINGED(Services.REGISTRY.getWinged(), Traits.WINGED, WingedBackpack::shiftColor, data -> Kind.getAppendedName("winged_", "Winged Backpack")),
    ENDER(Services.REGISTRY.getEnder(), Traits.ENDER, Traits.IGNORE_COLOR, data -> Kind.getAppendedName("ender_", "Ender Backpack")),
    POT(class_1802.field_42699.method_8389(), Traits.POT, Traits.IGNORE_COLOR, data -> class_2561.method_43473()),
    CAULDRON(class_1802.field_8638.method_8389(), Traits.CAULDRON, Traits.IGNORE_COLOR, data -> class_2561.method_43473()),
    BIG_BUNDLE(Services.REGISTRY.getBigBundle(), Traits.BIG_BUNDLE, DyableBackpack::shiftBundleColor, data -> Kind.getAppendedName("", "Backpack"));

    final class_1792 item;
    private final Function<Traits.LocalData, class_2561> getName;
    private final Function<Integer, Color> getColor;
    public final Traits defaultTraits;

    private Kind(class_1792 item, Traits defaultTraits, Function<Integer, Color> getColor, Function<Traits.LocalData, class_2561> getName) {
        this.item = item;
        this.defaultTraits = defaultTraits;
        this.getName = getName;
        this.getColor = getColor;
    }

    public static Traits getTraits(class_1799 stack) {
        Kind kind = Kind.fromStack(stack);
        if (kind == null) {
            return Traits.EMPTY;
        }
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10545("backpack_id")) {
            String id = tag.method_10558("backpack_id");
            return kind.traits(id);
        }
        return Traits.METAL;
    }

    public Traits traits(String backpack_id) {
        if (METAL.is(this)) {
            return Traits.get(backpack_id);
        }
        Traits traits = Constants.TRAITS_MAP.get(this.name());
        if (traits != null) {
            return traits;
        }
        return this.defaultTraits;
    }

    public static boolean isBackpack(class_1799 backpackStack) {
        class_1792 item = backpackStack.method_7909();
        return item instanceof BackpackItem;
    }

    public static boolean isWearable(class_1799 stack) {
        return Kind.isWearable(stack.method_7909());
    }

    public static boolean isWearable(class_1792 item) {
        for (Kind kind : Kind.values()) {
            if (!item.equals(kind.getItem())) continue;
            boolean cauldronDisabled = !CAULDRON.is(kind) || CauldronInventory.getMaxSize() != 0;
            boolean potDisabled = !POT.is(kind) || PotInventory.getMaxSize() != 0;
            return cauldronDisabled && potDisabled;
        }
        return IConfig.chestplateDisabled(item) || Kind.isWearableElytra(item);
    }

    public static boolean isWings(class_1799 backStack) {
        if (backStack.method_31574(Services.REGISTRY.getWinged())) {
            return true;
        }
        return Kind.isWearableElytra(backStack.method_7909());
    }

    public static boolean isWearableElytra(class_1792 item) {
        return IConfig.elytraItem(item);
    }

    public static Kind fromStack(class_1799 stack) {
        for (Kind kind : Kind.values()) {
            if (!kind.is(stack)) continue;
            if (kind.is(METAL) && stack.method_7941("backpack_id") != null && stack.method_7969().method_10558("backpack_id").equals("bundle")) {
                return LEATHER;
            }
            return kind;
        }
        return null;
    }

    public static Kind fromItem(class_1935 item) {
        for (Kind kind : Kind.values()) {
            if (!kind.item.equals(item.method_8389())) continue;
            return kind;
        }
        return null;
    }

    public class_1792 getItem() {
        return this.item;
    }

    public static Kind fromName(String string) {
        for (Kind kind : Kind.values()) {
            if (!kind.name().equals(string)) continue;
            return kind;
        }
        return null;
    }

    public boolean is(class_1799 backStack) {
        return backStack.method_31574(this.item);
    }

    public boolean is(Kind kind) {
        return this == kind;
    }

    public static boolean is(Kind kind, Kind ... kinds) {
        return kind != null && Arrays.stream(kinds).anyMatch(in -> in == kind);
    }

    public class_2960 getAppendedResource(String key, String append) {
        StringBuilder string = new StringBuilder();
        string.append("textures/entity/");
        switch (this) {
            case LEATHER: {
                string.append("leather/leather");
                break;
            }
            case METAL: {
                if (!Constants.isEmpty(key)) {
                    string.append("backpack/").append(key);
                    break;
                }
                string.append("metal");
                break;
            }
            case BIG_BUNDLE: {
                string.append("back_bundle/bundle");
                break;
            }
            default: {
                string.append(this.name().toLowerCase());
            }
        }
        if (!Constants.isEmpty(append)) {
            string.append(append);
        }
        string.append(".png");
        String location = string.toString();
        return new class_2960("beansbackpacks", location);
    }

    private static class_2561 getAppendedName(String append, String fallback) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("item.beansbackpacks.");
        if (append != null && !append.isEmpty() && !append.isBlank()) {
            stringBuilder.append(append.toLowerCase());
        }
        stringBuilder.append("backpack");
        return class_2561.method_48321((String)stringBuilder.toString(), (String)fallback);
    }

    public Color getShiftedColor(int color) {
        return this.getColor.apply(color);
    }

    public class_2561 getName(Traits.LocalData traits) {
        return this.getName.apply(traits);
    }
}

