/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.events;

import com.beansgalaxy.backpacks.data.Traits;
import com.beansgalaxy.backpacks.platform.Services;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public enum PlaySound {
    PLACE(class_3417.field_14844),
    EQUIP(class_3417.field_14966),
    HIT(class_3417.field_14625),
    BREAK(class_3417.field_15016),
    INSERT(class_3417.field_34376),
    TAKE(class_3417.field_34377),
    OPEN(class_3417.field_14982),
    CLOSE(class_3417.field_14823);

    private final class_3414 soundEvent;

    private PlaySound(class_3414 soundEvent) {
        this.soundEvent = soundEvent;
    }

    public class_3414 getDefaultSoundEvent() {
        return this.soundEvent;
    }

    public void at(class_1297 entity, Traits.Sound sound) {
        this.at(entity, sound, 1.2f);
    }

    public void at(class_1297 entity, Traits.Sound sound, float volume) {
        class_1937 world = entity.method_37908();
        if (!world.field_9236) {
            Playable playable = this.getSound(sound);
            world.method_8396(null, entity.method_24515(), playable.event, class_3419.field_15245, volume * playable.volume(), playable.pitch());
        }
    }

    public Playable getSound(Traits.Sound sound) {
        switch (sound) {
            case SOFT: {
                switch (this) {
                    case PLACE: {
                        return Events.LEATHER_PLACE.playable(1.0f, 1.0f);
                    }
                    case EQUIP: {
                        return Events.LEATHER_EQUIP.playable(1.0f, 1.0f);
                    }
                    case HIT: {
                        return Events.LEATHER_HIT.playable(1.0f, new Random().nextFloat(0.7f, 1.1f));
                    }
                    case BREAK: {
                        return Events.LEATHER_BREAK.playable(1.0f, 1.0f);
                    }
                    case INSERT: {
                        return Events.LEATHER_INSERT.playable(1.0f, new Random().nextFloat(0.7f, 1.1f));
                    }
                    case TAKE: {
                        return Events.LEATHER_INSERT.playable(1.0f, new Random().nextFloat(1.0f, 1.3f));
                    }
                    case OPEN: {
                        return Events.LEATHER_OPEN.playable(1.0f, 1.0f);
                    }
                    case CLOSE: {
                        return Events.LEATHER_CLOSE.playable(1.0f, 1.0f);
                    }
                }
                break;
            }
            case HARD: {
                switch (this) {
                    case PLACE: {
                        return Events.METAL_PLACE.playable(1.0f, 1.0f);
                    }
                    case EQUIP: {
                        return Events.METAL_EQUIP.playable(1.0f, 1.0f);
                    }
                    case HIT: {
                        return Events.METAL_HIT.playable(1.0f, new Random().nextFloat(0.8f, 1.1f));
                    }
                    case BREAK: {
                        return Events.METAL_BREAK.playable(1.0f, 1.0f);
                    }
                    case INSERT: {
                        return Events.METAL_INSERT.playable(1.0f, new Random().nextFloat(0.8f, 1.1f));
                    }
                    case TAKE: {
                        return Events.METAL_TAKE.playable(0.7f, new Random().nextFloat(0.8f, 1.1f));
                    }
                    case OPEN: {
                        return Events.METAL_OPEN.playable(1.0f, 1.0f);
                    }
                    case CLOSE: {
                        return Events.METAL_CLOSE.playable(1.0f, 1.0f);
                    }
                }
                break;
            }
            case CLAY: {
                switch (this) {
                    case HIT: {
                        return Events.POT_HIT.playable(1.0f, 1.0f);
                    }
                    case INSERT: {
                        return Events.POT_INSERT.playable(1.0f, 1.0f);
                    }
                    case TAKE: {
                        return Events.POT_TAKE.playable(1.0f, 1.0f);
                    }
                }
                break;
            }
            case VWOOMP: {
                switch (this) {
                    case PLACE: {
                        return Events.ENDER_PLACE.playable(1.0f, 1.0f);
                    }
                    case EQUIP: {
                        return Events.ENDER_EQUIP.playable(1.0f, 1.0f);
                    }
                    case HIT: {
                        return Events.ENDER_HIT.playable(1.0f, new Random().nextFloat(0.9f, 1.1f));
                    }
                    case BREAK: {
                        return Events.ENDER_BREAK.playable(1.0f, 1.0f);
                    }
                    case OPEN: {
                        return Events.ENDER_OPEN.playable(1.0f, 1.0f);
                    }
                    case CLOSE: {
                        return Events.ENDER_CLOSE.playable(1.0f, 1.0f);
                    }
                    case TAKE: {
                        return Events.ENDER_TAKE.playable(1.0f, new Random().nextFloat(0.9f, 1.1f));
                    }
                    case INSERT: {
                        return Events.ENDER_INSERT.playable(1.0f, new Random().nextFloat(0.9f, 1.1f));
                    }
                }
                break;
            }
            case CRUNCH: {
                switch (this) {
                    case PLACE: {
                        return Events.WINGED_PLACE.playable(1.0f, 1.0f);
                    }
                    case EQUIP: {
                        return Events.WINGED_EQUIP.playable(1.0f, 1.0f);
                    }
                    case HIT: {
                        return Events.WINGED_HIT.playable(1.0f, new Random().nextFloat(0.7f, 1.1f));
                    }
                    case BREAK: {
                        return Events.WINGED_BREAK.playable(1.0f, 1.0f);
                    }
                    case INSERT: {
                        return Events.LEATHER_INSERT.playable(1.0f, new Random().nextFloat(0.7f, 1.1f));
                    }
                    case TAKE: {
                        return Events.LEATHER_INSERT.playable(1.0f, new Random().nextFloat(1.0f, 1.3f));
                    }
                    case OPEN: {
                        return Events.WINGED_OPEN.playable(1.0f, 1.0f);
                    }
                    case CLOSE: {
                        return Events.WINGED_CLOSE.playable(1.0f, 1.0f);
                    }
                }
            }
        }
        return new Playable(this.getDefaultSoundEvent(), 1.0f, 1.0f);
    }

    public record Playable(class_3414 event, float volume, float pitch) {
    }

    public static enum Events {
        LEATHER_PLACE("leather_place"),
        LEATHER_EQUIP("leather_equip"),
        LEATHER_HIT("leather_hit"),
        LEATHER_BREAK("leather_break"),
        LEATHER_INSERT("leather_insert"),
        LEATHER_OPEN("leather_open"),
        LEATHER_CLOSE("leather_close"),
        METAL_PLACE("metal_place"),
        METAL_EQUIP("metal_equip"),
        METAL_HIT("metal_hit"),
        METAL_BREAK("metal_break"),
        METAL_INSERT("metal_insert"),
        METAL_TAKE("metal_take"),
        METAL_OPEN("metal_open"),
        METAL_CLOSE("metal_close"),
        ENDER_PLACE("ender_place"),
        ENDER_EQUIP("ender_equip"),
        ENDER_HIT("ender_hit"),
        ENDER_BREAK("ender_break"),
        ENDER_INSERT("ender_insert"),
        ENDER_TAKE("ender_take"),
        ENDER_OPEN("ender_open"),
        ENDER_CLOSE("ender_close"),
        WINGED_PLACE("winged_place"),
        WINGED_EQUIP("winged_equip"),
        WINGED_HIT("winged_hit"),
        WINGED_BREAK("winged_break"),
        WINGED_OPEN("winged_open"),
        WINGED_CLOSE("winged_close"),
        POT_HIT("pot_hit"),
        POT_INSERT("pot_insert"),
        POT_TAKE("pot_take"),
        LOCK("lock_backpack"),
        UNLOCK("unlock_backpack");

        public final String id;

        private Events(String id) {
            this.id = id;
        }

        public class_3414 get() {
            return Services.REGISTRY.soundEvent(this.id);
        }

        private Playable playable(float volume, float pitch) {
            return new Playable(this.get(), volume, pitch);
        }
    }
}

