/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.events;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.data.EnderStorage;
import com.beansgalaxy.backpacks.data.ServerSave;
import com.beansgalaxy.backpacks.data.config.Gamerules;
import com.beansgalaxy.backpacks.inventory.EnderInventory;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class RegisterCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder beansmod = class_2170.method_9247((String)"beansmod");
        RegisterCommands.registerGameruleCommand((LiteralArgumentBuilder<class_2168>)beansmod);
        RegisterCommands.registerGiveCommand((LiteralArgumentBuilder<class_2168>)beansmod);
        RegisterCommands.registerEnderDataCommand((LiteralArgumentBuilder<class_2168>)beansmod);
        dispatcher.register(beansmod);
    }

    private static void registerGiveCommand(LiteralArgumentBuilder<class_2168> beansmod) {
        beansmod.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"give").requires(in -> in.method_9259(4))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"backpack_id", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String backpack_id = StringArgumentType.getString((CommandContext)ctx, (String)"backpack_id");
            Collection targets = class_2186.method_9312((CommandContext)ctx, (String)"targets");
            if (!Constants.TRAITS_MAP.containsKey(backpack_id)) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.beansbackpacks.give.fail.no_id", (Object[])new Object[]{backpack_id}));
                return -1;
            }
            if (targets.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.beansbackpacks.give.fail.no_players"));
                return -1;
            }
            class_1799 backpackStack = Constants.createLabeledBackpack(backpack_id);
            class_2561 playerNames = null;
            for (class_3222 player : targets) {
                player.method_31548().method_7394(backpackStack.method_7972());
                if (playerNames != null) {
                    playerNames.method_27662().method_27693(", ").method_10852(player.method_5477());
                    continue;
                }
                playerNames = player.method_5476();
            }
            class_2561 finalPlayerNames = playerNames;
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.beansbackpacks.give.success", (Object[])new Object[]{backpackStack.method_7954(), finalPlayerNames}), true);
            return targets.size();
        }))));
    }

    private static void registerGameruleCommand(LiteralArgumentBuilder<class_2168> beansmod) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"gamerule").requires(in -> in.method_9259(4));
        for (Gamerules value : Gamerules.values()) {
            builder.then(class_2170.method_9247((String)value.readable()).then(class_2170.method_9244((String)value.readable(), (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
                String readable = value.readable();
                boolean newValue = BoolArgumentType.getBool((CommandContext)ctx, (String)readable);
                if (ServerSave.GAMERULES.get((Object)value).equals(newValue)) {
                    ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.beansbackpacks.config.fail", (Object[])new Object[]{readable, newValue}));
                    return -1;
                }
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.beansbackpacks.config.success", (Object[])new Object[]{readable, newValue}), true);
                ServerSave.GAMERULES.put(value, newValue);
                return 1;
            })));
        }
        beansmod.then((ArgumentBuilder)builder);
    }

    private static void registerEnderDataCommand(LiteralArgumentBuilder<class_2168> beansmod) {
        beansmod.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"enderdata").requires(in -> in.method_9259(4))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            class_1937 level = ((class_2168)ctx.getSource()).method_44023().method_37908();
            HashMap<UUID, EnderInventory> enderStorage = EnderStorage.get((class_1937)level).MAP;
            int size = enderStorage.size();
            class_5250 literal = class_2561.method_48322((String)"command.beansbackpacks.enderdata.list.success", (String)"%d entries found: ", (Object[])new Object[]{size});
            boolean addBreak = false;
            for (UUID uuid : enderStorage.keySet()) {
                if (addBreak) {
                    literal.method_27693(", ");
                } else {
                    literal.method_27693(": ");
                }
                addBreak = true;
                EnderInventory enderData = enderStorage.get(uuid);
                if (Constants.isEmpty(enderData.getPlayerName())) {
                    literal.method_10852((class_2561)class_2561.method_43470((String)("(" + uuid + ")")).method_27692(class_124.field_1080).method_27692(class_124.field_1056));
                    continue;
                }
                literal.method_10852((class_2561)enderData.getPlayerNameColored(((class_2168)ctx.getSource()).method_30497()));
            }
            ((class_2168)ctx.getSource()).method_9226(() -> literal, false);
            return size;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear_player").executes(ctx -> {
            class_1937 level = ((class_2168)ctx.getSource()).method_44023().method_37908();
            HashMap<UUID, EnderInventory> enderStorage = EnderStorage.get((class_1937)level).MAP;
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            int sizeS = enderStorage.size();
            enderStorage.remove(player.method_5667());
            int sizeE = enderStorage.size();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.beansbackpacks.enderdata.clear.success", (Object[])new Object[]{player.method_5477()}), true);
            return sizeE - sizeS;
        })).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(ctx -> {
            class_1937 level = ((class_2168)ctx.getSource()).method_44023().method_37908();
            HashMap<UUID, EnderInventory> enderStorage = EnderStorage.get((class_1937)level).MAP;
            List targets = (List)class_2186.method_9312((CommandContext)ctx, (String)"targets");
            int total = 0;
            for (class_3222 player : targets) {
                enderStorage.remove(player.method_5667());
                ++total;
            }
            class_5250 who = total == 1 ? ((class_3222)targets.get(0)).method_5477() : class_2561.method_43470((String)String.valueOf(total));
            ((class_2168)ctx.getSource()).method_9226(() -> RegisterCommands.lambda$registerEnderDataCommand$11((class_2561)who), true);
            return total;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"clear_all").executes(ctx -> {
            class_1937 level = ((class_2168)ctx.getSource()).method_44023().method_37908();
            HashMap<UUID, EnderInventory> enderStorage = EnderStorage.get((class_1937)level).MAP;
            int size = enderStorage.size();
            enderStorage.clear();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.beansbackpacks.enderdata.clear.success", (Object[])new Object[]{size}), true);
            return size;
        })).then(class_2170.method_9247((String)"no_data").executes(ctx -> {
            class_1937 level = ((class_2168)ctx.getSource()).method_44023().method_37908();
            HashMap<UUID, EnderInventory> enderStorage = EnderStorage.get((class_1937)level).MAP;
            int total = 0;
            for (UUID uuid : enderStorage.keySet()) {
                EnderInventory enderData = enderStorage.get(uuid);
                if (!enderData.getItemStacks().isEmpty() || !enderData.getTrim().method_33133()) continue;
                enderStorage.remove(uuid);
                ++total;
            }
            class_5250 literal = class_2561.method_43470((String)String.valueOf(total));
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.beansbackpacks.enderdata.clear.success", (Object[])new Object[]{literal}), true);
            return total;
        }))).then(class_2170.method_9247((String)"empty_inventories").executes(ctx -> {
            class_1937 level = ((class_2168)ctx.getSource()).method_44023().method_37908();
            HashMap<UUID, EnderInventory> enderStorage = EnderStorage.get((class_1937)level).MAP;
            ArrayList<UUID> forRemoval = new ArrayList<UUID>();
            for (UUID uuid : enderStorage.keySet()) {
                EnderInventory enderData = enderStorage.get(uuid);
                if (!enderData.getItemStacks().isEmpty()) continue;
                forRemoval.add(uuid);
            }
            int total = forRemoval.size();
            for (UUID uuid : forRemoval) {
                enderStorage.remove(uuid);
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.beansbackpacks.enderdata.clear.success", (Object[])new Object[]{String.valueOf(total)}), true);
            return total;
        }))).then(class_2170.method_9247((String)"empty_name").executes(ctx -> {
            class_1937 level = ((class_2168)ctx.getSource()).method_44023().method_37908();
            HashMap<UUID, EnderInventory> enderStorage = EnderStorage.get((class_1937)level).MAP;
            ArrayList<UUID> forRemoval = new ArrayList<UUID>();
            for (UUID uuid : enderStorage.keySet()) {
                EnderInventory enderData = enderStorage.get(uuid);
                if (!Constants.isEmpty(enderData.getPlayerName())) continue;
                forRemoval.add(uuid);
            }
            int total = forRemoval.size();
            for (UUID uuid : forRemoval) {
                enderStorage.remove(uuid);
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.beansbackpacks.enderdata.clear.success", (Object[])new Object[]{String.valueOf(total)}), true);
            return total;
        }))));
    }

    private static /* synthetic */ class_2561 lambda$registerEnderDataCommand$11(class_2561 who) {
        return class_2561.method_43469((String)"command.beansbackpacks.enderdata.clear.success", (Object[])new Object[]{who});
    }
}

