/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.inventory;

import com.beansgalaxy.backpacks.config.IConfig;
import com.beansgalaxy.backpacks.config.types.MapConfigVariant;
import com.beansgalaxy.backpacks.data.BackData;
import com.beansgalaxy.backpacks.data.ServerSave;
import com.beansgalaxy.backpacks.data.Traits;
import com.beansgalaxy.backpacks.data.Viewable;
import com.beansgalaxy.backpacks.entity.EntityAbstract;
import com.beansgalaxy.backpacks.entity.EntityEnder;
import com.beansgalaxy.backpacks.entity.Kind;
import com.beansgalaxy.backpacks.events.PlaySound;
import com.beansgalaxy.backpacks.events.advancements.SpecialCriterion;
import com.beansgalaxy.backpacks.inventory.EnderInventory;
import com.beansgalaxy.backpacks.items.BackpackItem;
import com.beansgalaxy.backpacks.network.clientbound.SendViewers;
import com.beansgalaxy.backpacks.platform.Services;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_5568;
import net.minecraft.class_7923;

public abstract class BackpackInventory
implements class_1263 {
    private final class_2371<class_3222> playersViewing = class_2371.method_10211();
    private final class_2371<class_1799> itemStacks = class_2371.method_10211();
    private final Viewable viewable = new Viewable();

    public abstract class_5568 getOwner();

    public abstract Traits.LocalData getTraits();

    public abstract UUID getPlacedBy();

    public abstract class_1937 level();

    public boolean stopHopper() {
        return false;
    }

    public class_2371<class_3222> getPlayersViewing() {
        return this.playersViewing;
    }

    public class_2371<class_1799> getItemStacks() {
        return this.itemStacks;
    }

    public Viewable getViewable() {
        return this.viewable;
    }

    public void clearViewers() {
        this.getPlayersViewing().clear();
        this.getViewable().setViewers((byte)0);
    }

    public void addViewer(class_3222 viewer) {
        this.getPlayersViewing().add((Object)viewer);
        this.updateViewers();
    }

    public void removeViewer(class_3222 viewer) {
        this.getPlayersViewing().remove((Object)viewer);
        this.updateViewers();
    }

    public void updateViewers() {
        class_2371<class_3222> playersViewing = this.getPlayersViewing();
        this.getViewable().setViewers((byte)Math.min(playersViewing.size(), 127));
        SendViewers.send(this);
    }

    public static boolean yawMatches(float viewerYaw, float ownerYaw, double acceptableYaw) {
        double yaw = Math.abs(viewerYaw - ownerYaw) % 360.0f - 180.0f;
        return Math.abs(yaw) > 180.0 - acceptableYaw;
    }

    public void playSound(PlaySound sound) {
        this.playSound(sound, 0.8f);
    }

    public void playSound(PlaySound sound, float volume) {
        class_5568 class_55682 = this.getOwner();
        if (class_55682 instanceof class_1297) {
            class_1297 entity = (class_1297)class_55682;
            sound.at(entity, this.getTraits().sound(), volume);
        }
    }

    public int method_5439() {
        return this.getItemStacks().size();
    }

    public boolean method_5442() {
        return this.getItemStacks().isEmpty() || Kind.is(this.getTraits().kind, Kind.POT, Kind.CAULDRON) || this.getItemStacks().stream().allMatch(class_1799::method_7960);
    }

    public void method_5448() {
        if (Kind.ENDER.is(this.getTraits().kind)) {
            return;
        }
        this.getItemStacks().clear();
    }

    public class_1799 method_5438(int slot) {
        return this.method_5439() > slot ? (class_1799)this.getItemStacks().get(slot) : class_1799.field_8037;
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 stack = this.removeItemSilent(slot, amount);
        if (!stack.method_7960()) {
            this.playSound(PlaySound.TAKE);
        }
        return stack;
    }

    public class_1799 removeItemSilent(int slot, int amount) {
        class_1799 stack = this.method_5438(slot).method_7971(amount);
        if (stack.method_7960() && this.method_5439() > slot) {
            this.getItemStacks().remove(slot);
        }
        this.method_5431();
        return stack;
    }

    public int method_5444() {
        return super.method_5444();
    }

    public class_1799 method_5441(int slot) {
        class_1799 stack = this.removeItemSilent(slot);
        if (!stack.method_7960()) {
            this.playSound(PlaySound.TAKE);
        }
        return stack;
    }

    public class_1799 removeItemSilent(int slot) {
        class_1799 returned = class_1799.field_8037;
        if (this.method_5439() > slot) {
            class_1799 stack = (class_1799)this.getItemStacks().get(slot);
            int maxCount = stack.method_7914();
            if (stack.method_7947() > maxCount) {
                stack.method_7934(maxCount);
                returned = stack.method_46651(maxCount);
            } else {
                returned = (class_1799)this.getItemStacks().remove(slot);
            }
            this.method_5431();
        }
        return returned;
    }

    public void method_5447(int slot, class_1799 stack) {
        int containerSize = this.method_5439();
        if (!stack.method_7960()) {
            if (this.method_5439() > slot) {
                this.getItemStacks().set(slot, (Object)stack);
            } else {
                this.getItemStacks().add(slot, (Object)stack);
            }
        } else if (containerSize > slot) {
            this.getItemStacks().remove(slot);
        }
    }

    public class_1799 returnItem(int slot, class_1799 stack) {
        return this.returnItem(slot, stack, stack.method_7947());
    }

    public class_1799 returnItem(int slot, class_1799 stack, int amount) {
        if (!stack.method_7960()) {
            return this.insertItem(stack, amount, slot);
        }
        return this.method_5441(slot);
    }

    public class_1799 insertItem(class_1799 stack, int amount, int slot) {
        int insertedCount = stack.method_7947();
        if (this.insertItemSilent(stack, amount, slot).method_7947() != insertedCount) {
            this.playSound(stack.method_7960() ? PlaySound.INSERT : PlaySound.TAKE);
        }
        return stack.method_7960() ? class_1799.field_8037 : stack;
    }

    public class_1799 insertItemSilent(class_1799 stack, int amount, int slot) {
        if (stack.method_7960() || !this.canPlaceItem(stack)) {
            return stack;
        }
        int weight = this.weightByItem(stack);
        Traits.LocalData traits = this.getTraits();
        if (weight == 0 || traits == null || Kind.is(traits.kind, Kind.POT, Kind.CAULDRON)) {
            return stack;
        }
        boolean isServerSide = !this.level().method_8608();
        int spaceLeft = this.spaceLeft();
        int count = Math.min(spaceLeft / weight, amount);
        if (count > 0) {
            if (isServerSide && stack.method_7909() instanceof BackpackItem) {
                this.triggerAdvancements(SpecialCriterion.Special.LAYERED);
            }
            this.getItemStacks().add(slot, (Object)stack.method_46651(count));
            this.mergeItems();
            stack.method_7939(stack.method_7947() - count);
            this.method_5431();
        }
        if (isServerSide && Kind.LEATHER.is(traits.kind) && spaceLeft - weight * amount < 1) {
            this.triggerAdvancements(SpecialCriterion.Special.FILLED_LEATHER);
        }
        return stack;
    }

    private void triggerAdvancements(SpecialCriterion.Special special) {
        class_5568 class_55682 = this.getOwner();
        if (class_55682 instanceof class_3222) {
            class_3222 thisPlayer = (class_3222)class_55682;
            Services.REGISTRY.triggerSpecial(thisPlayer, special);
        }
        for (class_3222 otherPlayers : this.getPlayersViewing()) {
            Services.REGISTRY.triggerSpecial(otherPlayers, special);
        }
    }

    private void triggerHopper() {
        EntityAbstract entityAbstract;
        class_1657 class_16572;
        class_5568 class_55682 = this.getOwner();
        if (class_55682 instanceof EntityAbstract && (class_16572 = (entityAbstract = (EntityAbstract)class_55682).method_37908().method_18470(entityAbstract.getPlacedBy())) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            Services.REGISTRY.triggerSpecial(serverPlayer, SpecialCriterion.Special.HOPPER);
            if (entityAbstract instanceof EntityEnder) {
                Services.REGISTRY.triggerSpecial(serverPlayer, SpecialCriterion.Special.ENDER_HOPPER);
            }
        }
    }

    public int spaceLeft() {
        if (this.getTraits().kind == null) {
            return 0;
        }
        int weight = 0;
        for (class_1799 stack : this.getItemStacks()) {
            weight += this.weightByItem(stack) * stack.method_7947();
        }
        return this.getTraits().maxStacks() * 64 - weight;
    }

    public int weightByItem(class_1799 stack) {
        if (ServerSave.CONFIG.override_all_item_weights > 0) {
            return ServerSave.CONFIG.override_all_item_weights;
        }
        if (Kind.isBackpack(stack)) {
            return 16;
        }
        if (stack.method_7960()) {
            return 0;
        }
        MapConfigVariant<class_1792, Integer> itemWeights = ServerSave.CONFIG.item_weight_override;
        if (itemWeights.contains(stack.method_7909())) {
            return itemWeights.get(stack.method_7909());
        }
        return 64 / stack.method_7914();
    }

    public void mergeItems() {
        for (int j = this.getItemStacks().size() - 2; j > -1; --j) {
            class_1799 lookSlot = this.method_5438(j);
            for (int i = 0; i < this.getItemStacks().size(); ++i) {
                class_1799 compare;
                if (i == j || !class_1799.method_31577((class_1799)lookSlot, (class_1799)(compare = this.method_5438(i)))) continue;
                lookSlot.method_7933(compare.method_7947());
                compare.method_7939(0);
            }
        }
        this.getItemStacks().removeIf(class_1799::method_7960);
    }

    public void readStackNbt(class_2487 nbt) {
        this.method_5448();
        BackpackInventory.readStackNbt(nbt, this.getItemStacks());
    }

    public static void readStackNbt(class_2487 nbt, class_2371<class_1799> itemStacks) {
        class_2499 nbtList = nbt.method_10554("Items", 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            class_1799 stack = new class_1799((class_1935)class_7923.field_41178.method_10223(new class_2960(nbtCompound.method_10558("id"))), nbtCompound.method_10550("Count"));
            if (nbtCompound.method_10573("tag", 10)) {
                stack.method_7980(nbtCompound.method_10562("tag"));
                stack.method_7909().method_7860(stack.method_7969());
            }
            if (stack.method_7963()) {
                stack.method_7974(stack.method_7919());
            }
            if (stack.method_7960()) continue;
            itemStacks.add((Object)stack);
        }
    }

    public void writeNbt(class_2487 nbt) {
        BackpackInventory.writeNbt(nbt, this.getItemStacks());
    }

    public static void writeNbt(class_2487 nbt, class_2371<class_1799> stacks) {
        class_2499 nbtList = new class_2499();
        for (int i = 0; i < stacks.size(); ++i) {
            class_1799 itemStack = (class_1799)stacks.get(i);
            if (itemStack.method_7960()) continue;
            class_2487 nbtCompound = new class_2487();
            nbtCompound.method_10567("Slot", (byte)i);
            class_2960 identifier = class_7923.field_41178.method_10221((Object)itemStack.method_7909());
            nbtCompound.method_10582("id", identifier.toString());
            nbtCompound.method_10569("Count", itemStack.method_7947());
            if (itemStack.method_7969() != null) {
                nbtCompound.method_10566("tag", (class_2520)itemStack.method_7969().method_10553());
            }
            nbtList.add((Object)nbtCompound);
        }
        if (!nbtList.isEmpty() || stacks.isEmpty()) {
            nbt.method_10566("Items", (class_2520)nbtList);
        }
    }

    public boolean canPlaceItem(class_1799 inserted) {
        if (IConfig.blacklistedItem(inserted.method_7909())) {
            return false;
        }
        boolean isEmpty = this.getItemStacks().isEmpty();
        boolean isFull = this.spaceLeft() < 1;
        return isEmpty || !isFull;
    }

    public void method_5431() {
    }

    public boolean method_5443(class_1657 viewer) {
        class_5568 owner = this.getOwner();
        if (owner instanceof class_1297) {
            class_1297 entity = (class_1297)owner;
            return !entity.method_31481() && viewer.method_5739(entity) < 5.0f;
        }
        return true;
    }

    public void method_5432(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.removeViewer(serverPlayer);
        }
        if (this.getViewable().getViewers() < 1) {
            this.playSound(PlaySound.CLOSE);
        }
    }

    public static BackpackInventory get(class_5568 entity) {
        if (entity instanceof EntityAbstract) {
            EntityAbstract backpack = (EntityAbstract)entity;
            return backpack.getInventory();
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return BackData.get(player).getBackpackInventory();
        }
        if (entity instanceof EnderInventory) {
            EnderInventory ender = (EnderInventory)entity;
            return ender;
        }
        return null;
    }

    public class_3908 getMenuProvider() {
        return Services.NETWORK.getMenuProvider(this.getOwner());
    }

    public boolean hopperTakeOne(class_1263 hopper) {
        if (this.method_5442() || this.stopHopper()) {
            return false;
        }
        for (int i = 0; i < hopper.method_5439(); ++i) {
            class_1799 hopperItem = hopper.method_5438(i);
            int matchSlot = this.matchesSlot(hopperItem);
            if (matchSlot != -1 && hopperItem.method_7947() < hopperItem.method_7914() && !this.method_5438(matchSlot).method_7960()) {
                hopperItem.method_7933(1);
                this.removeItemSilent(matchSlot, 1);
                this.triggerHopper();
                return true;
            }
            if (!hopperItem.method_7960() || this.method_5442()) continue;
            hopper.method_5447(i, this.removeItemSilent(this.method_5439() - 1, 1));
            this.triggerHopper();
            return true;
        }
        return false;
    }

    public boolean hopperInsertOne(class_1263 hopper) {
        if (this.stopHopper()) {
            return false;
        }
        for (int i = 0; i < hopper.method_5439(); ++i) {
            class_1799 hopperItem = hopper.method_5438(i);
            if (hopperItem.method_7960()) continue;
            this.insertItem(hopperItem, 1, 0);
            this.triggerHopper();
            return true;
        }
        return false;
    }

    private int matchesSlot(class_1799 stack) {
        for (int j = this.method_5439() - 1; j >= 0; --j) {
            class_1799 item = this.method_5438(j);
            if (!class_1799.method_31577((class_1799)item, (class_1799)stack)) continue;
            return j;
        }
        return -1;
    }
}

