/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.inventory;

import com.beansgalaxy.backpacks.data.EnderStorage;
import com.beansgalaxy.backpacks.data.ServerSave;
import com.beansgalaxy.backpacks.data.Traits;
import com.beansgalaxy.backpacks.entity.Kind;
import com.beansgalaxy.backpacks.events.PlaySound;
import com.beansgalaxy.backpacks.inventory.BackpackInventory;
import com.beansgalaxy.backpacks.network.clientbound.SendEnderSound;
import com.beansgalaxy.backpacks.network.clientbound.SendEnderStacks;
import com.beansgalaxy.backpacks.platform.Services;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_5568;
import net.minecraft.class_5569;
import net.minecraft.class_7417;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.server.MinecraftServer;

public class EnderInventory
extends BackpackInventory
implements class_5568 {
    public final HashMap<UUID, EnderStorage.Location> locations = new HashMap();
    private final UUID uuid;
    private final class_1937 level;
    private final Traits.LocalData traits;
    private class_2487 trim = new class_2487();
    private class_2561 playerName = class_2561.method_43473();
    private boolean locked;

    public EnderInventory(UUID uuid, class_1937 level) {
        this.uuid = uuid;
        this.level = level;
        this.traits = new Traits.LocalData("", Kind.ENDER, 0xFFFFFF, null, (class_2561)class_2561.method_43473()){

            @Override
            public class_2487 getTrim() {
                return EnderInventory.this.trim;
            }
        };
    }

    private EnderInventory getEnderData() {
        return EnderStorage.getEnderData(this.uuid, this.level());
    }

    private EnderStorage getEnderStorage() {
        return EnderStorage.get(this.level());
    }

    public EnderInventory setTrim(class_2487 trim) {
        if (trim != null) {
            this.trim = trim;
        }
        return this;
    }

    public class_2487 getTrim() {
        if (this.trim == null) {
            this.trim = new class_2487();
        }
        return this.trim;
    }

    public class_2561 getPlayerName() {
        return this.playerName;
    }

    public class_5250 getPlayerNameColored(class_5455 access) {
        class_2583 style = class_2583.field_24360;
        if (!this.trim.method_33133()) {
            class_1799 copy = Services.REGISTRY.getEnder().method_7854();
            copy.method_7948().method_10566("Trim", (class_2520)this.trim);
            Optional armorTrim = class_8053.method_48428((class_5455)access, (class_1799)copy);
            if (armorTrim.isPresent()) {
                style = ((class_8054)((class_8053)armorTrim.get()).method_48431().comp_349()).comp_1212().method_10866();
            }
        }
        return this.playerName.method_27661().method_27696(style);
    }

    public EnderInventory setItemStacks(class_2371<class_1799> stacks) {
        if (stacks == null) {
            return this;
        }
        this.getItemStacks().clear();
        this.getItemStacks().addAll(stacks);
        return this;
    }

    public EnderInventory setPlayerName(class_2561 name) {
        if (name != null && !name.equals(class_7417.field_39004)) {
            this.playerName = name;
        }
        return this;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public boolean stopHopper() {
        return this.isLocked();
    }

    @Override
    public class_5568 getOwner() {
        return this;
    }

    @Override
    public void playSound(PlaySound sound, float volume) {
        class_1937 class_19372 = this.level();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            ArrayList<class_1297> holders = new ArrayList<class_1297>();
            this.getEnderStorage().forEachHolding(this.method_5667(), ctx -> holders.add(ctx.entity()));
            SendEnderSound.send(holders, sound, volume, serverLevel);
        }
    }

    @Override
    public Traits.LocalData getTraits() {
        return this.traits;
    }

    @Override
    public UUID getPlacedBy() {
        return this.uuid;
    }

    @Override
    public class_1937 level() {
        return this.level;
    }

    @Override
    public void method_5431() {
        MinecraftServer server = this.level().method_8503();
        if (server != null) {
            ServerSave save = ServerSave.getSave(server, true);
            save.enderStorage.forEachViewing(this.uuid, viewer -> SendEnderStacks.send(viewer, this.uuid));
        }
        super.method_5431();
    }

    public int method_5628() {
        return -1;
    }

    public UUID method_5667() {
        return this.uuid;
    }

    public class_2338 method_24515() {
        return new class_2338(0, 0, 0);
    }

    public class_238 method_5829() {
        return new class_238(this.method_24515(), this.method_24515());
    }

    public void method_31744(class_5569 var1) {
    }

    public Stream<? extends class_5568> method_24204() {
        return Stream.empty();
    }

    public Stream<? extends class_5568> method_31748() {
        return Stream.empty();
    }

    public void method_31745(class_1297.class_5529 var1) {
    }

    public boolean method_31746() {
        return false;
    }

    public boolean method_31747() {
        return false;
    }

    public void flagForUpdate(class_1937 level) {
        int limit = 64;
        for (EnderStorage.Location location : this.locations.values()) {
            if (limit == 0) {
                return;
            }
            level.method_8455(location.location, class_2246.field_10124);
            --limit;
        }
    }
}

