/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.items;

import com.beansgalaxy.backpacks.access.BucketLikeAccess;
import com.beansgalaxy.backpacks.access.BucketsAccess;
import com.beansgalaxy.backpacks.data.BackData;
import com.beansgalaxy.backpacks.data.Traits;
import com.beansgalaxy.backpacks.entity.EntityAbstract;
import com.beansgalaxy.backpacks.entity.Kind;
import com.beansgalaxy.backpacks.events.PlaySound;
import com.beansgalaxy.backpacks.inventory.BackpackInventory;
import com.beansgalaxy.backpacks.inventory.CauldronInventory;
import com.beansgalaxy.backpacks.inventory.PotInventory;
import com.beansgalaxy.backpacks.items.Tooltip;
import com.beansgalaxy.backpacks.network.clientbound.SendBackInventory;
import com.beansgalaxy.backpacks.screen.BackpackMenu;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5536;
import net.minecraft.class_5630;

public class BackpackItem
extends class_1792 {
    public BackpackItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1269 method_7884(class_1838 ctx) {
        class_1799 backpackStack;
        class_2338 clickedPos;
        class_2350 direction;
        class_1657 player = ctx.method_8036();
        if (BackpackItem.useOnBlock(player, direction = ctx.method_8038(), clickedPos = ctx.method_8037(), backpackStack = ctx.method_8041(), false).booleanValue()) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static boolean interact(class_1799 backStack, class_5536 clickAction, class_1657 player, class_5630 access, boolean shiftIsDown) {
        boolean quickMove;
        class_1799 cursorStack = access.method_32327();
        Kind kind = Kind.fromStack(backStack);
        if (kind == null) {
            return false;
        }
        BackData backData = BackData.get(player);
        BackpackInventory backpackInventory = backData.getBackpackInventory();
        if (backStack != backData.getStack()) {
            return false;
        }
        class_1937 level = player.method_37908();
        boolean bl = quickMove = backData.menusKeyDown || shiftIsDown;
        if (Kind.CAULDRON.is(kind)) {
            return BackpackItem.handleCauldronClick(backStack, player, access, cursorStack, level);
        }
        if (Kind.POT.is(kind)) {
            return BackpackItem.handlePotClick(backStack, player, access, cursorStack, quickMove, clickAction);
        }
        if (backpackInventory.method_5442() && (cursorStack.method_7960() || Kind.isWearable(cursorStack))) {
            return false;
        }
        if (Kind.ENDER.is(kind) && level.method_8608()) {
            return true;
        }
        if (quickMove && clickAction != class_5536.field_27014) {
            BackpackItem.handleQuickMove(player.method_31548(), backpackInventory);
            return true;
        }
        return access.method_32332(BackpackMenu.menuInsert(clickAction == class_5536.field_27014 ? 1 : 0, cursorStack, 0, backpackInventory));
    }

    private static boolean handlePotClick(class_1799 pot, class_1657 player, class_5630 access, class_1799 cursorStack, boolean quickMove, class_5536 clickAction) {
        class_1937 level = player.method_37908();
        if (quickMove && clickAction != class_5536.field_27014) {
            class_1799 take;
            class_1661 inventory = player.method_31548();
            if (inventory.method_7376() != -1 && (take = PotInventory.take(pot, false, level)) != null) {
                inventory.method_7398(take);
                return true;
            }
            return pot.method_7941("back_slot") != null;
        }
        class_1799 tookStack = null;
        if (clickAction.equals((Object)class_5536.field_27014) && !cursorStack.method_7960()) {
            class_1799 insertedStack = cursorStack.method_46651(1);
            class_1799 add = PotInventory.add(pot, insertedStack, player);
            if (add != null && add.method_7960()) {
                cursorStack.method_7934(1);
                return true;
            }
        } else {
            tookStack = cursorStack.method_7960() ? PotInventory.take(pot, class_5536.field_27014.equals((Object)clickAction), level) : PotInventory.add(pot, cursorStack, player);
        }
        if (tookStack != null) {
            access.method_32332(tookStack);
            return true;
        }
        return pot.method_7941("back_slot") != null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static boolean handleCauldronClick(class_1799 backStack, class_1657 player, class_5630 access, class_1799 cursorStack, class_1937 level) {
        void var8_15;
        BucketsAccess bucketsAccess;
        class_1747 blockItem;
        class_2248 class_22482;
        class_1792 returned;
        class_1792 bucket;
        block14: {
            BucketsAccess bucketsAccess2;
            bucket = cursorStack.method_7909();
            returned = null;
            class_1792 class_17922 = CauldronInventory.getBucket(backStack);
            if (class_17922 instanceof BucketsAccess && (bucketsAccess2 = (BucketsAccess)class_17922).getEmptyInstance().equals(bucket)) {
                class_1792 class_17923 = CauldronInventory.remove(backStack);
                if (!class_17923.equals(class_1802.field_8162)) {
                    returned = class_17923;
                    break block14;
                } else {
                    if (!backStack.method_7985()) return false;
                    if (backStack.method_7941("back_slot") == null) return false;
                    return true;
                }
            }
            if (CauldronInventory.sizeLeft(backStack) > 0) {
                returned = CauldronInventory.add(backStack, bucket);
            }
        }
        if (returned == null) {
            if (!backStack.method_7985()) return false;
            if (backStack.method_7941("back_slot") == null) return false;
            return true;
        }
        class_1799 newStack = class_1799.field_8037;
        Optional optional = Optional.empty();
        if (bucket instanceof class_1747 && (class_22482 = (blockItem = (class_1747)bucket).method_7711()) instanceof BucketLikeAccess) {
            BucketLikeAccess bucketLikeAccess = (BucketLikeAccess)class_22482;
            if (returned.equals(bucketLikeAccess.getEmptyInstance())) {
                newStack = bucketLikeAccess.getEmptyInstance().method_7854();
                Optional<class_3414> optional2 = Optional.of(bucketLikeAccess.defaultPlaceSound());
            } else {
                newStack = bucketLikeAccess.getFilledInstance().method_7854();
                Optional<class_3414> optional3 = bucketLikeAccess.getPickupSound();
            }
        } else if (bucket instanceof BucketsAccess && returned.equals((bucketsAccess = (BucketsAccess)bucket).getEmptyInstance())) {
            newStack = bucketsAccess.getEmptyInstance().method_7854();
            Optional<class_3414> optional4 = Optional.ofNullable(bucketsAccess.defaultPlaceSound());
        } else if (returned instanceof BucketsAccess) {
            BucketsAccess bucketsAccess3 = (BucketsAccess)returned;
            newStack = returned.method_7854();
            Optional<class_3414> optional5 = bucketsAccess3.getPickupSound();
        }
        if (level.method_8608() && var8_15.isPresent()) {
            Tooltip.playSound((class_3414)var8_15.get(), 1.0f, 0.4f);
        }
        if (cursorStack.method_7947() == 1) {
            access.method_32332(newStack);
            return true;
        }
        cursorStack.method_7934(1);
        player.method_31548().method_7398(newStack);
        return true;
    }

    public static void handleQuickMove(class_1661 playerInventory, BackpackInventory backpackInventory) {
        class_1799 stack = backpackInventory.method_5438(0);
        if (stack.method_7960() || Kind.CAULDRON.is(backpackInventory.getTraits().kind)) {
            return;
        }
        class_1799 backpackStack = backpackInventory.removeItemSilent(0);
        class_1799 stack1 = backpackInventory.method_5438(1);
        int count = backpackStack.method_7947();
        int maxStackSize = backpackStack.method_7914();
        if (maxStackSize > count && class_1799.method_31577((class_1799)backpackStack, (class_1799)stack1)) {
            int normalizedCount = count - maxStackSize;
            stack1.method_7934(normalizedCount);
            backpackStack.method_7933(normalizedCount);
        }
        BackpackItem.handleQuickMove(playerInventory, backpackInventory, backpackStack, 0);
    }

    public static void handleQuickMove(class_1661 playerInventory, BackpackInventory backpackInventory, int index) {
        if (playerInventory.method_7376() != -1) {
            class_1799 backpackStack = backpackInventory.removeItemSilent(index);
            BackpackItem.handleQuickMove(playerInventory, backpackInventory, backpackStack, index);
        }
    }

    private static void handleQuickMove(class_1661 playerInventory, BackpackInventory backpackInventory, class_1799 backpackStack, int index) {
        int maxStackSize = backpackStack.method_7914();
        boolean inserted = false;
        boolean canceled = false;
        while (!canceled) {
            int i = playerInventory.method_7390(backpackStack);
            if (i == -1) {
                i = playerInventory.method_7376();
            }
            if (i == -1) {
                canceled = true;
                continue;
            }
            class_1799 clickedStack = playerInventory.method_5438(i);
            if (class_1799.method_31577((class_1799)backpackStack, (class_1799)clickedStack)) {
                int count1 = backpackStack.method_7947();
                int total = count1 + clickedStack.method_7947();
                if (total < maxStackSize) {
                    clickedStack.method_7933(count1);
                    backpackStack.method_7934(count1);
                } else {
                    clickedStack.method_7939(maxStackSize);
                    backpackStack.method_7939(total - maxStackSize);
                }
            } else if (backpackStack.method_7947() > maxStackSize) {
                playerInventory.method_5447(i, backpackStack.method_46651(maxStackSize));
                backpackStack.method_7934(maxStackSize);
            } else {
                playerInventory.method_5447(i, backpackStack.method_51164());
            }
            if (!backpackStack.method_7960()) continue;
            canceled = true;
            inserted = true;
        }
        if (inserted) {
            backpackInventory.playSound(PlaySound.TAKE);
        }
        if (!backpackStack.method_7960()) {
            backpackInventory.insertItemSilent(backpackStack, backpackStack.method_7947(), 0);
        }
        if (backpackInventory.method_5439() > index && backpackInventory.method_5438(index).method_7960()) {
            backpackInventory.method_5441(index);
        }
    }

    public static class_1269 hotkeyOnBlock(class_1657 player, class_2350 direction, class_2338 clickedPos) {
        BackData backData = BackData.get(player);
        class_1799 backStack = backData.getStack();
        if (BackpackItem.useOnBlock(player, direction, clickedPos, backStack, true).booleanValue()) {
            backData.setChanged();
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                SendBackInventory.send(serverPlayer);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private static Boolean useOnBlock(class_1657 player, class_2350 direction, class_2338 clickedPos, class_1799 backpackStack, boolean fromBackSlot) {
        boolean spaceEmpty;
        class_1937 level = player.method_37908();
        boolean isVertical = direction.method_10166().method_10178();
        class_2338 blockPos = isVertical && level.method_8320(clickedPos).method_26220((class_1922)level, clickedPos).method_1110() ? clickedPos : clickedPos.method_10093(direction);
        int y = blockPos.method_10264();
        class_238 box = EntityAbstract.newBox(blockPos, y, 0.5625, direction);
        double yOffset = (double)(direction.method_10166().method_10179() ? 3 : 1) / 16.0;
        if (isVertical) {
            boolean isRelative = !Objects.equals(blockPos, clickedPos);
            class_238 $$4 = new class_238(blockPos);
            if (isRelative) {
                $$4 = $$4.method_1012(0.0, -1.0, 0.0);
            }
            Iterable $$5 = level.method_8600(null, $$4);
            yOffset += class_259.method_1085((class_2350.class_2351)class_2350.class_2351.field_11052, (class_238)box, (Iterable)$$5, (double)(isRelative ? -2.0 : -1.0));
            if (level.method_18026($$4)) {
                yOffset += 1.0;
            }
        }
        return (spaceEmpty = level.method_18026(box.method_989(0.0, yOffset, 0.0))) && BackpackItem.doesPlace(player, blockPos.method_10263(), (double)y + yOffset, blockPos.method_10260(), direction, backpackStack, fromBackSlot);
    }

    public static class_1269 useOnBackpack(class_1657 player, EntityAbstract entityAbstract, class_1799 backpackStack, boolean fromBackSlot) {
        class_243 pos = entityAbstract.method_19538();
        class_2350 direction = entityAbstract.direction;
        int x = class_3532.method_15357((double)pos.field_1352);
        double y = pos.field_1351 + (double)(direction.method_10166().method_10179() ? 11 : 10) / 16.0;
        int z = class_3532.method_15357((double)pos.field_1350);
        class_238 box = entityAbstract.method_5829().method_989(0.0, 0.625, 0.0);
        boolean spaceEmpty = player.method_37908().method_18026(box);
        if (spaceEmpty && BackpackItem.doesPlace(player, x, y, z, direction, backpackStack, fromBackSlot)) {
            BackData.get(player).setChanged();
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static boolean doesPlace(class_1657 player, int x, double y, int z, class_2350 direction, class_1799 backpackStack, boolean fromBackSlot) {
        class_2371<class_1799> stacks = fromBackSlot ? BackData.get(player).getBackpackInventory().getItemStacks() : class_2371.method_10211();
        class_2338 blockPos = class_2338.method_49637((double)x, (double)y, (double)z);
        float yaw = BackpackItem.rotFromBlock(blockPos, player) + 90.0f;
        if (player.method_37908().method_8608()) {
            return true;
        }
        EntityAbstract entityAbstract = EntityAbstract.create(backpackStack, x, y, z, yaw, false, direction, player, stacks);
        return entityAbstract != null;
    }

    private static float rotFromBlock(class_2338 blockPos, class_1657 player) {
        class_243 CPos = blockPos.method_46558();
        float YRot = (float)Math.toDegrees(Math.atan2(CPos.field_1350 - player.method_23321(), CPos.field_1352 - player.method_23317()));
        if (YRot < -180.0f) {
            YRot += 360.0f;
        } else if (YRot > 180.0f) {
            YRot -= 360.0f;
        }
        return YRot;
    }

    public class_2561 method_7864(class_1799 stack) {
        class_2487 display = stack.method_7969();
        Traits traits = Kind.getTraits(stack);
        if (display != null && display.method_10545("backpack_id")) {
            String key = display.method_10558("backpack_id");
            return class_2561.method_48321((String)("tooltip.beansbackpacks.name." + key), (String)traits.name);
        }
        return super.method_7864(stack);
    }

    public boolean method_31567(class_1799 stack) {
        return Tooltip.isBarVisible(stack);
    }

    public int method_31569(class_1799 stack) {
        return Tooltip.getBarWidth(stack);
    }

    public int method_31571(class_1799 $$0) {
        return Tooltip.barColor;
    }
}

