/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.items;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.access.InventoryScreenAccess;
import com.beansgalaxy.backpacks.data.BackData;
import com.beansgalaxy.backpacks.data.EnderStorage;
import com.beansgalaxy.backpacks.data.Traits;
import com.beansgalaxy.backpacks.entity.Kind;
import com.beansgalaxy.backpacks.events.KeyPress;
import com.beansgalaxy.backpacks.events.PlaySound;
import com.beansgalaxy.backpacks.inventory.BackpackInventory;
import com.beansgalaxy.backpacks.inventory.BackpackTooltip;
import com.beansgalaxy.backpacks.inventory.CauldronInventory;
import com.beansgalaxy.backpacks.inventory.EnderInventory;
import com.beansgalaxy.backpacks.inventory.PotInventory;
import com.beansgalaxy.backpacks.inventory.SpecialTooltip;
import com.beansgalaxy.backpacks.items.EnderBackpack;
import com.beansgalaxy.backpacks.platform.Services;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_163;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_5632;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class Tooltip {
    private static final class_5250 empty = class_2561.method_43470((String)"");
    private static final int BAR_COLOR = class_3532.method_15353((float)0.4f, (float)0.4f, (float)1.0f);
    private static final int FULL_COLOR = class_3532.method_15353((float)0.9f, (float)0.2f, (float)0.3f);
    public static int barColor = BAR_COLOR;
    private static final class_2960 SLOT_BACKPACK = new class_2960("sprites/empty_slot_backpack");
    private static final class_2960 SLOT_ELYTRA = new class_2960("sprites/empty_slot_elytra");
    private static final class_2960 SLOT_CAULDRON = new class_2960("sprites/empty_slot_cauldron");
    private static final class_2960 SLOT_POT = new class_2960("sprites/empty_slot_pot");

    public static Optional<class_5632> get(class_1799 stack) {
        Kind kind = Kind.fromStack(stack);
        if (kind == null) {
            return Optional.empty();
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return Optional.empty();
        }
        if (!(player.field_7512 instanceof class_1723)) {
            return Optional.empty();
        }
        BackData backData = BackData.get((class_1657)player);
        class_1799 equippedOnBack = backData.getStack();
        if (stack.equals(equippedOnBack)) {
            if (equippedOnBack.method_7941("back_slot") != null) {
                return Tooltip.specialTooltip(equippedOnBack, backData);
            }
            if (!backData.getBackpackInventory().method_5442()) {
                return Tooltip.backpackTooltip(backData);
            }
        }
        return Optional.empty();
    }

    private static Optional<class_5632> specialTooltip(class_1799 backStack, BackData backData) {
        class_2487 backTag = backStack.method_7941("back_slot");
        Traits.LocalData traits = backData.getTraits();
        if (backTag != null && backTag.method_10545("id") && backTag.method_10545("amount")) {
            String string = backTag.method_10558("id");
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(string));
            int amount = backTag.method_10550("amount");
            switch (traits.kind) {
                case POT: {
                    return Optional.of(new SpecialTooltip.Pot(item, amount));
                }
                case CAULDRON: {
                    return Optional.of(new SpecialTooltip.Cauldron(item, amount));
                }
            }
        }
        return Optional.empty();
    }

    @NotNull
    private static Optional<class_5632> backpackTooltip(BackData backData) {
        class_2371<class_1799> backpackList = backData.getBackpackInventory().getItemStacks();
        if (backpackList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new BackpackTooltip(backpackList));
    }

    private static int getItemOccupancy(class_1799 stack) {
        class_2487 nbtCompound;
        if ((stack.method_31574(class_1802.field_20416) || stack.method_31574(class_1802.field_20415)) && stack.method_7985() && (nbtCompound = class_1747.method_38072((class_1799)stack)) != null && !nbtCompound.method_10554("Bees", 10).isEmpty()) {
            return 64;
        }
        return 64 / stack.method_7914();
    }

    private static int getBundleOccupancy(class_2371<class_1799> defaultedList) {
        return defaultedList.stream().mapToInt(itemStack -> Tooltip.getItemOccupancy(itemStack) * itemStack.method_7947()).sum();
    }

    public static class_2561 name(class_1799 stack) {
        return class_2561.method_43470((String)Kind.getTraits((class_1799)stack).name);
    }

    public static void nullTitle(List<class_2561> components) {
        components.add((class_2561)class_2561.method_43469((String)"tooltip.beansbackpacks.null_title", (Object[])new Object[]{KeyPress.getKeyReadable(KeyPress.getMenusKeyBind()).method_27662().method_27692(class_124.field_1065)}));
    }

    public static boolean isBarVisible(class_1799 stack) {
        class_746 player = class_310.method_1551().field_1724;
        BackData backSlot = BackData.get((class_1657)player);
        return backSlot.getStack() == stack && !backSlot.getBackpackInventory().method_5442();
    }

    public static int getBarWidth(class_1799 stack) {
        class_746 player = class_310.method_1551().field_1724;
        BackData backData = BackData.get((class_1657)player);
        if (backData.getStack() != stack) {
            return 13;
        }
        BackpackInventory backpackInventory = backData.getBackpackInventory();
        int spaceLeft = backpackInventory.spaceLeft();
        int maxStacks = backpackInventory.getTraits().maxStacks();
        if (spaceLeft < 1) {
            barColor = FULL_COLOR;
            return 14;
        }
        if (spaceLeft < 65) {
            float progress = 1.0f - (float)spaceLeft / 64.0f;
            float ease = progress * 1.6f;
            float i = class_3532.method_15363((float)(ease + 0.5f), (float)0.0f, (float)1.0f);
            float j = class_3532.method_15363((float)(ease - 0.6f), (float)0.0f, (float)1.0f);
            barColor = class_3532.method_15353((float)class_3532.method_16439((float)i, (float)0.0f, (float)0.9f), (float)class_3532.method_16439((float)j, (float)0.9f, (float)0.4f), (float)0.3f);
        } else {
            barColor = BAR_COLOR;
        }
        int barWidth = class_3532.method_15384((double)((double)(spaceLeft * 13) / ((double)maxStacks * 64.0)));
        return 14 - barWidth;
    }

    public static void playSound(Traits.Sound sound, PlaySound playSound) {
        Tooltip.playSound(sound, playSound, 0.3f);
    }

    public static void playSound(Traits.Sound sound, PlaySound playSound, float volume) {
        PlaySound.Playable playable = playSound.getSound(sound);
        Tooltip.playSound(playable.event(), playable.pitch(), volume * playable.volume());
    }

    public static void playSound(class_3414 soundEvent, float pitch, float volume) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)soundEvent, (float)pitch, (float)volume));
    }

    public static void appendTooltip(class_1657 player, class_1836 flag, List<class_2561> components, Traits.LocalData traits, class_1799 instance) {
        Kind kind = traits.kind;
        switch (kind) {
            case POT: {
                if (PotInventory.getMaxSize() == 0) {
                    return;
                }
                components.add((class_2561)empty);
                if (instance.method_7985() && instance.method_7969().method_10545("back_slot")) break;
                components.add((class_2561)class_2561.method_43471((String)"tooltip.beansbackpacks.special_title"));
                components.add((class_2561)class_2561.method_43469((String)"tooltip.beansbackpacks.storage.stacks", (Object[])new Object[]{"\u00a79" + PotInventory.getMaxSize()}));
                components.add((class_2561)class_2561.method_43471((String)"tooltip.beansbackpacks.pot"));
                break;
            }
            case CAULDRON: {
                if (CauldronInventory.getMaxSize() == 0) {
                    return;
                }
                components.add((class_2561)empty);
                if (instance.method_7985() && instance.method_7969().method_10545("back_slot")) break;
                components.add((class_2561)class_2561.method_43471((String)"tooltip.beansbackpacks.special_title"));
                components.add((class_2561)class_2561.method_43469((String)"tooltip.beansbackpacks.cauldron", (Object[])new Object[]{"\u00a79" + CauldronInventory.getMaxSize() / 4}));
                break;
            }
            default: {
                components.add((class_2561)empty);
                components.add((class_2561)class_2561.method_43471((String)"tooltip.beansbackpacks.storage_title"));
                int maxStacks = traits.maxStacks();
                components.add((class_2561)class_2561.method_43469((String)"tooltip.beansbackpacks.storage.stacks", (Object[])new Object[]{"\u00a79" + maxStacks}));
                if (traits.fireResistant()) {
                    components.add((class_2561)class_2561.method_43471((String)"tooltip.beansbackpacks.storage.fire_resistant"));
                }
                if (Kind.ENDER.is(kind)) {
                    EnderBackpack enderBackpack = (EnderBackpack)instance.method_7909();
                    UUID uuid = enderBackpack.getOrCreateUUID(player, instance);
                    class_1937 level = player.method_37908();
                    EnderInventory enderData = EnderStorage.getEnderData(uuid, level);
                    class_5250 playerName = enderData.getPlayerNameColored(level.method_30349());
                    components.add((class_2561)class_2561.method_43469((String)"tooltip.beansbackpacks.ender", (Object[])new Object[]{playerName}));
                    if (enderData.isLocked()) {
                        components.add((class_2561)class_2561.method_43471((String)"tooltip.beansbackpacks.storage.locked"));
                    }
                } else if (instance.method_7985() && instance.method_7969().method_10577("Locked")) {
                    components.add((class_2561)class_2561.method_43471((String)"tooltip.beansbackpacks.storage.locked"));
                }
                String key = traits.backpack_id;
                if (!flag.method_8035() || Constants.isEmpty(key)) break;
                components.add((class_2561)class_2561.method_43469((String)"tooltip.beansbackpacks.hidden.backpack_id", (Object[])new Object[]{"\u00a78" + key}));
            }
        }
    }

    public static List<class_2960> getTextures() {
        class_2371 list = class_2371.method_10211();
        list.add((Object)SLOT_BACKPACK);
        class_634 connection = class_310.method_1551().method_1562();
        if (connection == null) {
            return list;
        }
        class_163 advancements = connection.method_2869().method_2863();
        if (Kind.isWearableElytra(class_1802.field_8833.method_8389()) && advancements.method_716(class_2960.method_12829((String)"end/root")) != null) {
            list.add((Object)SLOT_ELYTRA);
        }
        if (advancements.method_716(class_2960.method_12829((String)"beansbackpacks:info/decorated_pots")) != null) {
            list.add((Object)SLOT_POT);
        }
        if (advancements.method_716(class_2960.method_12829((String)"beansbackpacks:info/fluid_cauldrons")) != null) {
            list.add((Object)SLOT_CAULDRON);
        }
        return list;
    }

    public static boolean isCuriosMenu() {
        class_310 minecraft = class_310.method_1551();
        boolean b = minecraft.field_1724.field_7512 instanceof class_1723;
        boolean b1 = minecraft.field_1755 instanceof class_490;
        boolean b2 = Services.COMPAT.isModLoaded("curios");
        return b2 && b && !b1;
    }

    public static void pushInventoryMessage(class_2561 msg) {
        class_437 screen = class_310.method_1551().field_1755;
        if (screen instanceof InventoryScreenAccess) {
            InventoryScreenAccess access = (InventoryScreenAccess)screen;
            access.pushInventoryMessage(msg);
        }
    }
}

