/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.items.recipes;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.data.Traits;
import com.beansgalaxy.backpacks.platform.Services;
import com.google.gson.JsonObject;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;

public class Conversion
extends class_1852 {
    public static final String ID = "conversion";
    public static final class_2960 LOCATION = new class_2960("beansbackpacks", "conversion");
    public static final class_1865<Conversion> INSTANCE = new Serializer();
    private final String old_backpack_id;
    private final String new_backpack_id;

    public Conversion(class_2960 $$0, String oldBackpackId, String newBackpackId) {
        super($$0, class_7710.field_40251);
        this.old_backpack_id = oldBackpackId;
        this.new_backpack_id = newBackpackId;
    }

    public boolean matches(class_8566 craftingContainer, class_1937 level) {
        int containerSize = craftingContainer.method_5439();
        int empties = 1;
        for (int i = 0; i < containerSize; ++i) {
            class_1799 item = craftingContainer.method_5438(i);
            if (item.method_7960()) {
                ++empties;
                continue;
            }
            class_2487 tag = item.method_7969();
            if (tag != null && tag.method_10558("backpack_id").equals(this.old_backpack_id)) continue;
            return false;
        }
        return empties == containerSize;
    }

    @NotNull
    public class_1799 assemble(class_8566 craftingContainer, class_5455 registryAccess) {
        class_1799 stack = class_1799.field_8037;
        int containerSize = craftingContainer.method_5439();
        while (stack.method_7960() && containerSize >= 0) {
            class_1799 item;
            if ((item = craftingContainer.method_5438(--containerSize)).method_7960()) continue;
            class_2487 tag = item.method_7972().method_7948();
            tag.method_10582("backpack_id", this.new_backpack_id);
            class_1799 netherite = Services.REGISTRY.getMetal().method_7854();
            netherite.method_7980(tag);
            stack = netherite;
        }
        return stack;
    }

    public boolean method_8113(int i, int i1) {
        return true;
    }

    public boolean method_31584() {
        return Constants.isEmpty(this.old_backpack_id) || Constants.isEmpty(this.new_backpack_id);
    }

    @NotNull
    public class_1799 method_8110(class_5455 registryAccess) {
        return Traits.toStack(this.new_backpack_id);
    }

    public class_2371<class_1856> method_8117() {
        return class_2371.method_10212((Object)class_1856.method_8091((class_1935[])new class_1935[]{Services.REGISTRY.getMetal()}), (Object[])new class_1856[0]);
    }

    @NotNull
    public class_1865<?> method_8119() {
        return INSTANCE;
    }

    public static class Serializer
    implements class_1865<Conversion> {
        @NotNull
        public Conversion fromJson(class_2960 id, JsonObject jsonObject) {
            String oldBackpackId = class_3518.method_15265((JsonObject)jsonObject, (String)"old_backpack_id");
            String newBackpackId = class_3518.method_15265((JsonObject)jsonObject, (String)"new_backpack_id");
            return new Conversion(id, oldBackpackId, newBackpackId);
        }

        public void toNetwork(class_2540 buf, Conversion recipe) {
            buf.method_10814(recipe.old_backpack_id);
            buf.method_10814(recipe.new_backpack_id);
        }

        @NotNull
        public Conversion fromNetwork(class_2960 id, class_2540 buf) {
            String oldBackpackID = buf.method_19772();
            String newBackpackID = buf.method_19772();
            return new Conversion(id, oldBackpackID, newBackpackID);
        }
    }
}

