/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.items.recipes;

import com.beansgalaxy.backpacks.data.Traits;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;

public class Crafting
extends class_1852 {
    public static final String ID = "crafting";
    public static final class_2960 LOCATION = new class_2960("beansbackpacks", "crafting");
    public static final class_1865<Crafting> INSTANCE = new Serializer();
    private final String backpack_id;
    private final class_2371<class_1856> ingredients;

    public Crafting(class_2960 id, String backpack_id, class_2371<class_1856> ingredients) {
        super(id, class_7710.field_40250);
        this.backpack_id = backpack_id;
        this.ingredients = ingredients;
    }

    public boolean method_8118() {
        return false;
    }

    public boolean matches(class_8566 container, class_1937 level) {
        if (container.method_17398() != 3 || container.method_17397() != 3 || this.backpack_id == null || this.backpack_id.isEmpty()) {
            return false;
        }
        Traits traits = Traits.get(this.backpack_id);
        if (traits.isEmpty()) {
            return false;
        }
        if (this.ingredients.isEmpty()) {
            return false;
        }
        int i = 0;
        for (class_1856 ingredient : this.ingredients) {
            if (i >= container.method_5439()) {
                return false;
            }
            class_1799 item = container.method_5438(i);
            if (!ingredient.method_8093(item)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @NotNull
    public class_1799 assemble(class_8566 craftingContainer, class_5455 registryAccess) {
        return this.method_8110(registryAccess);
    }

    public boolean method_8113(int i, int i1) {
        return true;
    }

    public boolean method_31584() {
        return this.backpack_id == null || this.backpack_id.isEmpty();
    }

    @NotNull
    public class_1799 method_8110(class_5455 registryAccess) {
        return Traits.toStack(this.backpack_id);
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    @NotNull
    public class_1865<Crafting> method_8119() {
        return INSTANCE;
    }

    public static class Serializer
    implements class_1865<Crafting> {
        @NotNull
        public Crafting fromJson(class_2960 id, JsonObject jsonObject) {
            String key = class_3518.method_15253((JsonObject)jsonObject, (String)"backpack_id", (String)"");
            Map<String, class_1856> map = Serializer.keyFromJson(class_3518.method_15296((JsonObject)jsonObject, (String)"key"));
            String[] astring = Serializer.shrink(Serializer.patternFromJson(class_3518.method_15261((JsonObject)jsonObject, (String)"pattern")));
            int $$6 = astring[0].length();
            int $$7 = astring.length;
            class_2371<class_1856> ingredients = Serializer.dissolvePattern(astring, map, $$6, $$7);
            return new Crafting(id, key, ingredients);
        }

        static class_2371<class_1856> dissolvePattern(String[] $$0, Map<String, class_1856> $$1, int $$2, int $$3) {
            class_2371 $$4 = class_2371.method_10213((int)($$2 * $$3), (Object)class_1856.field_9017);
            HashSet $$5 = Sets.newHashSet($$1.keySet());
            $$5.remove(" ");
            for (int $$6 = 0; $$6 < $$0.length; ++$$6) {
                for (int $$7 = 0; $$7 < $$0[$$6].length(); ++$$7) {
                    String $$8 = $$0[$$6].substring($$7, $$7 + 1);
                    class_1856 $$9 = $$1.get($$8);
                    if ($$9 == null) {
                        throw new JsonSyntaxException("Pattern references symbol '" + $$8 + "' but it's not defined in the key");
                    }
                    $$5.remove($$8);
                    $$4.set($$7 + $$2 * $$6, (Object)$$9);
                }
            }
            if (!$$5.isEmpty()) {
                throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + $$5);
            }
            return $$4;
        }

        private static int firstNonSpace(String $$0) {
            int $$1;
            for ($$1 = 0; $$1 < $$0.length() && $$0.charAt($$1) == ' '; ++$$1) {
            }
            return $$1;
        }

        private static int lastNonSpace(String $$0) {
            int $$1;
            for ($$1 = $$0.length() - 1; $$1 >= 0 && $$0.charAt($$1) == ' '; --$$1) {
            }
            return $$1;
        }

        @VisibleForTesting
        static String[] shrink(String ... $$0) {
            int $$1 = Integer.MAX_VALUE;
            int $$2 = 0;
            int $$3 = 0;
            int $$4 = 0;
            for (int $$5 = 0; $$5 < $$0.length; ++$$5) {
                String $$6 = $$0[$$5];
                $$1 = Math.min($$1, Serializer.firstNonSpace($$6));
                int $$7 = Serializer.lastNonSpace($$6);
                $$2 = Math.max($$2, $$7);
                if ($$7 < 0) {
                    if ($$3 == $$5) {
                        ++$$3;
                    }
                    ++$$4;
                    continue;
                }
                $$4 = 0;
            }
            if ($$0.length == $$4) {
                return new String[0];
            }
            String[] $$8 = new String[$$0.length - $$4 - $$3];
            for (int $$9 = 0; $$9 < $$8.length; ++$$9) {
                $$8[$$9] = $$0[$$9 + $$3].substring($$1, $$2 + 1);
            }
            return $$8;
        }

        static String[] patternFromJson(JsonArray $$0) {
            String[] $$1 = new String[$$0.size()];
            if ($$1.length > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
            }
            if ($$1.length == 0) {
                throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
            }
            for (int $$2 = 0; $$2 < $$1.length; ++$$2) {
                String $$3 = class_3518.method_15287((JsonElement)$$0.get($$2), (String)("pattern[" + $$2 + "]"));
                if ($$3.length() > 3) {
                    throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
                }
                if ($$2 > 0 && $$1[0].length() != $$3.length()) {
                    throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
                }
                $$1[$$2] = $$3;
            }
            return $$1;
        }

        static Map<String, class_1856> keyFromJson(JsonObject $$0) {
            HashMap $$1 = Maps.newHashMap();
            for (Map.Entry stringJsonElementEntry : $$0.entrySet()) {
                if (((String)stringJsonElementEntry.getKey()).length() != 1) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)stringJsonElementEntry.getKey() + "' is an invalid symbol (must be 1 character only).");
                }
                if (" ".equals(stringJsonElementEntry.getKey())) {
                    throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                }
                $$1.put((String)stringJsonElementEntry.getKey(), class_1856.method_8102((JsonElement)((JsonElement)stringJsonElementEntry.getValue()), (boolean)false));
            }
            $$1.put(" ", class_1856.field_9017);
            return $$1;
        }

        public void toNetwork(class_2540 buf, Crafting recipe) {
            buf.method_10814(recipe.backpack_id);
            buf.writeInt(recipe.ingredients.size());
            for (class_1856 ingredient : recipe.ingredients) {
                ingredient.method_8088(buf);
            }
        }

        @NotNull
        public Crafting fromNetwork(class_2960 id, class_2540 buf) {
            String key = buf.method_19772();
            int size = buf.readInt();
            class_2371 ingredients = class_2371.method_10211();
            for (int i = 0; i < size; ++i) {
                class_1856 ingredient = class_1856.method_8086((class_2540)buf);
                ingredients.add((Object)ingredient);
            }
            return new Crafting(id, key, (class_2371<class_1856>)ingredients);
        }
    }
}

