/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.common;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.data.ServerSave;
import com.beansgalaxy.backpacks.data.Traits;
import com.beansgalaxy.backpacks.entity.Kind;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1792;
import net.minecraft.class_2170;
import net.minecraft.class_2371;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_5350;
import net.minecraft.class_5455;
import net.minecraft.class_7699;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_5350.class})
public class DataResourcesMixin {
    @Inject(method={"loadResources"}, at={@At(value="HEAD")})
    private static void catchDataPacks(class_3300 resourceManager, class_5455.class_6890 frozen, class_7699 flagSet, class_2170.class_5364 commandSelection, int $$4, Executor $$5, Executor $$6, CallbackInfoReturnable<CompletableFuture<class_5350>> cir) {
        Constants.LOG.info("Reading Data for beansbackpacks");
        Constants.CHESTPLATE_DISABLED.clear();
        Constants.DISABLES_BACK_SLOT.clear();
        Constants.BLACKLIST_ITEMS.clear();
        class_2371<class_1792> blacklistItems = Constants.readItemList(resourceManager, "blacklist_items");
        Constants.addToList(Constants.BLACKLIST_ITEMS, blacklistItems);
        class_2371<class_1792> disableChestplate = Constants.readItemList(resourceManager, "disable_chestplate");
        Constants.addToList(Constants.CHESTPLATE_DISABLED, disableChestplate);
        class_2371<class_1792> disablesBackSlot = Constants.readItemList(resourceManager, "disables_back_slot");
        Constants.addToList(Constants.DISABLES_BACK_SLOT, disablesBackSlot);
        class_2371<class_1792> elytraItems = Constants.readItemList(resourceManager, "elytra_items");
        Constants.addToList(Constants.ELYTRA_ITEMS, elytraItems);
        Constants.CHESTPLATE_DISABLED.removeAll(Constants.DISABLES_BACK_SLOT);
        Traits.clear();
        resourceManager.method_14488("recipes/backpacks", in -> in.method_12832().endsWith(".json") && in.method_12836().equals("beansbackpacks")).forEach((resourceLocation, resource) -> {
            try {
                String line;
                BufferedReader bufferedReader = resource.method_43039();
                StringBuilder sb = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    sb.append(line);
                }
                bufferedReader.close();
                String string = sb.toString();
                JsonObject jsonObject = JsonParser.parseString((String)string).getAsJsonObject();
                String key = class_3518.method_15265((JsonObject)jsonObject, (String)"backpack_id").toLowerCase();
                Traits ironTraits = Traits.METAL;
                JsonObject settings = class_3518.method_15296((JsonObject)jsonObject, (String)"traits");
                String fallbackName = class_3518.method_15253((JsonObject)settings, (String)"fallback_name", (String)ironTraits.name);
                int maxStacks = class_3518.method_15282((JsonObject)settings, (String)"max_stacks", (int)((Integer)ServerSave.CONFIG.metal_max_stacks.get()));
                boolean fireResistant = class_3518.method_15258((JsonObject)settings, (String)"fire_resistant", (boolean)ironTraits.fireResistant);
                String button = class_3518.method_15253((JsonObject)settings, (String)"button", (String)ironTraits.button);
                String material = class_3518.method_15253((JsonObject)settings, (String)"material", null);
                String sound = class_3518.method_15253((JsonObject)settings, (String)"sound", (String)"hard");
                Traits.register(key, new Traits(fallbackName, fireResistant, button, material, maxStacks, sound));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        Traits.register("null", new Traits("Null Backpack", true, "none", null, 11, "hard"));
        for (Kind kind : Kind.values()) {
            Traits.register(kind.name(), kind.defaultTraits);
        }
    }
}

