/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.common;

import com.beansgalaxy.backpacks.access.BackAccessor;
import com.beansgalaxy.backpacks.data.BackData;
import com.beansgalaxy.backpacks.data.Traits;
import com.beansgalaxy.backpacks.entity.Kind;
import com.beansgalaxy.backpacks.inventory.BackpackInventory;
import com.beansgalaxy.backpacks.inventory.PotInventory;
import com.beansgalaxy.backpacks.network.clientbound.SendBackInventory;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1661.class})
public abstract class InventoryContainerMixin
implements BackAccessor {
    @Shadow
    @Final
    public class_1657 field_7546;
    @Shadow
    @Final
    public class_2371<class_1799> field_7547;
    @Unique
    private BackData backData;

    @Shadow
    public abstract boolean method_7367(int var1, class_1799 var2);

    @Override
    @Unique
    public BackData getBackData() {
        if (this.backData == null) {
            this.backData = new BackData(this.field_7546);
        }
        return this.backData;
    }

    @Inject(method={"save"}, at={@At(value="TAIL")})
    public void writeBackSlot(class_2499 tag, CallbackInfoReturnable<class_2499> cir) {
        BackData backData = this.getBackData();
        class_1799 backStack = backData.getStack();
        if (!backStack.method_7960()) {
            class_2487 compoundTag = new class_2487();
            class_2487 backItem = new class_2487();
            backStack.method_7953(backItem);
            compoundTag.method_10566("BackSlot", (class_2520)backItem);
            Traits.LocalData traits = backData.getTraits();
            BackpackInventory backpackInventory = backData.getBackpackInventory();
            if (!backpackInventory.method_5442() && !Kind.ENDER.is(traits.kind)) {
                class_2487 backTag1 = new class_2487();
                backpackInventory.writeNbt(backTag1);
                compoundTag.method_10566("Contents", (class_2520)backTag1);
            }
            tag.add((Object)compoundTag);
        }
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    public void readMixin(class_2499 tag, CallbackInfo info) {
        for (int i = 0; i < tag.size(); ++i) {
            class_2487 compoundTag = tag.method_10602(i);
            class_1799 itemStack = class_1799.method_7915((class_2487)compoundTag.method_10562("BackSlot"));
            if (itemStack.method_7960()) continue;
            BackData backData = this.getBackData();
            backData.set(itemStack);
            Traits.LocalData traits = backData.getTraits();
            if (!traits.isStorage() || Kind.ENDER.is(traits.kind)) continue;
            backData.getBackpackInventory().readStackNbt(compoundTag.method_10562("Contents"));
        }
    }

    @Inject(method={"add(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkCauldronPotItem(class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        class_2487 backTag;
        Kind kind = Kind.fromStack(stack);
        if (Kind.is(kind, Kind.POT, Kind.CAULDRON) && (backTag = stack.method_7941("back_slot")) != null) {
            BackData backData = this.getBackData();
            if (backData.getStack().method_7960()) {
                backData.set(stack.method_51164());
                cir.setReturnValue((Object)true);
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"add(ILnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void insertInventory(int slot, class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        class_1661 instance = (class_1661)this;
        if (slot == -1 && !stack.method_7960()) {
            BackData backData = this.getBackData();
            BackpackInventory backpackInventory = backData.getBackpackInventory();
            class_1799 backStack = backData.getStack();
            Traits.LocalData traits = backData.getTraits();
            if (Kind.POT.is(traits.kind)) {
                class_2487 backTag = backStack.method_7941("back_slot");
                if (backTag == null || !backTag.method_10545("id") || !backTag.method_10545("amount")) {
                    return;
                }
                instance.field_7547.forEach(stacks -> {
                    if (class_1799.method_31577((class_1799)stacks, (class_1799)stack)) {
                        int present = stacks.method_7947();
                        int inserted = stack.method_7947();
                        int count = present + inserted;
                        int remainder = Math.max(0, count - stack.method_7914());
                        stacks.method_7939(count -= remainder);
                        stack.method_7939(remainder);
                    }
                });
                if (stack.method_7960()) {
                    cir.setReturnValue((Object)true);
                    return;
                }
                class_1799 add = PotInventory.add(backStack, stack, this.field_7546);
                if (add != null) {
                    cir.setReturnValue((Object)true);
                }
            } else if (traits.isStorage() && backpackInventory.canPlaceItem(stack)) {
                instance.field_7547.forEach(stacks -> {
                    if (class_1799.method_31577((class_1799)stacks, (class_1799)stack)) {
                        int present = stacks.method_7947();
                        int inserted = stack.method_7947();
                        int count = present + inserted;
                        int remainder = Math.max(0, count - stack.method_7914());
                        stacks.method_7939(count -= remainder);
                        stack.method_7939(remainder);
                    }
                });
                AtomicBoolean didTake = new AtomicBoolean(false);
                backpackInventory.getItemStacks().forEach(stacks -> {
                    if (class_1799.method_31577((class_1799)stacks, (class_1799)stack)) {
                        backpackInventory.insertItemSilent(stack, stack.method_7947(), 0);
                        backpackInventory.method_5431();
                        didTake.set(true);
                    }
                });
                if (didTake.get()) {
                    cir.setReturnValue((Object)true);
                    class_1657 class_16572 = this.field_7546;
                    if (class_16572 instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)class_16572;
                        SendBackInventory.send(serverPlayer);
                    }
                }
            }
        }
    }

    @Inject(method={"add(ILnet/minecraft/world/item/ItemStack;)Z"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isDamaged()Z")})
    private void remapSlot(int slot, class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        if (slot == -2) {
            cir.setReturnValue((Object)this.method_7367(-1, stack));
        }
    }

    @Inject(method={"add(ILnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    public void insertBackpack(int $$0, class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            BackData backData = this.getBackData();
            BackpackInventory backpackInventory = backData.getBackpackInventory();
            Traits.LocalData traits = backData.getTraits();
            if (Kind.is(traits.kind, Kind.POT, Kind.CAULDRON)) {
                return;
            }
            if (!traits.isStorage()) {
                return;
            }
            if (backpackInventory.insertItemSilent(stack, stack.method_7947(), 0).method_7960()) {
                cir.setReturnValue((Object)true);
                class_1657 class_16572 = this.field_7546;
                if (class_16572 instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)class_16572;
                    SendBackInventory.send(serverPlayer);
                }
            }
        }
    }
}

