/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.common;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.access.BackAccessor;
import com.beansgalaxy.backpacks.config.IConfig;
import com.beansgalaxy.backpacks.data.BackData;
import com.beansgalaxy.backpacks.data.Traits;
import com.beansgalaxy.backpacks.entity.Kind;
import com.beansgalaxy.backpacks.events.PlaySound;
import com.beansgalaxy.backpacks.inventory.BackpackInventory;
import com.beansgalaxy.backpacks.inventory.CauldronInventory;
import com.beansgalaxy.backpacks.inventory.PotInventory;
import com.beansgalaxy.backpacks.items.BackpackItem;
import com.beansgalaxy.backpacks.items.Tooltip;
import com.beansgalaxy.backpacks.platform.Services;
import com.beansgalaxy.backpacks.screen.BackSlot;
import com.beansgalaxy.backpacks.screen.InSlot;
import java.util.Iterator;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1715;
import net.minecraft.class_1723;
import net.minecraft.class_1729;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3917;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1723.class}, priority=899)
public abstract class InventoryMenuMixin
extends class_1729<class_1715> {
    @Unique
    boolean cancelQuickMoveArmor = false;

    @Shadow
    public abstract class_1799 method_7601(class_1657 var1, int var2);

    public InventoryMenuMixin(class_3917<?> $$0, int $$1) {
        super($$0, $$1);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onConstructed(class_1661 playerInventory, boolean isServerSide, class_1657 player, CallbackInfo ci) {
        BackData backData = ((BackAccessor)playerInventory).getBackData();
        if (!Services.COMPAT.anyModsLoaded("curios", "trinkets")) {
            backData.backSlot.slotIndex = this.field_7761.size();
            this.method_7621(backData.backSlot);
        } else {
            this.method_7621(backData.inSlot);
        }
    }

    @Inject(method={"quickMoveStack"}, cancellable=true, at={@At(value="HEAD")})
    private void quickMove(class_1657 player, int slotInt, CallbackInfoReturnable<class_1799> cir) {
        boolean canQuickEquip;
        BackData backData = ((BackAccessor)player.method_31548()).getBackData();
        class_1735 slot = (class_1735)this.field_7761.get(slotInt);
        class_1799 stack = slot.method_7677();
        boolean bl = canQuickEquip = !Constants.SLOTS_MOD_ACTIVE || !player.method_7337();
        if (!(slot instanceof class_1734) && backData.isEmpty() && canQuickEquip && backData.mayEquip(stack, true, false)) {
            backData.set(stack.method_46651(1));
            stack.method_7934(1);
            cir.setReturnValue((Object)class_1799.field_8037);
            backData.playEquipSound(stack);
        }
    }

    @Redirect(method={"quickMoveStack"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/EquipmentSlot$Type;ARMOR:Lnet/minecraft/world/entity/EquipmentSlot$Type;"))
    private class_1304.class_1305 cancelArmorEquip() {
        return this.cancelQuickMoveArmor ? null : class_1304.class_1305.field_6178;
    }

    @Unique
    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        boolean selectedCrafting;
        if (slotIndex < 0 || this.field_7761.size() < slotIndex) {
            super.method_7593(slotIndex, button, actionType, player);
            return;
        }
        class_1735 slot = (class_1735)this.field_7761.get(slotIndex);
        class_1799 stack = slot.method_7677();
        boolean bl = selectedCrafting = slotIndex < 6 || slot instanceof class_1734;
        if (selectedCrafting) {
            super.method_7593(slotIndex, button, actionType, player);
            return;
        }
        BackData backData = BackData.get(player);
        class_1799 backStack = backData.getStack();
        boolean selectedBackSlot = slot instanceof BackSlot;
        boolean selectedPlayerInventory = slotIndex < 46 && slotIndex > 8;
        boolean selectedBackpackInventory = stack == backStack && !stack.method_7960() || slot instanceof InSlot;
        boolean selectedEquipment = !selectedPlayerInventory && !selectedBackpackInventory;
        class_1799 carried = this.method_34255();
        boolean cursorEmpty = carried.method_7960();
        class_1792 carriedItem = carried.method_7909();
        if (selectedEquipment && !selectedBackSlot && !cursorEmpty && IConfig.chestplateDisabled(carriedItem)) {
            return;
        }
        Traits.LocalData traits = backData.getTraits();
        Kind kind = traits.kind;
        class_1937 level = player.method_37908();
        if (!backData.isEmpty() && selectedEquipment && !cursorEmpty && Kind.isWings(carried) && Kind.isWings(backStack)) {
            if (level.field_9236) {
                Tooltip.pushInventoryMessage((class_2561)class_2561.method_43469((String)"entity.beansbackpacks.blocked.inventory", (Object[])new Object[]{Constants.getName(carried), Constants.getName(backStack)}));
            }
            return;
        }
        if (!backData.isEmpty() && actionType == class_1713.field_7794 && (IConfig.cantEquipWithBackpack(stack.method_7909()) || Kind.isWings(stack) && Kind.isWings(backStack))) {
            if (level.field_9236) {
                Tooltip.pushInventoryMessage((class_2561)class_2561.method_43469((String)"entity.beansbackpacks.blocked.inventory", (Object[])new Object[]{Constants.getName(stack), Constants.getName(backStack)}));
            }
            this.cancelQuickMoveArmor = true;
            super.method_7593(slotIndex, button, actionType, player);
            this.cancelQuickMoveArmor = false;
            return;
        }
        if (slotIndex < 9 || actionType == class_1713.field_7795) {
            super.method_7593(slotIndex, button, actionType, player);
            return;
        }
        BackpackInventory backpackInventory = backData.getBackpackInventory();
        if (actionType == class_1713.field_7793) {
            if (!selectedBackpackInventory) {
                super.method_7593(slotIndex, button, actionType, player);
                int sizeLeft = carried.method_7914() - carried.method_7947();
                this.beans_Backpacks_2$pickupAll(sizeLeft, backpackInventory, carried);
            }
            return;
        }
        if (selectedBackpackInventory) {
            class_5630 slotAccess;
            if (actionType == class_1713.field_7791) {
                return;
            }
            class_5536 clickAction = button == 1 ? class_5536.field_27014 : class_5536.field_27013;
            if (BackpackItem.interact(backStack, clickAction, player, slotAccess = new class_5630(){

                public class_1799 method_32327() {
                    return InventoryMenuMixin.this.method_34255();
                }

                public boolean method_32332(class_1799 stack) {
                    InventoryMenuMixin.this.method_34254(stack);
                    return true;
                }
            }, actionType == class_1713.field_7794)) {
                return;
            }
        }
        if (backData.menusKeyDown && selectedPlayerInventory) {
            if (backStack.method_7960() && backData.backSlot.method_7682() && !stack.method_7960() && Kind.isWearable(stack)) {
                slot.method_7673(backData.backSlot.method_32756(stack));
                return;
            }
            if (Kind.POT.is(kind)) {
                PotInventory.add(backStack, stack, player);
                return;
            }
            if (Kind.CAULDRON.is(kind)) {
                class_1799 returned = CauldronInventory.quickInsert(backStack, stack, level);
                if (!returned.method_7960()) {
                    if (stack.method_7960()) {
                        slot.method_7673(returned);
                    } else {
                        player.method_31548().method_7398(returned);
                    }
                }
                return;
            }
            if (traits.isStorage()) {
                if (!level.method_8608() || !Kind.ENDER.is(kind)) {
                    slot.method_7673(backpackInventory.insertItem(stack, stack.method_7947(), 0));
                }
                return;
            }
        }
        super.method_7593(slotIndex, button, actionType, player);
    }

    @Unique
    private void beans_Backpacks_2$pickupAll(int sizeLeft, BackpackInventory backpackInventory, class_1799 carried) {
        if (sizeLeft > 0) {
            boolean playSound = false;
            Iterator stacks = backpackInventory.getItemStacks().iterator();
            while (stacks.hasNext() && sizeLeft > 0) {
                int count;
                class_1799 backpackItem = (class_1799)stacks.next();
                if (!class_1799.method_31577((class_1799)backpackItem, (class_1799)carried) || (count = Math.min(sizeLeft, backpackItem.method_7947())) <= 0) continue;
                playSound = true;
                backpackItem.method_7934(count);
                carried.method_7933(count);
                sizeLeft -= count;
                if (!backpackItem.method_7960()) continue;
                stacks.remove();
            }
            if (playSound) {
                backpackInventory.playSound(PlaySound.TAKE, 0.8f);
            }
            backpackInventory.mergeItems();
        }
    }
}

