/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.network.clientbound;

import com.beansgalaxy.backpacks.client.network.CommonAtClient;
import com.beansgalaxy.backpacks.data.Traits;
import com.beansgalaxy.backpacks.events.PlaySound;
import com.beansgalaxy.backpacks.network.Network2C;
import com.beansgalaxy.backpacks.network.clientbound.Packet2C;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;

public class SendEnderSound
implements Packet2C {
    public static final ArrayList<SendEnderSound> soundQue = new ArrayList();
    public final PlaySound sound;
    public final ArrayList<class_2338> posList;
    public double volume;

    public SendEnderSound(PlaySound sound, double volume, ArrayList<class_2338> posList) {
        this.sound = sound;
        this.volume = volume;
        this.posList = posList;
    }

    public SendEnderSound(class_2540 buf) {
        this.sound = (PlaySound)buf.method_10818(PlaySound.class);
        this.volume = buf.readDouble();
        this.posList = new ArrayList(buf.method_34066(class_2540::method_10811));
    }

    @Override
    public Network2C getNetwork() {
        return Network2C.ENDER_SOUND_2C;
    }

    public static void send(List<class_1297> owners, PlaySound sound, float volume, class_3218 level) {
        PlaySound.Playable playable = sound.getSound(Traits.Sound.VWOOMP);
        float range = playable.event().method_43044(playable.volume());
        for (class_3222 player : level.method_18456()) {
            ArrayList<class_2338> posList = new ArrayList<class_2338>();
            double vTotal = 0.0;
            double vHighest = 0.0;
            for (class_1297 owner : owners) {
                if (player.method_37908().method_27983() != owner.method_37908().method_27983()) continue;
                class_243 pPos = player.method_19538();
                class_243 ePos = owner.method_19538();
                double v = (double)range - ePos.method_1022(pPos);
                if (!(v > 0.0)) continue;
                posList.add(class_2338.method_49638((class_2374)ePos));
                vTotal += v;
                if (!(v > vHighest)) continue;
                vHighest = v;
            }
            if (posList.isEmpty() || !(vTotal > 0.0)) continue;
            double vFinal = vHighest / vTotal;
            new SendEnderSound(sound, vFinal * (double)volume, posList).send2C(player);
        }
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10817((Enum)this.sound);
        buf.writeDouble(this.volume);
        buf.method_34062(this.posList, class_2540::method_10807);
    }

    @Override
    public void handle() {
        CommonAtClient.receiveEnderSoundEvent(this);
    }

    public static void indexSounds(class_1657 player) {
        while (!soundQue.isEmpty()) {
            SendEnderSound ctx = soundQue.get(0);
            if (!ctx.posList.isEmpty()) {
                class_2338 pos = ctx.posList.remove(0);
                PlaySound.Playable play = ctx.sound.getSound(Traits.Sound.VWOOMP);
                float vol = (float)(ctx.volume * (double)play.volume());
                player.method_37908().method_43128(player, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, play.event(), class_3419.field_15245, vol, play.pitch());
                return;
            }
            soundQue.remove(0);
        }
    }
}

