/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.platform;

import com.beansgalaxy.backpacks.compat.TrinketsRegistry;
import com.beansgalaxy.backpacks.data.BackData;
import com.beansgalaxy.backpacks.data.ServerSave;
import com.beansgalaxy.backpacks.data.config.Gamerules;
import com.beansgalaxy.backpacks.inventory.CauldronInventory;
import com.beansgalaxy.backpacks.platform.services.CompatHelper;
import com.beansgalaxy.backpacks.screen.BackSlot;
import java.awt.Color;
import java.util.List;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3611;

public class FabricCompatHelper
implements CompatHelper {
    @Override
    public boolean isModLoaded(String namespace) {
        return FabricLoader.getInstance().isModLoaded(namespace);
    }

    @Override
    public void setBackSlotItem(BackData backData, class_1799 stack) {
        if (this.isModLoaded("trinkets")) {
            TrinketsRegistry.setBackStack(stack, backData);
        }
    }

    @Override
    public class_1799 getBackSlotItem(BackData backData, class_1799 defaultItem) {
        if (this.isModLoaded("trinkets")) {
            return TrinketsRegistry.getBackStack(backData, defaultItem);
        }
        return defaultItem;
    }

    @Override
    public List<class_1799> backSlotDisabled(class_1657 owner) {
        if (this.isModLoaded("trinkets")) {
            return TrinketsRegistry.backSlotDisabled((class_1309)owner);
        }
        return List.of();
    }

    @Override
    public boolean isBackSlot(class_1735 slot) {
        if (this.isModLoaded("trinkets")) {
            return TrinketsRegistry.isBackSlot(slot);
        }
        return slot instanceof BackSlot;
    }

    @Override
    public CauldronInventory.FluidAttributes getFluidTexture(class_3611 fluid, class_1059 blocksAtlas) {
        FluidVariant fluidVariant = FluidVariant.of((class_3611)fluid);
        class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)fluidVariant);
        int color = FluidVariantRendering.getColor((FluidVariant)fluidVariant);
        return new CauldronInventory.FluidAttributes(sprite, new Color(color));
    }

    @Override
    public boolean invokeListenersOnDeath(BackData backData) {
        Context context = new Context(backData);
        ((OnDeathCallback)OnDeathCallback.EVENT.invoker()).onDeath(context);
        return context.isCancelled;
    }

    public class Context {
        private final BackData backData;
        private boolean isCancelled = false;

        public Context(BackData backData) {
            this.backData = backData;
        }

        public class_1657 getPlayer() {
            return this.backData.owner;
        }

        public class_1263 getBackInventory() {
            return this.backData.getBackpackInventory();
        }

        public class_1799 getBackStack() {
            return this.backData.getStack();
        }

        public void setBackStack(class_1799 backStack) {
            this.backData.set(backStack);
        }

        public boolean keepBackSlotGamerule() {
            return ServerSave.GAMERULES.get((Object)Gamerules.KEEP_BACK_SLOT);
        }

        public void cancel() {
            this.isCancelled = true;
        }
    }

    public static interface OnDeathCallback {
        public static final Event<OnDeathCallback> EVENT = EventFactory.createArrayBacked(OnDeathCallback.class, listeners -> context -> {
            for (OnDeathCallback listener : listeners) {
                listener.onDeath(context);
            }
        });

        public void onDeath(Context var1);
    }
}

