/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.platform.services;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.data.BackData;
import com.beansgalaxy.backpacks.data.EnderStorage;
import com.beansgalaxy.backpacks.entity.EntityAbstract;
import com.beansgalaxy.backpacks.inventory.CauldronInventory;
import com.beansgalaxy.backpacks.inventory.EnderInventory;
import com.beansgalaxy.backpacks.network.clientbound.SendBackInventory;
import com.beansgalaxy.backpacks.platform.Services;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1059;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;

public interface CompatHelper {
    public static final String CURIOS = "curios";
    public static final String TRINKETS = "trinkets";
    public static final String ELYTRA_SLOT = "elytraslot";
    public static final String MOD_MENU = "modmenu";
    public static final String CLOTH_CONFIG = "cloth-config";

    public boolean isModLoaded(String var1);

    default public boolean anyModsLoaded(String ... namespaces) {
        for (String namespace : namespaces) {
            if (!this.isModLoaded(namespace)) continue;
            return true;
        }
        return false;
    }

    default public boolean allModsLoaded(String ... namespaces) {
        for (String namespace : namespaces) {
            if (this.isModLoaded(namespace)) continue;
            return false;
        }
        return true;
    }

    public List<class_1799> backSlotDisabled(class_1657 var1);

    public boolean isBackSlot(class_1735 var1);

    public CauldronInventory.FluidAttributes getFluidTexture(class_3611 var1, class_1059 var2);

    default public boolean graveModLoaded() {
        return this.anyModsLoaded("universal-graves", "yigd", "gravestones", "forgottengraves");
    }

    public void setBackSlotItem(BackData var1, class_1799 var2);

    public class_1799 getBackSlotItem(BackData var1, class_1799 var2);

    public boolean invokeListenersOnDeath(BackData var1);

    default public void updateEnderEntry(@NotNull UUID uuid, Optional<class_2561> name, Optional<class_2487> trim, class_1937 level) {
        EnderInventory data = EnderStorage.get((class_1937)level).MAP.computeIfAbsent(uuid, uuid1 -> new EnderInventory(uuid, level));
        name.ifPresent(data::setPlayerName);
        trim.ifPresent(data::setTrim);
    }

    default public void updateEnderEntry(@NotNull UUID uuid, @Nullable String name, boolean translatable, @Nullable String trim, class_1937 level) {
        Optional<Object> component = name == null ? Optional.empty() : (translatable ? Optional.of(class_2561.method_43471((String)name)) : Optional.of(class_2561.method_43470((String)name)));
        Optional<class_2487> tag = Optional.empty();
        if (trim != null && Constants.isEmpty(trim)) {
            try {
                tag = Optional.of(class_2512.method_32260((String)trim));
            }
            catch (CommandSyntaxException e) {
                Constants.LOG.error("beansbackpacks: Failed to create Ender Data with the name \"" + name + "\"");
            }
        }
        this.updateEnderEntry(uuid, component, tag, level);
    }

    default public class_1799 createEnderBackpack(Optional<UUID> uuid, boolean persistent) {
        class_1799 ePack = Services.REGISTRY.getEnder().method_7854();
        class_2487 tag = ePack.method_7948();
        uuid.ifPresent(in -> tag.method_25927("owner", in));
        if (persistent) {
            tag.method_10556("persistent_ender", true);
        }
        return ePack;
    }

    @Nullable
    public static class_1297 createBackpackEntity(class_1799 backpackStack, int x, double y, int z, float yaw, boolean onDeath, class_2350 direction, class_1937 level, UUID uuid, class_2371<class_1799> stacks) {
        return EntityAbstract.create(backpackStack, x, y, z, yaw, onDeath, direction, level, uuid, stacks);
    }

    public static class_2371<class_1799> getBackpackInventory(class_1657 player) {
        return BackData.get(player).getBackpackInventory().getItemStacks();
    }

    public static void updateBackpackInventory2C(class_3222 player) {
        SendBackInventory.send(player);
    }

    public static class_1799 getBackStack(class_1657 player) {
        return BackData.get(player).getStack();
    }

    public static void setBackStack(class_1657 player, class_1799 backStack) {
        BackData.get(player).set(backStack);
    }

    public static BackData getBackData(class_1657 player) {
        return BackData.get(player);
    }
}

