/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.screen;

import com.beansgalaxy.backpacks.data.BackData;
import com.beansgalaxy.backpacks.data.EnderStorage;
import com.beansgalaxy.backpacks.data.Traits;
import com.beansgalaxy.backpacks.data.Viewable;
import com.beansgalaxy.backpacks.entity.Backpack;
import com.beansgalaxy.backpacks.entity.EntityEnder;
import com.beansgalaxy.backpacks.entity.Kind;
import com.beansgalaxy.backpacks.events.PlaySound;
import com.beansgalaxy.backpacks.inventory.BackpackInventory;
import com.beansgalaxy.backpacks.items.BackpackItem;
import com.beansgalaxy.backpacks.network.clientbound.SendBackInventory;
import com.beansgalaxy.backpacks.platform.Services;
import com.beansgalaxy.backpacks.screen.MenuSlot;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_5568;

public class BackpackMenu
extends class_1703 {
    public static int FIRST_SLOT_INDEX;
    public final BackpackInventory backpackInventory;
    protected final Backpack mirror;
    protected final class_1657 viewer;
    protected final class_5568 owner;
    protected final class_2371<MenuSlot> backpackSlots = class_2371.method_10211();
    public int invOffset = 108;

    public BackpackMenu(int id, class_1661 playerInventory, final BackpackInventory backpackInventory) {
        super(Services.REGISTRY.getMenu(), id);
        this.backpackInventory = backpackInventory;
        this.owner = backpackInventory.getOwner();
        this.viewer = playerInventory.field_7546;
        this.mirror = new Backpack(this.viewer.method_37908()){

            @Override
            public UUID getPlacedBy() {
                return backpackInventory.getPlacedBy();
            }

            @Override
            public Traits.LocalData getTraits() {
                return backpackInventory.getTraits();
            }

            @Override
            public Viewable getViewable() {
                return backpackInventory.getViewable();
            }
        };
        this.createInventorySlots(playerInventory);
        this.createBackpackSlots(backpackInventory);
        FIRST_SLOT_INDEX = this.field_7761.size();
        class_1657 class_16572 = this.viewer;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            class_16572 = this.owner;
            if (class_16572 instanceof EntityEnder) {
                EntityEnder ender = (EntityEnder)class_16572;
                EnderStorage.Location.update(ender.getPlacedBy(), serverPlayer.method_51469());
            }
        }
    }

    public void method_7623() {
        class_5568 class_55682 = this.owner;
        if (class_55682 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_55682;
            SendBackInventory.send(serverPlayer);
        }
        if (!this.backpackInventory.getTraits().kind.is(Kind.ENDER)) {
            SendBackInventory.send(this);
        }
    }

    public void method_7609(class_1263 $$0) {
        super.method_7609($$0);
    }

    public BackpackMenu(int id, class_1661 playerInv, class_2540 buf) {
        this(id, playerInv, BackpackMenu.getBackpackInventory(buf, playerInv.field_7546.method_37908()));
    }

    public static BackpackInventory getBackpackInventory(class_2540 buf, class_1937 level) {
        int id = buf.readInt();
        if (id == -1) {
            UUID uuid = buf.method_10790();
            return EnderStorage.getEnderData(uuid, level);
        }
        class_1297 entity = level.method_8469(id);
        return BackpackInventory.get((class_5568)entity);
    }

    private void createBackpackSlots(BackpackInventory inventory) {
        for (int i = 0; i < 70; ++i) {
            this.backpackSlots.add((Object)new MenuSlot(this, i, this::updateSlots));
        }
        for (class_1735 backpackSlot : this.backpackSlots) {
            this.method_7621(backpackSlot);
        }
        this.updateSlots();
    }

    public void method_7610(int $$0, List<class_1799> $$1, class_1799 $$2) {
    }

    public void updateSlots() {
        boolean hasSpace = this.backpackInventory.spaceLeft() > 0;
        int size = this.backpackInventory.method_5439();
        int shift = Math.max(0, size - 69 - (hasSpace ? 0 : 1));
        for (MenuSlot backpackSlot : this.backpackSlots) {
            int[] xy;
            int backIndex = backpackSlot.backIndex;
            if (backIndex + shift < size) {
                backpackSlot.field_7874 = backIndex + 36;
                backpackSlot.state = MenuSlot.State.ACTIVE;
                xy = MenuSlot.getXY(this.backpackInventory, backIndex, hasSpace);
                backpackSlot.field_7873 = xy[0];
                backpackSlot.field_7872 = xy[1];
                continue;
            }
            if (hasSpace && backIndex + shift == size) {
                backpackSlot.field_7874 = size + 36;
                backpackSlot.state = MenuSlot.State.EMPTY;
                xy = MenuSlot.getXY(this.backpackInventory, -1, true);
                backpackSlot.field_7873 = xy[0];
                backpackSlot.field_7872 = xy[1];
                continue;
            }
            backpackSlot.field_7874 = backIndex + 36;
            backpackSlot.state = MenuSlot.State.HIDDEN;
            backpackSlot.field_7873 = 0;
            backpackSlot.field_7872 = 0;
        }
    }

    private void createInventorySlots(class_1661 playerInventory) {
        for (int l = 0; l < 3; ++l) {
            for (int k = 0; k < 9; ++k) {
                this.method_7621(new class_1735((class_1263)playerInventory, k + l * 9 + 9, 8 + k * 18, l * 18 + 51 + this.invOffset));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.method_7621(new class_1735((class_1263)playerInventory, i1, 8 + i1 * 18, 109 + this.invOffset));
        }
    }

    public boolean method_7615(class_1735 slot) {
        return !(slot instanceof MenuSlot);
    }

    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        this.handleClick(slotIndex, button, actionType, player);
        this.updateSlots();
    }

    private void handleClick(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        class_1735 class_17352;
        class_1799 carried = this.method_34255();
        boolean carriedEmpty = carried.method_7960();
        if (slotIndex >= this.field_7761.size()) {
            if (carriedEmpty) {
                return;
            }
            slotIndex = this.field_7761.size() - 1;
        }
        int backIndex = -1;
        if (slotIndex > 0 && (class_17352 = this.method_7611(slotIndex)) instanceof MenuSlot) {
            MenuSlot menuSlot = (MenuSlot)class_17352;
            if (carriedEmpty && menuSlot.method_7677().method_7960()) {
                return;
            }
            backIndex = menuSlot.backIndex;
        }
        if (actionType == class_1713.field_7795) {
            super.method_7593(slotIndex, button, actionType, player);
            return;
        }
        if (actionType == class_1713.field_7793) {
            if (backIndex == -1) {
                super.method_7593(slotIndex, button, actionType, player);
            }
            return;
        }
        if (BackData.get((class_1657)player).menusKeyDown) {
            actionType = class_1713.field_7794;
        }
        if (backIndex != -1) {
            if (actionType == class_1713.field_7794) {
                BackpackItem.handleQuickMove(player.method_31548(), this.backpackInventory, backIndex);
            } else {
                if (backIndex >= this.backpackInventory.getItemStacks().size()) {
                    backIndex = 0;
                } else if (!carriedEmpty) {
                    ++backIndex;
                }
                this.method_34254(BackpackMenu.menuInsert(button, carried, backIndex, this.backpackInventory));
            }
            return;
        }
        super.method_7593(slotIndex, button, actionType, player);
    }

    public static class_1799 menuInsert(int button, class_1799 cursorStack, int slot, BackpackInventory backpackInventory) {
        if (button == 1) {
            if (cursorStack.method_7960()) {
                class_1799 stack = backpackInventory.method_5438(slot);
                int count = Math.max(1, Math.min(stack.method_7947(), stack.method_7914()) / 2);
                return backpackInventory.method_5434(slot, count);
            }
            return backpackInventory.returnItem(slot, cursorStack, 1);
        }
        return backpackInventory.returnItem(slot, cursorStack);
    }

    public class_1799 method_7601(class_1657 player, int slotId) {
        class_1735 clickedSlot = (class_1735)this.field_7761.get(slotId);
        class_1799 clickedStack = clickedSlot.method_7677();
        if (clickedStack == class_1799.field_8037) {
            return class_1799.field_8037;
        }
        if (slotId < FIRST_SLOT_INDEX) {
            if (this.backpackInventory.spaceLeft() < 1) {
                return class_1799.field_8037;
            }
            this.backpackInventory.insertItem(clickedStack, clickedStack.method_7947(), 0);
            clickedSlot.method_7673(clickedStack);
        } else {
            clickedStack = (class_1799)this.backpackInventory.getItemStacks().get(slotId - FIRST_SLOT_INDEX);
            this.method_7616(clickedStack, 0, FIRST_SLOT_INDEX, true);
            if (clickedStack.method_7960()) {
                this.backpackInventory.method_5441(slotId - FIRST_SLOT_INDEX);
                this.backpackInventory.playSound(PlaySound.TAKE);
            }
        }
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public void method_7595(class_1657 player) {
        this.backpackInventory.method_5432(player);
        this.mirror.method_31472();
        super.method_7595(player);
    }
}

