/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.screen.InfoTabs;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.config.ClientConfig;
import com.beansgalaxy.backpacks.data.config.MenuVisibility;
import com.beansgalaxy.backpacks.screen.InfoTabs.Tabs;
import java.awt.Color;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2371;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_507;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class InfoWidget
implements class_4068,
class_364,
class_6379 {
    private static final class_2960 TEXTURE = new class_2960("beansbackpacks", "textures/gui/info_tab.png");
    private class_507 recipeBook;
    public class_344 recipeButton;
    private class_310 minecraft;
    private int height;
    private int leftPos;
    private int topPos;
    private boolean focused = false;
    private Runnable onClick;
    private Tabs selected = Tabs.BACKPACK;
    public class_2371<Optional<InfoButton>> buttons = class_2371.method_10211();
    public HomeButton homeButton;
    public HideButton hideButton;
    HashSet<Tabs> hiddenTabs = new HashSet();

    public int updateScreenPosition(int i, boolean visible, int width, int imageWidth) {
        this.homeButton.setVisible(!visible);
        if (visible && this.focused) {
            this.toggleFocus();
        } else {
            i = (width - imageWidth) / 2 + (this.focused ? 60 : 0);
        }
        this.leftPos = i;
        this.recipeButton.method_48229(this.leftPos + 104, this.height / 2 - 22);
        this.updateButtonPositions(this.leftPos);
        return i;
    }

    public void updateButtonPositions(int leftPos) {
        for (Optional optional : this.buttons) {
            optional.ifPresent(button -> button.method_48229(button.tab.getX() + leftPos, button.tab.getY() + this.topPos));
        }
    }

    public void method_25394(class_332 ctx, int i, int i1, float v) {
        if (this.focused) {
            ctx.method_25291(TEXTURE, this.leftPos - 166, this.topPos + 22, 0, 1.0f, 53.0f, 167, 144, 256, 256);
            String lowerCase = this.minecraft.field_1724.method_5477().method_27662().getString().toLowerCase();
            class_5250 title = class_2561.method_43469((String)("help.beansbackpacks." + this.selected.name().toLowerCase() + "_title"), (Object[])new Object[]{lowerCase});
            class_5481 titleSequence = title.method_27692(class_124.field_1067).method_30937();
            int titleY = this.topPos + 29;
            this.drawCenteredText(ctx, titleSequence, titleY);
            this.drawCenteredLine(ctx, this.minecraft.field_1772.method_30880(titleSequence), titleY + 10);
            Color c = this.selected.color;
            int transparent = new Color(c.getRed(), c.getGreen(), c.getBlue(), 0).getRGB();
            ctx.method_33284(this.leftPos - 152, this.topPos + 25, this.leftPos - 1, this.topPos + 160, 0, transparent, c.getRGB());
            int stringY = 44;
            int hLineY = 0;
            class_2477 language = class_2477.method_10517();
            class_5481 visualOrderText = null;
            for (int j = 0; j < 16; ++j) {
                String key = "help.beansbackpacks." + this.selected.name().toLowerCase() + j;
                if (!language.method_4678(key)) {
                    if (visualOrderText != null) {
                        stringY += 2;
                    }
                    --hLineY;
                    ++stringY;
                    continue;
                }
                boolean hLine = language.method_48307(key).chars().allMatch(ch -> ch == 45);
                if (hLine && visualOrderText != null) {
                    this.drawCenteredLine(ctx, this.minecraft.field_1772.method_30880(visualOrderText), this.topPos + stringY + hLineY);
                    hLineY = 0;
                    stringY += 5;
                    continue;
                }
                class_5250 mutableComponent = class_2561.method_48322((String)key, (String)"", (Object[])new Object[]{this.selected.getVarForLine(this.minecraft, j)});
                visualOrderText = mutableComponent.method_30937();
                this.drawCenteredText(ctx, visualOrderText, this.topPos + stringY - 1);
                hLineY = 0;
                stringY += 9;
            }
            for (Tabs tab : Tabs.values()) {
                if (!tab.isUnlocked(this.minecraft)) continue;
                tab.render(ctx, this.leftPos - 19, this.topPos + 4);
            }
        }
    }

    private void drawCenteredText(class_332 gui, class_5481 text, int topPos) {
        class_327 font = this.minecraft.field_1772;
        gui.method_51430(font, text, this.leftPos - 79 + 2 - font.method_30880(text) / 2, topPos, 0x404040, false);
    }

    private void drawCenteredLine(class_332 gui, int width, int topPos) {
        int left = this.leftPos - 79 + 2 - width / 2;
        int average = (100 - width) / 10;
        gui.method_25292(left + width + average, left - average, topPos, -7631989);
    }

    @NotNull
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    public void init(int height, int leftPos, int topPos, class_310 minecraft, class_507 recipeBookComponent, Runnable onClick) {
        this.minecraft = minecraft;
        this.height = height;
        this.leftPos = leftPos;
        this.topPos = topPos + 1;
        this.onClick = onClick;
        this.recipeBook = recipeBookComponent;
        this.focused = false;
        if (((MenuVisibility)((Object)Constants.CLIENT_CONFIG.menu_visibility.get())).equals((Object)MenuVisibility.HIDE_ABLE)) {
            this.hiddenTabs = (HashSet)Constants.CLIENT_CONFIG.hidden_tabs.get();
        }
        this.homeButton = new HomeButton(this, button -> this.onButtonClick(Tabs.BACKPACK));
        this.hideButton = new HideButton(this, button -> {
            this.toggleHidden();
            onClick.run();
        });
        this.updateVisible();
        this.buttons.clear();
        this.buttons.add(Optional.of(this.homeButton));
        for (Tabs tab : Tabs.values()) {
            if (tab == Tabs.BACKPACK) continue;
            this.buttons.add(this.createInfoButton(tab));
        }
    }

    public void updateVisible() {
        boolean menuEnabled = !this.isHidden() || this.focused;
        boolean RecipeBookClosed = !this.recipeBook.method_2605();
        boolean BeganProgress = Tabs.BACKPACK.isUnlocked(this.minecraft);
        this.homeButton.setVisible(menuEnabled && RecipeBookClosed && BeganProgress);
    }

    private Optional<InfoButton> createInfoButton(Tabs tab) {
        if (tab.isUnlocked(this.minecraft)) {
            return Optional.of(new InfoButton(tab, this.leftPos, this.topPos, button -> this.onButtonClick(tab)));
        }
        return Optional.empty();
    }

    private void onButtonClick(Tabs selected) {
        if (this.selected == selected) {
            this.setSelected(Tabs.BACKPACK);
            this.toggleFocus();
        } else {
            this.setSelected(selected);
        }
        this.onClick.run();
    }

    public void setSelected(Tabs selected) {
        this.selected = selected;
    }

    public void toggleFocus() {
        this.method_25365(!this.focused);
        for (Optional optional : this.buttons) {
            optional.ifPresent(button -> {
                if (button != this.homeButton) {
                    button.setVisible(this.focused);
                }
                if (!this.focused) {
                    button.method_25365(false);
                }
            });
        }
        this.hideButton.setVisible(this.focused);
        if (!this.focused) {
            this.hideButton.method_25365(false);
        }
    }

    public void method_25365(boolean b) {
        this.focused = b;
    }

    public boolean method_25370() {
        return this.focused;
    }

    private boolean isHidden() {
        return !(switch ((MenuVisibility)((Object)Constants.CLIENT_CONFIG.menu_visibility.get())) {
            case MenuVisibility.HIDE_ABLE -> this.anyUnlockedNonHidden(this.hiddenTabs);
            case MenuVisibility.DISABLE -> false;
            default -> true;
        });
    }

    private boolean anyUnlockedNonHidden(HashSet<Tabs> hiddenTabs) {
        for (Tabs value : Tabs.values()) {
            if (hiddenTabs.contains((Object)value) || !value.isUnlocked(this.minecraft)) continue;
            return true;
        }
        return false;
    }

    private void toggleHidden() {
        boolean hidden = this.anyUnlockedNonHidden((HashSet)Constants.CLIENT_CONFIG.hidden_tabs.get());
        HashSet<Tabs> hiddenTabs = new HashSet<Tabs>();
        if (hidden) {
            for (Tabs tab : Tabs.values()) {
                if (!tab.isUnlocked(this.minecraft)) continue;
                hiddenTabs.add(tab);
            }
        }
        ClientConfig config = Constants.CLIENT_CONFIG;
        config.hidden_tabs.set(hiddenTabs);
        config.write();
    }

    public static class HomeButton
    extends InfoButton {
        private final InfoWidget parent;

        public HomeButton(InfoWidget parent, class_4185.class_4241 o) {
            super(Tabs.BACKPACK, parent.leftPos, parent.topPos, o);
            this.parent = parent;
            this.setVisible(!parent.isHidden());
        }

        @Override
        public void init() {
        }

        @Override
        public void setVisible(boolean visible) {
            if (!visible && this.parent.method_25370()) {
                this.parent.toggleFocus();
            }
            super.setVisible(visible);
        }

        public void method_48579(class_332 $$0, int $$1, int $$2, float $$3) {
            if (!this.parent.focused) {
                this.method_48588($$0, this.field_2127, this.method_46426(), this.method_46427(), 0, this.field_2125, this.field_19079, this.field_22758, this.field_22759, this.field_2124, this.field_19080);
            } else {
                super.method_48579($$0, $$1, $$2, $$3);
            }
        }
    }

    public static class HideButton
    extends class_4185 {
        private final InfoWidget parent;

        public HideButton(InfoWidget parent, class_4185.class_4241 onPress) {
            super(parent.leftPos + 44, parent.topPos + 146, 15, 16, class_5244.field_39003, onPress, Supplier::get);
            this.parent = parent;
            this.setVisible(false);
            this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"help.beansbackpacks.hide")));
        }

        public void setVisible(boolean visible) {
            boolean equals = ((MenuVisibility)((Object)Constants.CLIENT_CONFIG.menu_visibility.get())).equals((Object)MenuVisibility.HIDE_ABLE);
            this.field_22764 = visible && equals;
        }

        protected void method_48579(class_332 $$0, int $$1, int $$2, float $$3) {
            if (!this.parent.anyUnlockedNonHidden((HashSet)Constants.CLIENT_CONFIG.hidden_tabs.get())) {
                this.method_48588($$0, TEXTURE, this.method_46426(), this.method_46427(), 16, 198, this.method_25364(), this.method_25368(), this.method_25364(), 256, 256);
            } else {
                this.method_48588($$0, TEXTURE, this.method_46426(), this.method_46427(), 0, 198, this.method_25364(), this.method_25368(), this.method_25364(), 256, 256);
            }
        }
    }

    public static class InfoButton
    extends class_344 {
        private final Tabs tab;

        public InfoButton(Tabs tab, int leftPos, int topPos, class_4185.class_4241 o) {
            super(tab.getX() + leftPos, topPos + tab.getY(), 24, 25, tab.getTexX(), 0, 25, TEXTURE, o);
            this.tab = tab;
            this.init();
        }

        public void init() {
            this.setVisible(false);
        }

        public void setVisible(boolean visible) {
            this.field_22764 = visible;
        }

        public void method_25365(boolean focused) {
            super.method_25365(focused);
        }
    }
}

